/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.javatuples.Pair;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOUtil;
import org.jpos.security.ARPCMethod;
import org.jpos.security.EncryptedPIN;
import org.jpos.security.KeySerialNumber;
import org.jpos.security.MKDMethod;
import org.jpos.security.PaddingMethod;
import org.jpos.security.SKDMethod;
import org.jpos.security.SMAdapter;
import org.jpos.security.SMException;
import org.jpos.security.SecureDESKey;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Loggeable;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;
import org.jpos.util.SimpleMsg;

public class BaseSMAdapter
implements SMAdapter,
Configurable,
LogSource {
    protected Logger logger = null;
    protected String realm = null;
    protected Configuration cfg;
    private String name;

    public BaseSMAdapter() {
    }

    public BaseSMAdapter(Configuration cfg, Logger logger, String realm) throws ConfigurationException {
        this.setLogger(logger, realm);
        this.setConfiguration(cfg);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public void setName(String name) {
        this.name = name;
        NameRegistrar.register("s-m-adapter." + name, this);
    }

    public String getName() {
        return this.name;
    }

    public static SMAdapter getSMAdapter(String name) throws NameRegistrar.NotFoundException {
        return (SMAdapter)NameRegistrar.get("s-m-adapter." + name);
    }

    @Override
    public SecureDESKey generateKey(short keyLength, String keyType) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "Key Length", keyLength), new SimpleMsg("parameter", "Key Type", keyType)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Generate Key", cmdParameters));
        SecureDESKey result = null;
        try {
            result = this.generateKeyImpl(keyLength, keyType);
            evt.addMessage(new SimpleMsg("result", "Generated Key", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public byte[] generateKeyCheckValue(SecureDESKey kd) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "Key with untrusted check value", kd)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Generate Key Check Value", cmdParameters));
        byte[] result = null;
        try {
            result = this.generateKeyCheckValueImpl(kd);
            evt.addMessage(new SimpleMsg("result", "Generated Key Check Value", ISOUtil.hexString(result)));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public SecureDESKey importKey(short keyLength, String keyType, byte[] encryptedKey, SecureDESKey kek, boolean checkParity) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "Key Length", keyLength), new SimpleMsg("parameter", "Key Type", keyType), new SimpleMsg("parameter", "Encrypted Key", encryptedKey), new SimpleMsg("parameter", "Key-Encrypting Key", kek), new SimpleMsg("parameter", "Check Parity", checkParity)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Import Key", cmdParameters));
        SecureDESKey result = null;
        try {
            result = this.importKeyImpl(keyLength, keyType, encryptedKey, kek, checkParity);
            evt.addMessage(new SimpleMsg("result", "Imported Key", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public byte[] exportKey(SecureDESKey key, SecureDESKey kek) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "Key", key), new SimpleMsg("parameter", "Key-Encrypting Key", kek)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Export Key", cmdParameters));
        byte[] result = null;
        try {
            result = this.exportKeyImpl(key, kek);
            evt.addMessage(new SimpleMsg("result", "Exported Key", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN encryptPIN(String pin, String accountNumber, boolean extract) throws SMException {
        accountNumber = extract ? EncryptedPIN.extractAccountNumberPart(accountNumber) : accountNumber;
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "clear pin", pin), new SimpleMsg("parameter", "account number", accountNumber)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Encrypt Clear PIN", cmdParameters));
        EncryptedPIN result = null;
        try {
            result = this.encryptPINImpl(pin, accountNumber);
            evt.addMessage(new SimpleMsg("result", "PIN under LMK", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN encryptPIN(String pin, String accountNumber) throws SMException {
        return this.encryptPIN(pin, accountNumber, true);
    }

    @Override
    public String decryptPIN(EncryptedPIN pinUnderLmk) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "PIN under LMK", pinUnderLmk)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Decrypt PIN", cmdParameters));
        String result = null;
        try {
            result = this.decryptPINImpl(pinUnderLmk);
            evt.addMessage(new SimpleMsg("result", "clear PIN", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN importPIN(EncryptedPIN pinUnderKd1, SecureDESKey kd1) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "PIN under Data Key 1", pinUnderKd1), new SimpleMsg("parameter", "Data Key 1", kd1)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Import PIN", cmdParameters));
        EncryptedPIN result = null;
        try {
            result = this.importPINImpl(pinUnderKd1, kd1);
            evt.addMessage(new SimpleMsg("result", "PIN under LMK", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN translatePIN(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "PIN under Data Key 1", pinUnderKd1), new SimpleMsg("parameter", "Data Key 1", kd1), new SimpleMsg("parameter", "Data Key 2", kd2), new SimpleMsg("parameter", "Destination PIN Block Format", destinationPINBlockFormat)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Translate PIN from Data Key 1 to Data Key 2", cmdParameters));
        EncryptedPIN result = null;
        try {
            result = this.translatePINImpl(pinUnderKd1, kd1, kd2, destinationPINBlockFormat);
            evt.addMessage(new SimpleMsg("result", "PIN under Data Key 2", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN importPIN(EncryptedPIN pinUnderDuk, KeySerialNumber ksn, SecureDESKey bdk) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "PIN under Derived Unique Key", pinUnderDuk), new SimpleMsg("parameter", "Key Serial Number", ksn), new SimpleMsg("parameter", "Base Derivation Key", bdk)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Import PIN", cmdParameters));
        EncryptedPIN result = null;
        try {
            result = this.importPINImpl(pinUnderDuk, ksn, bdk);
            evt.addMessage(new SimpleMsg("result", "PIN under LMK", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN translatePIN(EncryptedPIN pinUnderDuk, KeySerialNumber ksn, SecureDESKey bdk, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "PIN under Derived Unique Key", pinUnderDuk), new SimpleMsg("parameter", "Key Serial Number", ksn), new SimpleMsg("parameter", "Base Derivation Key", bdk), new SimpleMsg("parameter", "Data Key 2", kd2), new SimpleMsg("parameter", "Destination PIN Block Format", destinationPINBlockFormat)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Translate PIN", cmdParameters));
        EncryptedPIN result = null;
        try {
            result = this.translatePINImpl(pinUnderDuk, ksn, bdk, kd2, destinationPINBlockFormat);
            evt.addMessage(new SimpleMsg("result", "PIN under Data Key 2", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN exportPIN(EncryptedPIN pinUnderLmk, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "PIN under LMK", pinUnderLmk), new SimpleMsg("parameter", "Data Key 2", kd2), new SimpleMsg("parameter", "Destination PIN Block Format", destinationPINBlockFormat)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Export PIN", cmdParameters));
        EncryptedPIN result = null;
        try {
            result = this.exportPINImpl(pinUnderLmk, kd2, destinationPINBlockFormat);
            evt.addMessage(new SimpleMsg("result", "PIN under Data Key 2", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public EncryptedPIN generatePIN(String accountNumber, int pinLen) throws SMException {
        return this.generatePIN(accountNumber, pinLen, null);
    }

    @Override
    public EncryptedPIN generatePIN(String accountNumber, int pinLen, List<String> excludes) throws SMException {
        ArrayList<SimpleMsg> cmdParameters = new ArrayList<SimpleMsg>();
        cmdParameters.add(new SimpleMsg("parameter", "account number", accountNumber));
        cmdParameters.add(new SimpleMsg("parameter", "PIN length", pinLen));
        if (excludes != null && !excludes.isEmpty()) {
            cmdParameters.add(new SimpleMsg("parameter", "Excluded PINs list", excludes));
        }
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Generate PIN", cmdParameters.toArray(new Loggeable[cmdParameters.size()])));
        EncryptedPIN result = null;
        try {
            result = this.generatePINImpl(accountNumber, pinLen, excludes);
            evt.addMessage(new SimpleMsg("result", "Generated PIN", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public String calculatePVV(EncryptedPIN pinUnderLMK, SecureDESKey pvkA, SecureDESKey pvkB, int pvkIdx) throws SMException {
        return this.calculatePVV(pinUnderLMK, pvkA, pvkB, pvkIdx, null);
    }

    @Override
    public String calculatePVV(EncryptedPIN pinUnderLMK, SecureDESKey pvkA, SecureDESKey pvkB, int pvkIdx, List<String> excludes) throws SMException {
        ArrayList<SimpleMsg> cmdParameters = new ArrayList<SimpleMsg>();
        cmdParameters.add(new SimpleMsg("parameter", "account number", pinUnderLMK.getAccountNumber()));
        cmdParameters.add(new SimpleMsg("parameter", "PIN under LMK", pinUnderLMK));
        cmdParameters.add(new SimpleMsg("parameter", "PVK-A", pvkA == null ? "" : pvkA));
        cmdParameters.add(new SimpleMsg("parameter", "PVK-B", pvkB == null ? "" : pvkB));
        cmdParameters.add(new SimpleMsg("parameter", "PVK index", pvkIdx));
        if (excludes != null && !excludes.isEmpty()) {
            cmdParameters.add(new SimpleMsg("parameter", "Excluded PINs list", excludes));
        }
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Calculate PVV", cmdParameters.toArray(new Loggeable[cmdParameters.size()])));
        String result = null;
        try {
            result = this.calculatePVVImpl(pinUnderLMK, pvkA, pvkB, pvkIdx, excludes);
            evt.addMessage(new SimpleMsg("result", "Calculated PVV", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public String calculatePVV(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvkA, SecureDESKey pvkB, int pvkIdx) throws SMException {
        return this.calculatePVV(pinUnderKd1, kd1, pvkA, pvkB, pvkIdx, null);
    }

    @Override
    public String calculatePVV(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvkA, SecureDESKey pvkB, int pvkIdx, List<String> excludes) throws SMException {
        ArrayList<SimpleMsg> cmdParameters = new ArrayList<SimpleMsg>();
        cmdParameters.add(new SimpleMsg("parameter", "account number", pinUnderKd1.getAccountNumber()));
        cmdParameters.add(new SimpleMsg("parameter", "PIN under Data Key 1", pinUnderKd1));
        cmdParameters.add(new SimpleMsg("parameter", "Data Key 1", kd1));
        cmdParameters.add(new SimpleMsg("parameter", "PVK-A", pvkA == null ? "" : pvkA));
        cmdParameters.add(new SimpleMsg("parameter", "PVK-B", pvkB == null ? "" : pvkB));
        cmdParameters.add(new SimpleMsg("parameter", "PVK index", pvkIdx));
        if (excludes != null && !excludes.isEmpty()) {
            cmdParameters.add(new SimpleMsg("parameter", "Excluded PINs list", excludes));
        }
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Calculate PVV", cmdParameters.toArray(new Loggeable[cmdParameters.size()])));
        String result = null;
        try {
            result = this.calculatePVVImpl(pinUnderKd1, kd1, pvkA, pvkB, pvkIdx, excludes);
            evt.addMessage(new SimpleMsg("result", "Calculated PVV", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public boolean verifyPVV(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvkA, SecureDESKey pvkB, int pvki, String pvv) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "account number", pinUnderKd1.getAccountNumber()), new SimpleMsg("parameter", "PIN under Data Key 1", pinUnderKd1), new SimpleMsg("parameter", "Data Key 1", kd1), new SimpleMsg("parameter", "PVK-A", pvkA == null ? "" : pvkA), new SimpleMsg("parameter", "PVK-B", pvkB == null ? "" : pvkB), new SimpleMsg("parameter", "pvki", pvki), new SimpleMsg("parameter", "pvv", pvv)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Verify a PIN Using the VISA Method", cmdParameters));
        try {
            boolean r = this.verifyPVVImpl(pinUnderKd1, kd1, pvkA, pvkB, pvki, pvv);
            evt.addMessage(new SimpleMsg("result", "Verification status", r ? "valid" : "invalid"));
            boolean bl = r;
            return bl;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public String calculateIBMPINOffset(EncryptedPIN pinUnderLmk, SecureDESKey pvk, String decTab, String pinValData, int minPinLen) throws SMException {
        return this.calculateIBMPINOffset(pinUnderLmk, pvk, decTab, pinValData, minPinLen, null);
    }

    @Override
    public String calculateIBMPINOffset(EncryptedPIN pinUnderLmk, SecureDESKey pvk, String decTab, String pinValData, int minPinLen, List<String> excludes) throws SMException {
        ArrayList<SimpleMsg> cmdParameters = new ArrayList<SimpleMsg>();
        cmdParameters.add(new SimpleMsg("parameter", "account number", pinUnderLmk.getAccountNumber()));
        cmdParameters.add(new SimpleMsg("parameter", "PIN under LMK", pinUnderLmk));
        cmdParameters.add(new SimpleMsg("parameter", "PVK", pvk));
        cmdParameters.add(new SimpleMsg("parameter", "decimalisation table", decTab));
        cmdParameters.add(new SimpleMsg("parameter", "PIN validation data", pinValData));
        cmdParameters.add(new SimpleMsg("parameter", "minimum PIN length", minPinLen));
        if (excludes != null && !excludes.isEmpty()) {
            cmdParameters.add(new SimpleMsg("parameter", "Excluded PINs list", excludes));
        }
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Calculate PIN offset", cmdParameters.toArray(new Loggeable[cmdParameters.size()])));
        String result = null;
        try {
            result = this.calculateIBMPINOffsetImpl(pinUnderLmk, pvk, decTab, pinValData, minPinLen, excludes);
            evt.addMessage(new SimpleMsg("result", "Calculated PIN offset", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public String calculateIBMPINOffset(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvk, String decTab, String pinValData, int minPinLen) throws SMException {
        return this.calculateIBMPINOffset(pinUnderKd1, kd1, pvk, decTab, pinValData, minPinLen, null);
    }

    @Override
    public String calculateIBMPINOffset(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvk, String decTab, String pinValData, int minPinLen, List<String> excludes) throws SMException {
        ArrayList<SimpleMsg> cmdParameters = new ArrayList<SimpleMsg>();
        cmdParameters.add(new SimpleMsg("parameter", "account number", pinUnderKd1.getAccountNumber()));
        cmdParameters.add(new SimpleMsg("parameter", "PIN under Data Key 1", pinUnderKd1));
        cmdParameters.add(new SimpleMsg("parameter", "Data Key 1", kd1));
        cmdParameters.add(new SimpleMsg("parameter", "PVK", pvk));
        cmdParameters.add(new SimpleMsg("parameter", "decimalisation table", decTab));
        cmdParameters.add(new SimpleMsg("parameter", "PIN validation data", pinValData));
        cmdParameters.add(new SimpleMsg("parameter", "minimum PIN length", minPinLen));
        if (excludes != null && !excludes.isEmpty()) {
            cmdParameters.add(new SimpleMsg("parameter", "Excluded PINs list", excludes));
        }
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Calculate PIN offset", cmdParameters.toArray(new Loggeable[cmdParameters.size()])));
        String result = null;
        try {
            result = this.calculateIBMPINOffsetImpl(pinUnderKd1, kd1, pvk, decTab, pinValData, minPinLen, excludes);
            evt.addMessage(new SimpleMsg("result", "Calculated PIN offset", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public boolean verifyIBMPINOffset(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvk, String offset, String decTab, String pinValData, int minPinLen) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "account number", pinUnderKd1.getAccountNumber()), new SimpleMsg("parameter", "PIN under Data Key 1", pinUnderKd1), new SimpleMsg("parameter", "Data Key 1", kd1), new SimpleMsg("parameter", "PVK", pvk), new SimpleMsg("parameter", "Pin block format", pinUnderKd1.getPINBlockFormat()), new SimpleMsg("parameter", "decimalisation table", decTab), new SimpleMsg("parameter", "PIN validation data", pinValData), new SimpleMsg("parameter", "minimum PIN length", minPinLen), new SimpleMsg("parameter", "offset", offset)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Verify PIN offset", cmdParameters));
        try {
            boolean r = this.verifyIBMPINOffsetImpl(pinUnderKd1, kd1, pvk, offset, decTab, pinValData, minPinLen);
            evt.addMessage(new SimpleMsg("result", "Verification status", r ? "valid" : "invalid"));
            boolean bl = r;
            return bl;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public EncryptedPIN deriveIBMPIN(String accountNo, SecureDESKey pvk, String decTab, String pinValData, int minPinLen, String offset) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "account number", accountNo), new SimpleMsg("parameter", "Offset", offset), new SimpleMsg("parameter", "PVK", pvk), new SimpleMsg("parameter", "Decimalisation table", decTab), new SimpleMsg("parameter", "PIN validation data", pinValData), new SimpleMsg("parameter", "Minimum PIN length", minPinLen)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Derive a PIN Using the IBM Method", cmdParameters));
        EncryptedPIN result = null;
        try {
            result = this.deriveIBMPINImpl(accountNo, pvk, decTab, pinValData, minPinLen, offset);
            evt.addMessage(new SimpleMsg("result", "Derived PIN", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public String calculateCVV(String accountNo, SecureDESKey cvkA, SecureDESKey cvkB, Date expDate, String serviceCode) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "account number", accountNo), new SimpleMsg("parameter", "cvk-a", cvkA == null ? "" : cvkA), new SimpleMsg("parameter", "cvk-b", cvkB == null ? "" : cvkB), new SimpleMsg("parameter", "Exp date", expDate), new SimpleMsg("parameter", "Service code", serviceCode)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Calculate CVV/CVC", cmdParameters));
        String result = null;
        try {
            result = this.calculateCVVImpl(accountNo, cvkA, cvkB, expDate, serviceCode);
            evt.addMessage(new SimpleMsg("result", "Calculated CVV/CVC", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public boolean verifyCVV(String accountNo, SecureDESKey cvkA, SecureDESKey cvkB, String cvv, Date expDate, String serviceCode) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "account number", accountNo), new SimpleMsg("parameter", "cvk-a", cvkA == null ? "" : cvkA), new SimpleMsg("parameter", "cvk-b", cvkB == null ? "" : cvkB), new SimpleMsg("parameter", "CVV/CVC", cvv), new SimpleMsg("parameter", "Exp date", expDate), new SimpleMsg("parameter", "Service code", serviceCode)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Verify CVV/CVC", cmdParameters));
        try {
            boolean r = this.verifyCVVImpl(accountNo, cvkA, cvkB, cvv, expDate, serviceCode);
            evt.addMessage(new SimpleMsg("result", "Verification status", r ? "valid" : "invalid"));
            boolean bl = r;
            return bl;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public boolean verifydCVV(String accountNo, SecureDESKey imkac, String dcvv, Date expDate, String serviceCode, byte[] atc, MKDMethod mkdm) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "account number", accountNo), new SimpleMsg("parameter", "imk-ac", imkac == null ? "" : imkac), new SimpleMsg("parameter", "dCVV", dcvv), new SimpleMsg("parameter", "Exp date", expDate), new SimpleMsg("parameter", "Service code", serviceCode), new SimpleMsg("parameter", "atc", atc == null ? "" : ISOUtil.hexString(atc)), new SimpleMsg("parameter", "mkd method", (Object)mkdm)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Verify dCVV", cmdParameters));
        try {
            boolean r = this.verifydCVVImpl(accountNo, imkac, dcvv, expDate, serviceCode, atc, mkdm);
            evt.addMessage(new SimpleMsg("result", "Verification status", r ? "valid" : "invalid"));
            boolean bl = r;
            return bl;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public boolean verifyCVC3(SecureDESKey imkcvc3, String accountNo, String acctSeqNo, byte[] atc, byte[] upn, byte[] data, MKDMethod mkdm, String cvc3) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "imk-cvc3", imkcvc3 == null ? "" : imkcvc3), new SimpleMsg("parameter", "account number", accountNo), new SimpleMsg("parameter", "accnt seq no", acctSeqNo), new SimpleMsg("parameter", "atc", atc == null ? "" : ISOUtil.hexString(atc)), new SimpleMsg("parameter", "upn", upn == null ? "" : ISOUtil.hexString(upn)), new SimpleMsg("parameter", "data", data == null ? "" : ISOUtil.hexString(data)), new SimpleMsg("parameter", "mkd method", (Object)mkdm), new SimpleMsg("parameter", "cvc3", cvc3)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Verify CVC3", cmdParameters));
        try {
            boolean r = this.verifyCVC3Impl(imkcvc3, accountNo, acctSeqNo, atc, upn, data, mkdm, cvc3);
            evt.addMessage(new SimpleMsg("result", "Verification status", r ? "valid" : "invalid"));
            boolean bl = r;
            return bl;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public boolean verifyARQC(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imkac, String accoutNo, String acctSeqNo, byte[] arqc, byte[] atc, byte[] upn, byte[] transData) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "mkd method", (Object)mkdm), new SimpleMsg("parameter", "skd method", (Object)skdm), new SimpleMsg("parameter", "imk-ac", imkac), new SimpleMsg("parameter", "account number", accoutNo), new SimpleMsg("parameter", "accnt seq no", acctSeqNo), new SimpleMsg("parameter", "arqc", arqc == null ? "" : ISOUtil.hexString(arqc)), new SimpleMsg("parameter", "atc", atc == null ? "" : ISOUtil.hexString(atc)), new SimpleMsg("parameter", "upn", upn == null ? "" : ISOUtil.hexString(upn)), new SimpleMsg("parameter", "trans. data", transData == null ? "" : ISOUtil.hexString(transData))};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Verify ARQC/TC/AAC", cmdParameters));
        try {
            boolean r = this.verifyARQCImpl(mkdm, skdm, imkac, accoutNo, acctSeqNo, arqc, atc, upn, transData);
            evt.addMessage(new SimpleMsg("result", "Verification status", r ? "valid" : "invalid"));
            boolean bl = r;
            return bl;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public byte[] generateARPC(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imkac, String accoutNo, String acctSeqNo, byte[] arqc, byte[] atc, byte[] upn, ARPCMethod arpcMethod, byte[] arc, byte[] propAuthData) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "mkd method", (Object)mkdm), new SimpleMsg("parameter", "skd method", (Object)skdm), new SimpleMsg("parameter", "imk-ac", imkac), new SimpleMsg("parameter", "account number", accoutNo), new SimpleMsg("parameter", "accnt seq no", acctSeqNo), new SimpleMsg("parameter", "arqc", arqc == null ? "" : ISOUtil.hexString(arqc)), new SimpleMsg("parameter", "atc", atc == null ? "" : ISOUtil.hexString(atc)), new SimpleMsg("parameter", "upn", upn == null ? "" : ISOUtil.hexString(upn)), new SimpleMsg("parameter", "arpc gen. method", (Object)arpcMethod), new SimpleMsg("parameter", "auth. rc", arc == null ? "" : ISOUtil.hexString(arc)), new SimpleMsg("parameter", "prop auth. data", propAuthData == null ? "" : ISOUtil.hexString(propAuthData))};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Genarate ARPC", cmdParameters));
        try {
            byte[] result = this.generateARPCImpl(mkdm, skdm, imkac, accoutNo, acctSeqNo, arqc, atc, upn, arpcMethod, arc, propAuthData);
            evt.addMessage(new SimpleMsg("result", "Generated ARPC", result));
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public byte[] verifyARQCGenerateARPC(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imkac, String accoutNo, String acctSeqNo, byte[] arqc, byte[] atc, byte[] upn, byte[] transData, ARPCMethod arpcMethod, byte[] arc, byte[] propAuthData) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "mkd method", (Object)mkdm), new SimpleMsg("parameter", "skd method", (Object)skdm), new SimpleMsg("parameter", "imk-ac", imkac), new SimpleMsg("parameter", "account number", accoutNo), new SimpleMsg("parameter", "accnt seq no", acctSeqNo), new SimpleMsg("parameter", "arqc", arqc == null ? "" : ISOUtil.hexString(arqc)), new SimpleMsg("parameter", "atc", atc == null ? "" : ISOUtil.hexString(atc)), new SimpleMsg("parameter", "upn", upn == null ? "" : ISOUtil.hexString(upn)), new SimpleMsg("parameter", "trans. data", transData == null ? "" : ISOUtil.hexString(transData)), new SimpleMsg("parameter", "arpc gen. method", (Object)arpcMethod), new SimpleMsg("parameter", "auth. rc", arc == null ? "" : ISOUtil.hexString(arc)), new SimpleMsg("parameter", "prop auth. data", propAuthData == null ? "" : ISOUtil.hexString(propAuthData))};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Genarate ARPC", cmdParameters));
        try {
            byte[] result = this.verifyARQCGenerateARPCImpl(mkdm, skdm, imkac, accoutNo, acctSeqNo, arqc, atc, upn, transData, arpcMethod, arc, propAuthData);
            evt.addMessage(new SimpleMsg("result", "ARPC", result == null ? "" : ISOUtil.hexString(result)));
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public byte[] generateSM_MAC(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imksmi, String accountNo, String acctSeqNo, byte[] atc, byte[] arqc, byte[] data) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "mkd method", (Object)mkdm), new SimpleMsg("parameter", "skd method", (Object)skdm), new SimpleMsg("parameter", "imk-smi", imksmi), new SimpleMsg("parameter", "account number", accountNo), new SimpleMsg("parameter", "accnt seq no", acctSeqNo), new SimpleMsg("parameter", "atc", atc == null ? "" : ISOUtil.hexString(atc)), new SimpleMsg("parameter", "arqc", arqc == null ? "" : ISOUtil.hexString(arqc)), new SimpleMsg("parameter", "data", data == null ? "" : ISOUtil.hexString(data))};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Generate Secure Messaging MAC", cmdParameters));
        try {
            byte[] mac = this.generateSM_MACImpl(mkdm, skdm, imksmi, accountNo, acctSeqNo, atc, arqc, data);
            evt.addMessage(new SimpleMsg("result", "Generated MAC", mac != null ? ISOUtil.hexString(mac) : ""));
            byte[] byArray = mac;
            return byArray;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public Pair<EncryptedPIN, byte[]> translatePINGenerateSM_MAC(MKDMethod mkdm, SKDMethod skdm, PaddingMethod padm, SecureDESKey imksmi, String accountNo, String acctSeqNo, byte[] atc, byte[] arqc, byte[] data, EncryptedPIN currentPIN, EncryptedPIN newPIN, SecureDESKey kd1, SecureDESKey imksmc, SecureDESKey imkac, byte destinationPINBlockFormat) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "mkd method", (Object)mkdm), new SimpleMsg("parameter", "skd method", (Object)skdm), new SimpleMsg("parameter", "padding method", (Object)padm), new SimpleMsg("parameter", "imk-smi", imksmi), new SimpleMsg("parameter", "account number", accountNo), new SimpleMsg("parameter", "accnt seq no", acctSeqNo), new SimpleMsg("parameter", "atc", atc == null ? "" : ISOUtil.hexString(atc)), new SimpleMsg("parameter", "arqc", arqc == null ? "" : ISOUtil.hexString(arqc)), new SimpleMsg("parameter", "data", data == null ? "" : ISOUtil.hexString(data)), new SimpleMsg("parameter", "Current Encrypted PIN", currentPIN), new SimpleMsg("parameter", "New Encrypted PIN", newPIN), new SimpleMsg("parameter", "Source PIN Encryption Key", kd1), new SimpleMsg("parameter", "imk-smc", imksmc), new SimpleMsg("parameter", "imk-ac", imkac), new SimpleMsg("parameter", "Destination PIN Block Format", destinationPINBlockFormat)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Translate PIN block format and Generate Secure Messaging MAC", cmdParameters));
        try {
            Pair<EncryptedPIN, byte[]> r = this.translatePINGenerateSM_MACImpl(mkdm, skdm, padm, imksmi, accountNo, acctSeqNo, atc, arqc, data, currentPIN, newPIN, kd1, imksmc, imkac, destinationPINBlockFormat);
            SimpleMsg[] cmdResults = new SimpleMsg[]{new SimpleMsg("result", "Translated PIN block", r.getValue0()), new SimpleMsg("result", "Generated MAC", r.getValue1() == null ? "" : ISOUtil.hexString((byte[])r.getValue1()))};
            evt.addMessage(new SimpleMsg("results", "Complex results", cmdResults));
            Pair<EncryptedPIN, byte[]> pair = r;
            return pair;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public byte[] generateCBC_MAC(byte[] data, SecureDESKey kd) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "data", data), new SimpleMsg("parameter", "data key", kd)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Generate CBC-MAC", cmdParameters));
        byte[] result = null;
        try {
            result = this.generateCBC_MACImpl(data, kd);
            evt.addMessage(new SimpleMsg("result", "CBC-MAC", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public byte[] generateEDE_MAC(byte[] data, SecureDESKey kd) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "data", data), new SimpleMsg("parameter", "data key", kd)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Generate EDE-MAC", cmdParameters));
        byte[] result = null;
        try {
            result = this.generateEDE_MACImpl(data, kd);
            evt.addMessage(new SimpleMsg("result", "EDE-MAC", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public SecureDESKey translateKeyFromOldLMK(SecureDESKey kd) throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "Key under old LMK", kd)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Translate Key from old to new LMK", cmdParameters));
        SecureDESKey result = null;
        try {
            result = this.translateKeyFromOldLMKImpl(kd);
            evt.addMessage(new SimpleMsg("result", "Translated Key under new LMK", result));
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
        return result;
    }

    @Override
    public void eraseOldLMK() throws SMException {
        SimpleMsg[] cmdParameters = new SimpleMsg[]{};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Erase the key change storage", cmdParameters));
        try {
            this.eraseOldLMKImpl();
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    protected SecureDESKey generateKeyImpl(short keyLength, String keyType) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected byte[] generateKeyCheckValueImpl(SecureDESKey kd) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected SecureDESKey importKeyImpl(short keyLength, String keyType, byte[] encryptedKey, SecureDESKey kek, boolean checkParity) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected byte[] exportKeyImpl(SecureDESKey key, SecureDESKey kek) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN encryptPINImpl(String pin, String accountNumber) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected String decryptPINImpl(EncryptedPIN pinUnderLmk) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN importPINImpl(EncryptedPIN pinUnderKd1, SecureDESKey kd1) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN translatePINImpl(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN importPINImpl(EncryptedPIN pinUnderDuk, KeySerialNumber ksn, SecureDESKey bdk) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN translatePINImpl(EncryptedPIN pinUnderDuk, KeySerialNumber ksn, SecureDESKey bdk, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN exportPINImpl(EncryptedPIN pinUnderLmk, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN generatePINImpl(String accountNumber, int pinLen, List<String> excludes) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected String calculatePVVImpl(EncryptedPIN pinUnderLMK, SecureDESKey pvkA, SecureDESKey pvkB, int pvkIdx, List<String> excludes) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected String calculatePVVImpl(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvkA, SecureDESKey pvkB, int pvkIdx, List<String> excludes) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected boolean verifyPVVImpl(EncryptedPIN pinUnderKd, SecureDESKey kd, SecureDESKey pvkA, SecureDESKey pvkB, int pvki, String pvv) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected String calculateIBMPINOffsetImpl(EncryptedPIN pinUnderLmk, SecureDESKey pvk, String decTab, String pinValData, int minPinLen, List<String> excludes) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected String calculateIBMPINOffsetImpl(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvk, String decTab, String pinValData, int minPinLen, List<String> excludes) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected boolean verifyIBMPINOffsetImpl(EncryptedPIN pinUnderKd, SecureDESKey kd, SecureDESKey pvk, String offset, String decTab, String pinValData, int minPinLen) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected EncryptedPIN deriveIBMPINImpl(String accountNo, SecureDESKey pvk, String decTab, String pinValData, int minPinLen, String offset) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected String calculateCVVImpl(String accountNo, SecureDESKey cvkA, SecureDESKey cvkB, Date expDate, String serviceCode) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected boolean verifyCVVImpl(String accountNo, SecureDESKey cvkA, SecureDESKey cvkB, String cvv, Date expDate, String serviceCode) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected boolean verifydCVVImpl(String accountNo, SecureDESKey imkac, String dcvv, Date expDate, String serviceCode, byte[] atc, MKDMethod mkdm) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected boolean verifyCVC3Impl(SecureDESKey imkcvc3, String accountNo, String acctSeqNo, byte[] atc, byte[] upn, byte[] data, MKDMethod mkdm, String cvc3) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected boolean verifyARQCImpl(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imkac, String accountNo, String acctSeqNo, byte[] arqc, byte[] atc, byte[] upn, byte[] transData) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected byte[] generateARPCImpl(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imkac, String accountNo, String acctSeqNo, byte[] arqc, byte[] atc, byte[] upn, ARPCMethod arpcMethod, byte[] arc, byte[] propAuthData) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected byte[] verifyARQCGenerateARPCImpl(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imkac, String accountNo, String acctSeqNo, byte[] arqc, byte[] atc, byte[] upn, byte[] transData, ARPCMethod arpcMethod, byte[] arc, byte[] propAuthData) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected byte[] generateSM_MACImpl(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imksmi, String accountNo, String acctSeqNo, byte[] atc, byte[] arqc, byte[] data) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected Pair<EncryptedPIN, byte[]> translatePINGenerateSM_MACImpl(MKDMethod mkdm, SKDMethod skdm, PaddingMethod padm, SecureDESKey imksmi, String accountNo, String acctSeqNo, byte[] atc, byte[] arqc, byte[] data, EncryptedPIN currentPIN, EncryptedPIN newPIN, SecureDESKey kd1, SecureDESKey imksmc, SecureDESKey imkac, byte destinationPINBlockFormat) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected byte[] generateCBC_MACImpl(byte[] data, SecureDESKey kd) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected byte[] generateEDE_MACImpl(byte[] data, SecureDESKey kd) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected SecureDESKey translateKeyFromOldLMKImpl(SecureDESKey kd) throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }

    protected void eraseOldLMKImpl() throws SMException {
        throw new SMException("Operation not supported in: " + this.getClass().getName());
    }
}

