/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.qbean;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.Q2;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.qbean.SystemMonitorMBean;
import org.jpos.util.Loggeable;
import org.jpos.util.NameRegistrar;

public class SystemMonitor
extends QBeanSupport
implements Runnable,
SystemMonitorMBean,
Loggeable {
    private long sleepTime = 3600000L;
    private long delay = 0L;
    private boolean detailRequired = false;
    private Thread me = null;
    private static final int MB = 0x100000;
    private String[] scripts;
    private String frozenDump;

    @Override
    public void startService() {
        try {
            this.log.info("Starting SystemMonitor");
            this.me = new Thread((Runnable)this, "SystemMonitor");
            this.me.start();
        }
        catch (Exception e) {
            this.log.warn("error starting service", e);
        }
    }

    @Override
    public void stopService() {
        this.log.info("Stopping SystemMonitor");
        if (this.me != null) {
            this.me.interrupt();
        }
    }

    @Override
    public synchronized void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
        this.setModified(true);
        if (this.me != null) {
            this.me.interrupt();
        }
    }

    @Override
    public synchronized long getSleepTime() {
        return this.sleepTime;
    }

    @Override
    public synchronized void setDetailRequired(boolean detail) {
        this.detailRequired = detail;
        this.setModified(true);
        if (this.me != null) {
            this.me.interrupt();
        }
    }

    @Override
    public synchronized boolean getDetailRequired() {
        return this.detailRequired;
    }

    void dumpThreads(ThreadGroup g, PrintStream p, String indent) {
        Thread[] list = new Thread[g.activeCount() + 5];
        int nthreads = g.enumerate(list);
        for (int i = 0; i < nthreads; ++i) {
            p.println(indent + list[i]);
        }
    }

    public void showThreadGroup(ThreadGroup g, PrintStream p, String indent) {
        if (g.getParent() != null) {
            this.showThreadGroup(g.getParent(), p, indent + "  ");
        } else {
            this.dumpThreads(g, p, indent + "    ");
        }
    }

    @Override
    public void run() {
        while (this.running()) {
            this.log.info(this);
            this.frozenDump = null;
            try {
                long expected = System.currentTimeMillis() + this.sleepTime;
                Thread.sleep(this.sleepTime);
                this.delay = System.currentTimeMillis() - expected;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void dump(PrintStream p, String indent) {
        if (this.frozenDump == null) {
            this.frozenDump = this.generateFrozenDump(indent);
        }
        p.print(this.frozenDump);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        super.setConfiguration(cfg);
        this.scripts = cfg.getAll("script");
    }

    private SecurityManager getSecurityManager() {
        return System.getSecurityManager();
    }

    private boolean hasSecurityManager() {
        return this.getSecurityManager() != null;
    }

    private Runtime getRuntimeInstance() {
        return Runtime.getRuntime();
    }

    private long getServerUptimeAsMillisecond() {
        return this.getServer().getUptime();
    }

    private String getInstanceIdAsString() {
        return this.getServer().getInstanceId().toString();
    }

    private String getRevision() {
        this.getServer();
        return Q2.getRevision();
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private String generateFrozenDump(String indent) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(baos);
        String newIndent = indent + "  ";
        Runtime r = this.getRuntimeInstance();
        p.printf("%s           OS: %s%n", indent, System.getProperty("os.name"));
        p.printf("%s         host: %s%n", indent, this.getLocalHost());
        p.printf("%s      version: %s (%s)%n", indent, Q2.getVersion(), this.getRevision());
        p.printf("%s     instance: %s%n", indent, this.getInstanceIdAsString());
        p.printf("%s       uptime: %s%n", indent, ISOUtil.millisToString(this.getServerUptimeAsMillisecond()));
        p.printf("%s   processors: %d%n", indent, r.availableProcessors());
        p.printf("%s       drift : %d%n", indent, this.delay);
        p.printf("%smemory(t/u/f): %d/%d/%d%n", indent, r.totalMemory() / 0x100000L, (r.totalMemory() - r.freeMemory()) / 0x100000L, r.freeMemory() / 0x100000L);
        if (this.hasSecurityManager()) {
            p.printf("%s  sec-manager: %s%n", indent, this.getSecurityManager());
        }
        p.printf("%s      threads: %d%n", indent, Thread.activeCount());
        this.showThreadGroup(Thread.currentThread().getThreadGroup(), p, newIndent);
        NameRegistrar.getInstance().dump(p, indent, this.detailRequired);
        for (String s : this.scripts) {
            p.printf("%s%s:%n", indent, s);
            this.exec(s, p, newIndent);
        }
        return baos.toString();
    }

    private void exec(String script, PrintStream ps, String indent) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(script);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = in.readLine()) != null) {
                ps.printf("%s%s%n", indent, line);
            }
        }
        catch (Exception e) {
            e.printStackTrace(ps);
        }
    }
}

