/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.qbean;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.q2.QBeanSupport;
import org.jpos.space.Space;
import org.jpos.space.SpaceError;
import org.jpos.space.SpaceFactory;
import org.jpos.util.NameRegistrar;

public class SpaceLet
extends QBeanSupport
implements Space {
    Space sp;
    String uri;
    String outScript;
    String outSource;
    String pushScript;
    String pushSource;
    String inScript;
    String inSource;
    String rdScript;
    String rdSource;
    String putScript;
    String putSource;

    @Override
    public void initService() throws ConfigurationException {
        Element config = this.getPersist();
        this.grabSpace(config.getChild("space"));
        this.initSpace(config.getChild("init"));
        String name = this.getName();
        if ("spacelet".equals(name)) {
            name = "default";
        }
        this.uri = "spacelet:" + name;
        Element e = config.getChild("out");
        this.outScript = this.getScript(e);
        if (e != null) {
            this.outSource = e.getAttributeValue("source");
        }
        e = config.getChild("push");
        this.pushScript = this.getScript(e);
        if (e != null) {
            this.pushSource = e.getAttributeValue("source");
        }
        e = config.getChild("in");
        this.inScript = this.getScript(e);
        if (e != null) {
            this.inSource = e.getAttributeValue("source");
        }
        e = config.getChild("rd");
        this.rdScript = this.getScript(e);
        if (e != null) {
            this.rdSource = e.getAttributeValue("source");
        }
        e = config.getChild("put");
        this.putScript = this.getScript(e);
        if (e != null) {
            this.putSource = e.getAttributeValue("source");
        }
    }

    @Override
    public void startService() {
        NameRegistrar.register(this.uri, this);
        Iterator iter = this.getPersist().getChildren("run").iterator();
        while (iter.hasNext()) {
            this.launch((Element)iter.next());
        }
    }

    @Override
    public void stopService() {
        NameRegistrar.unregister(this.uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void out(Object key, Object value) {
        try {
            Interpreter bsh = this.initInterpreter(key, value);
            Space space = this.sp;
            synchronized (space) {
                if (!this.eval(bsh, this.outScript, this.outSource)) {
                    this.sp.out(key, value);
                }
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void out(Object key, Object value, long timeout) {
        try {
            Interpreter bsh = this.initInterpreter(key, value, timeout);
            Space space = this.sp;
            synchronized (space) {
                if (!this.eval(bsh, this.outScript, this.outSource)) {
                    this.sp.out(key, value, timeout);
                }
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object key, Object value) {
        try {
            Interpreter bsh = this.initInterpreter(key, value);
            Space space = this.sp;
            synchronized (space) {
                if (!this.eval(bsh, this.pushScript, this.pushSource)) {
                    this.sp.out(key, value);
                }
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object key, Object value, long timeout) {
        try {
            Interpreter bsh = this.initInterpreter(key, value, timeout);
            Space space = this.sp;
            synchronized (space) {
                if (!this.eval(bsh, this.pushScript, this.pushSource)) {
                    this.sp.out(key, value, timeout);
                }
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        try {
            Interpreter bsh = this.initInterpreter(key, value);
            Space space = this.sp;
            synchronized (space) {
                if (!this.eval(bsh, this.putScript, this.putSource)) {
                    this.sp.put(key, value);
                }
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value, long timeout) {
        try {
            Interpreter bsh = this.initInterpreter(key, value, timeout);
            Space space = this.sp;
            synchronized (space) {
                if (!this.eval(bsh, this.putScript, this.putSource)) {
                    this.sp.out(key, value, timeout);
                }
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object in(Object key) {
        try {
            Interpreter bsh = this.initInterpreter(key);
            Space space = this.sp;
            synchronized (space) {
                if (this.eval(bsh, this.inScript, this.inSource)) {
                    return bsh.get("value");
                }
                return this.sp.in(key);
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object rd(Object key) {
        try {
            Interpreter bsh = this.initInterpreter(key);
            Space space = this.sp;
            synchronized (space) {
                if (this.eval(bsh, this.rdScript, this.rdSource)) {
                    return bsh.get("value");
                }
                return this.sp.rd(key);
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object in(Object key, long timeout) {
        try {
            Interpreter bsh = this.initInterpreter(key, timeout);
            Space space = this.sp;
            synchronized (space) {
                if (this.eval(bsh, this.inScript, this.inSource)) {
                    return bsh.get("value");
                }
                return this.sp.in(key, timeout);
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object rd(Object key, long timeout) {
        try {
            Interpreter bsh = this.initInterpreter(key, timeout);
            Space space = this.sp;
            synchronized (space) {
                if (this.eval(bsh, this.rdScript, this.rdSource)) {
                    return bsh.get("value");
                }
                return this.sp.rd(key, timeout);
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object inp(Object key) {
        try {
            Interpreter bsh = this.initInterpreter(key);
            bsh.set("probe", true);
            Space space = this.sp;
            synchronized (space) {
                if (this.eval(bsh, this.inScript, this.inSource)) {
                    return bsh.get("value");
                }
                return this.sp.inp(key);
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object rdp(Object key) {
        try {
            Interpreter bsh = this.initInterpreter(key);
            bsh.set("probe", true);
            Space space = this.sp;
            synchronized (space) {
                if (this.eval(bsh, this.rdScript, this.rdSource)) {
                    return bsh.get("value");
                }
                return this.sp.rdp(key);
            }
        }
        catch (Throwable t) {
            throw new SpaceError(t);
        }
    }

    public boolean existAny(Object[] keys) {
        return this.sp.existAny(keys);
    }

    public boolean existAny(Object[] keys, long timeout) {
        return this.sp.existAny(keys, timeout);
    }

    private void grabSpace(Element e) {
        this.sp = SpaceFactory.getSpace(e != null ? e.getText() : "");
    }

    private String getScript(Element e) {
        return e == null ? null : e.getText();
    }

    private void launch(Element e) {
        final String script = e.getText();
        final String source = e.getAttributeValue("source");
        new Thread("SpaceLet-launch"){

            @Override
            public void run() {
                try {
                    SpaceLet.this.eval(SpaceLet.this.initInterpreter(), script, source);
                }
                catch (Throwable t) {
                    SpaceLet.this.getLog().warn(t);
                }
            }
        }.start();
    }

    private void initSpace(Element e) throws ConfigurationException {
        if (e == null) {
            return;
        }
        try {
            this.eval(this.initInterpreter(), e.getText(), e.getAttributeValue("source"));
        }
        catch (Throwable t) {
            throw new ConfigurationException(t);
        }
    }

    private Interpreter initInterpreter() throws EvalError {
        Interpreter bsh = new Interpreter();
        bsh.set("sp", (Object)this.sp);
        bsh.set("spacelet", (Object)this);
        bsh.set("log", (Object)this.getLog());
        return bsh;
    }

    private Interpreter initInterpreter(Object key) throws EvalError {
        Interpreter bsh = this.initInterpreter();
        bsh.set("key", key);
        return bsh;
    }

    private Interpreter initInterpreter(Object key, Object value) throws EvalError {
        Interpreter bsh = this.initInterpreter(key);
        bsh.set("value", value);
        return bsh;
    }

    private Interpreter initInterpreter(Object key, Object value, long timeout) throws EvalError {
        Interpreter bsh = this.initInterpreter(key, value);
        bsh.set("timeout", timeout);
        return bsh;
    }

    private Interpreter initInterpreter(Object key, long timeout) throws EvalError {
        Interpreter bsh = this.initInterpreter(key);
        bsh.set("timeout", timeout);
        return bsh;
    }

    private boolean eval(Interpreter bsh, String script, String source) throws EvalError, FileNotFoundException, IOException {
        boolean rc = false;
        if (script != null) {
            Object retValue = bsh.eval(script);
            if (source != null) {
                retValue = bsh.source(source);
            }
            if (retValue instanceof Boolean) {
                rc = (Boolean)retValue;
            }
        }
        return rc;
    }
}

