/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.qbean;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.qbean.QThreadPoolExecutorMBean;
import org.jpos.util.NameRegistrar;

public class QThreadPoolExecutor
extends QBeanSupport
implements QThreadPoolExecutorMBean {
    public static final String THREAD_POOL_EXECUTOR__QBEAN_PREFIX = "thread.pool.executor.";
    public static final String XML_CONFIG_ATTR__EXEC_SRV_TYPE = "type";
    public static final String XML_CONFIG_ATTR__EXEC_SRV_COREPOOLSIZE = "corePoolSize";
    public static final String XML_CONFIG_ATTR__EXEC_SRV_TERMINATION_TIMER = "terminationTimer";
    public static final int DEFAULT_TERMINATION_TIMER = 15;
    private String execSrvType;
    private int initialCorePoolSize;
    private int terminationTimer = 15;

    @Override
    protected void initService() throws Exception {
        Attribute corePoolSizeAttr;
        Element rootElt = this.getPersist();
        Attribute execSrvTypeAttr = this.getAttribute(rootElt, XML_CONFIG_ATTR__EXEC_SRV_TYPE, true, "(thread pool executor type among {fixed|cached|scheduled|single})");
        this.execSrvType = execSrvTypeAttr.getValue().trim();
        if ("fixed".equals(this.execSrvType)) {
            corePoolSizeAttr = this.getAttribute(rootElt, XML_CONFIG_ATTR__EXEC_SRV_COREPOOLSIZE, true, "(number of threads in the pool)");
            this.initialCorePoolSize = corePoolSizeAttr.getIntValue();
        } else if ("cached".equals(this.execSrvType)) {
            corePoolSizeAttr = this.getAttribute(rootElt, XML_CONFIG_ATTR__EXEC_SRV_COREPOOLSIZE, false, "(number of threads in the pool)");
            if (null != corePoolSizeAttr) {
                this.initialCorePoolSize = corePoolSizeAttr.getIntValue();
            }
        } else if ("scheduled".equals(this.execSrvType)) {
            corePoolSizeAttr = this.getAttribute(rootElt, XML_CONFIG_ATTR__EXEC_SRV_COREPOOLSIZE, true, "(number of threads in the pool)");
            this.initialCorePoolSize = corePoolSizeAttr.getIntValue();
        } else {
            throw new ConfigurationException("Invalid thread pool executor type '%s' (valid types={fixed|cached|scheduled} )");
        }
        Attribute terminationTimerAttr = this.getAttribute(rootElt, XML_CONFIG_ATTR__EXEC_SRV_TERMINATION_TIMER, false, "(termination timer in seconds)");
        if (null != terminationTimerAttr) {
            this.terminationTimer = terminationTimerAttr.getIntValue();
        }
    }

    @Override
    protected void startService() throws Exception {
        ExecutorService execSrv = null;
        try {
            if ("fixed".equals(this.execSrvType)) {
                execSrv = Executors.newFixedThreadPool(this.initialCorePoolSize);
            } else if ("cached".equals(this.execSrvType)) {
                execSrv = Executors.newCachedThreadPool();
                if (this.initialCorePoolSize != 0) {
                    ((ThreadPoolExecutor)execSrv).setCorePoolSize(this.initialCorePoolSize);
                }
            } else if ("scheduled".equals(this.execSrvType)) {
                execSrv = Executors.newScheduledThreadPool(this.initialCorePoolSize);
            }
            if (null == execSrv) {
                throw new Exception("Unable to start service : thread pool executor instance is null");
            }
            NameRegistrar.register(this.getRegistrationName(), execSrv);
        }
        catch (Exception e) {
            if (null != execSrv) {
                try {
                    execSrv.shutdownNow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    protected void stopService() throws Exception {
        ThreadPoolExecutor execSrv = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        if (null != execSrv) {
            execSrv.shutdownNow();
            boolean awaitTermination = execSrv.awaitTermination(this.terminationTimer, TimeUnit.SECONDS);
            if (!awaitTermination) {
                throw new Exception(String.format("Unable to shutdown thread pool executor : executor termination delay (%d seconds) has expired", this.terminationTimer));
            }
        } else {
            throw new Exception(String.format("Unable to stop thread pool executor : no executor '%s' found registered under name '%s'", this.getName(), this.getRegistrationName()));
        }
        NameRegistrar.unregister(this.getRegistrationName());
    }

    protected String getRegistrationName() {
        return THREAD_POOL_EXECUTOR__QBEAN_PREFIX + this.getName();
    }

    protected Attribute getAttribute(Element elt, String attrName, boolean mandatory, String errDesc) throws ConfigurationException {
        Attribute attr = elt.getAttribute(attrName);
        if (null == attr || "".equals(attr.getValue().trim())) {
            if (mandatory) {
                throw new ConfigurationException(String.format("'%s' attribute has not been found or is empty %s", XML_CONFIG_ATTR__EXEC_SRV_TYPE, errDesc));
            }
            return null;
        }
        return attr;
    }

    public static ThreadPoolExecutor getThreadPoolExecutor(String name) throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor res = null;
        Object object = NameRegistrar.get(THREAD_POOL_EXECUTOR__QBEAN_PREFIX + name);
        if (!(object instanceof ThreadPoolExecutor)) {
            throw new NameRegistrar.NotFoundException(name);
        }
        res = (ThreadPoolExecutor)object;
        return res;
    }

    public static <T extends ThreadPoolExecutor> T getThreadPoolExecutor(String name, Class<T> clazz) throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor res = null;
        Object object = NameRegistrar.get(THREAD_POOL_EXECUTOR__QBEAN_PREFIX + name);
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new NameRegistrar.NotFoundException(name);
        }
        res = (ThreadPoolExecutor)object;
        return (T)res;
    }

    @Override
    public String getExecSrvType() {
        return this.execSrvType;
    }

    @Override
    public int getTerminationTimer() {
        return this.terminationTimer;
    }

    @Override
    public int getActiveCount() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getActiveCount();
    }

    @Override
    public long getCompletedTaskCount() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getCompletedTaskCount();
    }

    @Override
    public int getCorePoolSize() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getCorePoolSize();
    }

    @Override
    public long getKeepAliveTimeMS() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public int getLargestPoolSize() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getLargestPoolSize();
    }

    @Override
    public int getMaximumPoolSize() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getMaximumPoolSize();
    }

    @Override
    public int getPoolSize() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getPoolSize();
    }

    @Override
    public long getTaskCount() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.getTaskCount();
    }

    @Override
    public boolean isShutdown() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.isTerminated();
    }

    @Override
    public boolean isTerminating() throws NameRegistrar.NotFoundException {
        ThreadPoolExecutor executorService = QThreadPoolExecutor.getThreadPoolExecutor(this.getName(), ThreadPoolExecutor.class);
        return executorService.isTerminating();
    }

    public int getInitialCorePoolSize() {
        return this.initialCorePoolSize;
    }

    protected void setExecSrvType(String execSrvType) {
        this.execSrvType = execSrvType;
    }

    protected void setInitialCorePoolSize(int initialCorePoolSize) {
        this.initialCorePoolSize = initialCorePoolSize;
    }

    protected void setTerminationTimer(int terminationTimer) {
        this.terminationTimer = terminationTimer;
    }
}

