/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.qbean;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.q2.qbean.QBeanFactoryMBean;
import org.jpos.util.NameRegistrar;

public class QBeanFactory
extends QBeanSupport
implements QBeanFactoryMBean {
    private static Map beanMap = new WeakHashMap();
    private Map privateList;

    @Override
    public void initService() throws Exception {
        Element e = this.getPersist();
        this.privateList = new HashMap();
        List beans = e.getChildren("bean");
        for (Object bean1 : beans) {
            Element bean = (Element)bean1;
            String id = bean.getAttributeValue("id");
            this.privateList.put(id, bean);
        }
    }

    @Override
    public void start() {
        super.start();
        NameRegistrar.register("QBeanFactory." + this.getName(), this);
    }

    @Override
    public void stop() {
        super.stop();
        NameRegistrar.unregister("QBeanFactory." + this.getName());
    }

    @Override
    public void startService() {
        Iterator keys = this.privateList.keySet().iterator();
        while (keys.hasNext()) {
            Element bean = (Element)this.privateList.get(keys.next());
            String id = bean.getAttributeValue("id");
            String lazy = bean.getAttributeValue("lazy");
            if (lazy == null || !lazy.equalsIgnoreCase("false")) continue;
            this.getBean(id);
        }
    }

    @Override
    public void stopService() {
        Iterator keys = this.privateList.keySet().iterator();
        while (keys.hasNext()) {
            Element bean = (Element)this.privateList.get(keys.next());
            String id = bean.getAttributeValue("id");
            Object beanInstance = beanMap.remove(id);
            String stopMethod = bean.getAttributeValue("stop-method");
            if (beanInstance == null || stopMethod == null) continue;
            try {
                this.getFactory();
                QFactory.invoke(beanInstance, stopMethod, null);
            }
            catch (Exception e) {
                this.log.warn(e);
            }
        }
    }

    @Override
    public Object getBean(String id) {
        Element bean = (Element)this.privateList.get(id);
        if (bean == null) {
            return beanMap.get(id);
        }
        String singleton = bean.getAttributeValue("singleton");
        try {
            if (singleton != null && singleton.equals("false")) {
                return this.newBean(bean, false);
            }
            return this.newBean(bean, true);
        }
        catch (Exception e) {
            this.log.fatal(e);
            return null;
        }
    }

    private Object newBean(Element bean, boolean useCache) throws ConfigurationException {
        String id = bean.getAttributeValue("id");
        if (useCache && beanMap.containsKey(id)) {
            return beanMap.get(id);
        }
        String className = bean.getAttributeValue("class");
        Object beanInstance = this.getFactory().newInstance(className);
        List propertyList = bean.getChildren("property");
        for (Object aPropertyList : propertyList) {
            Element propertyElement = (Element)aPropertyList;
            String pName = propertyElement.getAttributeValue("name");
            String pValue = propertyElement.getAttributeValue("value");
            String pRef = propertyElement.getAttributeValue("ref");
            String methodName = "set" + Character.toUpperCase(pName.charAt(0)) + pName.substring(1);
            if (pValue == null) {
                this.getFactory();
                QFactory.invoke(beanInstance, methodName, this.getBean(pRef));
                continue;
            }
            this.getFactory();
            QFactory.invoke(beanInstance, methodName, pValue);
        }
        String startMethod = bean.getAttributeValue("start-method");
        if (startMethod != null) {
            this.getFactory();
            QFactory.invoke(beanInstance, startMethod, null);
        }
        if (useCache) {
            beanMap.put(id, beanInstance);
        }
        return beanInstance;
    }
}

