/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.qbean;

import java.util.Iterator;
import org.jdom.Element;
import org.jpos.core.Configurable;
import org.jpos.core.ConfigurationException;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.util.LogListener;
import org.jpos.util.Logger;

public class LoggerAdaptor
extends QBeanSupport {
    Logger logger;

    @Override
    protected void initService() {
        this.logger = Logger.getLogger(this.getName());
    }

    @Override
    protected void startService() throws ConfigurationException {
        this.logger.removeAllListeners();
        Iterator iter = this.getPersist().getChildren("log-listener").iterator();
        while (iter.hasNext()) {
            this.addListener((Element)iter.next());
        }
    }

    @Override
    protected void stopService() {
        this.logger.removeAllListeners();
    }

    @Override
    protected void destroyService() {
    }

    private void addListener(Element e) throws ConfigurationException {
        String clazz;
        QFactory factory = this.getServer().getFactory();
        LogListener listener = (LogListener)factory.newInstance(clazz = e.getAttributeValue("class"));
        if (listener instanceof Configurable) {
            try {
                ((Configurable)((Object)listener)).setConfiguration(factory.getConfiguration(e));
            }
            catch (ConfigurationException ex) {
                throw new ConfigurationException(ex);
            }
        }
        this.logger.addListener(listener);
    }
}

