/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import java.util.StringTokenizer;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISORequestListener;
import org.jpos.iso.ISOServer;
import org.jpos.iso.ISOServerEventListener;
import org.jpos.iso.ISOServerSocketFactory;
import org.jpos.iso.ISOSource;
import org.jpos.iso.ServerChannel;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.q2.iso.ChannelAdaptor;
import org.jpos.q2.iso.QServerMBean;
import org.jpos.space.LocalSpace;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.space.SpaceListener;
import org.jpos.util.LogSource;
import org.jpos.util.NameRegistrar;
import org.jpos.util.ThreadPool;

public class QServer
extends QBeanSupport
implements QServerMBean,
SpaceListener,
ISORequestListener {
    private int port = 0;
    private int maxSessions = 100;
    private int minSessions = 1;
    private String channelString;
    private String packagerString;
    private String socketFactoryString;
    private ISOChannel channel = null;
    private ISOServer server;
    protected LocalSpace sp;
    private String inQueue;
    private String outQueue;
    private String sendMethod;

    @Override
    public void initService() throws ConfigurationException {
        Element e = this.getPersist();
        this.sp = this.grabSpace(e.getChild("space"));
    }

    private void newChannel() throws ConfigurationException {
        Element persist = this.getPersist();
        Element e = persist.getChild("channel");
        if (e == null) {
            throw new ConfigurationException("channel element missing");
        }
        ChannelAdaptor adaptor = new ChannelAdaptor();
        this.channel = adaptor.newChannel(e, this.getFactory());
    }

    private void initServer() throws ConfigurationException {
        if (this.port == 0) {
            throw new ConfigurationException("Port value not set");
        }
        this.newChannel();
        if (this.channel == null) {
            throw new ConfigurationException("ISO Channel is null");
        }
        if (!(this.channel instanceof ServerChannel)) {
            throw new ConfigurationException(this.channelString + "does not implement ServerChannel");
        }
        ThreadPool pool = null;
        pool = new ThreadPool(this.minSessions, this.maxSessions);
        pool.setLogger(this.log.getLogger(), this.getName() + ".pool");
        this.server = new ISOServer(this.port, (ServerChannel)this.channel, pool);
        this.server.setLogger(this.log.getLogger(), this.getName() + ".server");
        this.server.setName(this.getName());
        if (this.socketFactoryString != null) {
            ISOServerSocketFactory sFac = (ISOServerSocketFactory)this.getFactory().newInstance(this.socketFactoryString);
            if (sFac != null && sFac instanceof LogSource) {
                ((LogSource)((Object)sFac)).setLogger(this.log.getLogger(), this.getName() + ".socket-factory");
            }
            this.server.setSocketFactory(sFac);
        }
        this.getFactory().setConfiguration(this.server, this.getPersist());
        this.addServerSocketFactory();
        this.addListeners();
        this.addISOServerConnectionListeners();
        NameRegistrar.register(this.getName(), this);
        new Thread(this.server).start();
    }

    private void initIn() {
        Element persist = this.getPersist();
        this.inQueue = persist.getChildText("in");
        if (this.inQueue != null) {
            this.sp.addListener(this.inQueue, this);
        }
    }

    private void initOut() {
        Element persist = this.getPersist();
        this.outQueue = persist.getChildText("out");
        if (this.outQueue != null) {
            this.server.addISORequestListener(this);
        }
    }

    @Override
    public void startService() {
        try {
            this.initServer();
            this.initIn();
            this.initOut();
            this.initWhoToSendTo();
        }
        catch (Exception e) {
            this.getLog().warn("error starting service", e);
        }
    }

    private void initWhoToSendTo() {
        Element persist = this.getPersist();
        this.sendMethod = persist.getChildText("send-request");
        if (this.sendMethod == null) {
            this.sendMethod = "LAST";
        }
    }

    @Override
    public void stopService() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Override
    public void destroyService() {
        NameRegistrar.unregister(this.getName());
        NameRegistrar.unregister("server." + this.getName());
    }

    @Override
    public synchronized void setPort(int port) {
        this.port = port;
        this.setAttr(this.getAttrs(), "port", port);
        this.setModified(true);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public synchronized void setPackager(String packager) {
        this.packagerString = packager;
        this.setAttr(this.getAttrs(), "packager", this.packagerString);
        this.setModified(true);
    }

    @Override
    public String getPackager() {
        return this.packagerString;
    }

    @Override
    public synchronized void setChannel(String channel) {
        this.channelString = channel;
        this.setAttr(this.getAttrs(), "channel", this.channelString);
        this.setModified(true);
    }

    @Override
    public String getChannel() {
        return this.channelString;
    }

    @Override
    public synchronized void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
        this.setAttr(this.getAttrs(), "maxSessions", maxSessions);
        this.setModified(true);
    }

    @Override
    public int getMaxSessions() {
        return this.maxSessions;
    }

    @Override
    public synchronized void setMinSessions(int minSessions) {
        this.minSessions = minSessions;
        this.setAttr(this.getAttrs(), "minSessions", minSessions);
        this.setModified(true);
    }

    @Override
    public int getMinSessions() {
        return this.minSessions;
    }

    @Override
    public synchronized void setSocketFactory(String sFactory) {
        this.socketFactoryString = sFactory;
        this.setAttr(this.getAttrs(), "socketFactory", this.socketFactoryString);
        this.setModified(true);
    }

    @Override
    public String getSocketFactory() {
        return this.socketFactoryString;
    }

    @Override
    public String getISOChannelNames() {
        return this.server.getISOChannelNames();
    }

    @Override
    public String getCountersAsString() {
        return this.server.getCountersAsString();
    }

    @Override
    public String getCountersAsString(String isoChannelName) {
        return this.server.getCountersAsString(isoChannelName);
    }

    private void addServerSocketFactory() throws ConfigurationException {
        QFactory factory = this.getFactory();
        Element persist = this.getPersist();
        Element serverSocketFactoryElement = persist.getChild("server-socket-factory");
        if (serverSocketFactoryElement != null) {
            ISOServerSocketFactory serverSocketFactory = (ISOServerSocketFactory)factory.newInstance(serverSocketFactoryElement.getAttributeValue("class"));
            factory.setLogger(serverSocketFactory, serverSocketFactoryElement);
            factory.setConfiguration(serverSocketFactory, serverSocketFactoryElement);
            this.server.setSocketFactory(serverSocketFactory);
        }
    }

    private void addListeners() throws ConfigurationException {
        QFactory factory = this.getFactory();
        for (Element l : this.getPersist().getChildren("request-listener")) {
            ISORequestListener listener = (ISORequestListener)factory.newInstance(l.getAttributeValue("class"));
            factory.setLogger(listener, l);
            factory.setConfiguration(listener, l);
            this.server.addISORequestListener(listener);
        }
    }

    private void addISOServerConnectionListeners() throws ConfigurationException {
        QFactory factory = this.getFactory();
        for (Element l : this.getPersist().getChildren("connection-listener")) {
            ISOServerEventListener listener = (ISOServerEventListener)factory.newInstance(l.getAttributeValue("class"));
            factory.setLogger(listener, l);
            factory.setConfiguration(listener, l);
            this.server.addServerEventListener(listener);
        }
    }

    private LocalSpace grabSpace(Element e) throws ConfigurationException {
        String uri = e != null ? e.getText() : "";
        Space sp = SpaceFactory.getSpace(uri);
        if (sp instanceof LocalSpace) {
            return (LocalSpace)sp;
        }
        throw new ConfigurationException("Invalid space " + uri);
    }

    @Override
    public void notify(Object key, Object value) {
        Object obj = this.sp.inp(key);
        if (obj instanceof ISOMsg) {
            String channelNames;
            ISOMsg m = (ISOMsg)obj;
            if ("LAST".equals(this.sendMethod)) {
                try {
                    ISOChannel c = this.server.getLastConnectedISOChannel();
                    if (c == null) {
                        throw new ISOException("Server has no active connections");
                    }
                    if (!c.isConnected()) {
                        throw new ISOException("Client disconnected");
                    }
                    c.send(m);
                }
                catch (Exception e) {
                    this.getLog().warn("notify", e);
                }
            } else if ("ALL".equals(this.sendMethod) && (channelNames = this.getISOChannelNames()) != null) {
                StringTokenizer tok = new StringTokenizer(channelNames, " ");
                while (tok.hasMoreTokens()) {
                    try {
                        ISOChannel c = this.server.getISOChannel(tok.nextToken());
                        if (c == null) {
                            throw new ISOException("Server has no active connections");
                        }
                        if (!c.isConnected()) {
                            throw new ISOException("Client disconnected");
                        }
                        c.send(m);
                    }
                    catch (Exception e) {
                        this.getLog().warn("notify", e);
                    }
                }
            }
        }
    }

    @Override
    public boolean process(ISOSource source, ISOMsg m) {
        this.sp.out(this.outQueue, m);
        return true;
    }
}

