/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISORequestListener;
import org.jpos.iso.ISOResponseListener;
import org.jpos.iso.ISOSource;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.MUX;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.q2.iso.QMUXMBean;
import org.jpos.space.LocalSpace;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.space.SpaceListener;
import org.jpos.util.Loggeable;
import org.jpos.util.NameRegistrar;

public class QMUX
extends QBeanSupport
implements SpaceListener,
MUX,
QMUXMBean,
Loggeable,
ISOSource {
    static final String nomap = "0123456789";
    static final String DEFAULT_KEY = "41, 11";
    private boolean headerIsKey;
    protected LocalSpace sp;
    protected String in;
    protected String out;
    protected String unhandled;
    protected String[] ready;
    protected String[] key;
    protected String ignorerc;
    protected String[] mtiMapping;
    List listeners = new ArrayList();
    int rx;
    int tx;
    int rxExpired;
    int txExpired;
    int rxPending;
    int rxUnhandled;
    int rxForwarded;
    long lastTxn = 0L;
    boolean listenerRegistered;

    @Override
    public void initService() throws ConfigurationException {
        Element e = this.getPersist();
        this.sp = this.grabSpace(e.getChild("space"));
        this.in = e.getChildTextTrim("in");
        this.out = e.getChildTextTrim("out");
        this.ignorerc = e.getChildTextTrim("ignore-rc");
        this.key = this.toStringArray(e.getChildTextTrim("key"), ", ", DEFAULT_KEY);
        this.ready = this.toStringArray(e.getChildTextTrim("ready"));
        this.mtiMapping = this.toStringArray(e.getChildTextTrim("mtimapping"));
        if (this.mtiMapping == null || this.mtiMapping.length != 3) {
            this.mtiMapping = new String[]{nomap, nomap, "0022446789"};
        }
        this.addListeners();
        this.unhandled = e.getChildTextTrim("unhandled");
        NameRegistrar.register("mux." + this.getName(), this);
    }

    @Override
    public void startService() {
        if (!this.listenerRegistered) {
            this.listenerRegistered = true;
            this.sp.addListener(this.in, this);
        }
    }

    @Override
    public void stopService() {
        this.listenerRegistered = false;
        this.sp.removeListener(this.in, this);
    }

    @Override
    public void destroyService() {
        NameRegistrar.unregister("mux." + this.getName());
    }

    public static MUX getMUX(String name) throws NameRegistrar.NotFoundException {
        return (MUX)NameRegistrar.get("mux." + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISOMsg request(ISOMsg m, long timeout) throws ISOException {
        QMUX qMUX;
        String key = this.getKey(m);
        String req = key + ".req";
        if (this.sp.rdp(req) != null) {
            throw new ISOException("Duplicate key '" + req + "' detected");
        }
        this.sp.out(req, m);
        m.setDirection(0);
        if (timeout > 0L) {
            this.sp.out(this.out, m, timeout);
        } else {
            this.sp.out(this.out, m);
        }
        ISOMsg resp = null;
        try {
            qMUX = this;
            synchronized (qMUX) {
                ++this.tx;
                ++this.rxPending;
            }
            while (this.shouldIgnore(resp = (ISOMsg)this.sp.rd(key, timeout))) {
            }
            this.sp.inp(key);
            if (resp == null && this.sp.inp(req) == null) {
                resp = (ISOMsg)this.sp.in(key, 10000L);
            }
            qMUX = this;
            synchronized (qMUX) {
                if (resp != null) {
                    ++this.rx;
                    this.lastTxn = System.currentTimeMillis();
                } else {
                    ++this.rxExpired;
                    if (m.getDirection() != 2) {
                        ++this.txExpired;
                    }
                }
            }
        }
        finally {
            qMUX = this;
            synchronized (qMUX) {
                --this.rxPending;
            }
        }
        return resp;
    }

    @Override
    public void notify(Object k, Object value) {
        Object obj = this.sp.inp(k);
        if (obj instanceof ISOMsg) {
            ISOMsg m = (ISOMsg)obj;
            try {
                String key = this.getKey(m);
                String req = key + ".req";
                Object r = this.sp.inp(req);
                if (r != null) {
                    if (r instanceof AsyncRequest) {
                        ((AsyncRequest)r).responseReceived(m);
                    } else {
                        this.sp.out(key, m);
                    }
                    return;
                }
            }
            catch (ISOException e) {
                this.getLog().warn("notify", e);
            }
            this.processUnhandled(m);
        }
    }

    public String getKey(ISOMsg m) throws ISOException {
        StringBuilder sb = new StringBuilder(this.out);
        sb.append('.');
        sb.append(this.mapMTI(m.getMTI()));
        if (this.headerIsKey && m.getHeader() != null) {
            sb.append('.');
            sb.append(ISOUtil.hexString(m.getHeader()));
            sb.append('.');
        }
        boolean hasFields = false;
        for (String f : this.key) {
            String v = m.getString(f);
            if (v == null) continue;
            if ("11".equals(f)) {
                int l;
                String vt = v.trim();
                int n = l = m.getMTI().charAt(0) == '2' ? 12 : 6;
                if (vt.length() < l) {
                    v = ISOUtil.zeropad(vt, l);
                }
            }
            if ("41".equals(f)) {
                v = ISOUtil.zeropad(v.trim(), 16);
            }
            hasFields = true;
            sb.append(v);
        }
        if (!hasFields) {
            throw new ISOException("Key fields not found - not sending " + sb.toString());
        }
        return sb.toString();
    }

    private String mapMTI(String mti) throws ISOException {
        StringBuilder sb = new StringBuilder();
        if (mti != null) {
            if (mti.length() < 4) {
                mti = ISOUtil.zeropad(mti, 4);
            }
            if (mti.length() == 4) {
                for (int i = 0; i < this.mtiMapping.length; ++i) {
                    int c = mti.charAt(i) - 48;
                    if (c < 0 || c >= 10) continue;
                    sb.append(this.mtiMapping[i].charAt(c));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public synchronized void setInQueue(String in) {
        this.in = in;
        this.getPersist().getChild("in").setText(in);
        this.setModified(true);
    }

    @Override
    public String getInQueue() {
        return this.in;
    }

    @Override
    public synchronized void setOutQueue(String out) {
        this.out = out;
        this.getPersist().getChild("out").setText(out);
        this.setModified(true);
    }

    @Override
    public String getOutQueue() {
        return this.out;
    }

    public Space getSpace() {
        return this.sp;
    }

    @Override
    public synchronized void setUnhandledQueue(String unhandled) {
        this.unhandled = unhandled;
        this.getPersist().getChild("unhandled").setText(unhandled);
        this.setModified(true);
    }

    @Override
    public String getUnhandledQueue() {
        return this.unhandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(ISOMsg m, long timeout, ISOResponseListener rl, Object handBack) throws ISOException {
        AsyncRequest ar;
        String key = this.getKey(m);
        String req = key + ".req";
        if (this.sp.rdp(req) != null) {
            throw new ISOException("Duplicate key '" + req + "' detected.");
        }
        m.setDirection(0);
        AsyncRequest asyncRequest = ar = new AsyncRequest(rl, handBack);
        synchronized (asyncRequest) {
            if (timeout > 0L) {
                ar.setFuture(this.getScheduledThreadPoolExecutor().schedule(ar, timeout, TimeUnit.MILLISECONDS));
            }
        }
        this.sp.out(req, ar, timeout);
        this.sp.out(this.out, m, timeout);
    }

    public String[] getReadyIndicatorNames() {
        return this.ready;
    }

    private void addListeners() throws ConfigurationException {
        QFactory factory = this.getFactory();
        for (Element l : this.getPersist().getChildren("request-listener")) {
            ISORequestListener listener = (ISORequestListener)factory.newInstance(l.getAttributeValue("class"));
            factory.setLogger(listener, l);
            factory.setConfiguration(listener, l);
            this.addISORequestListener(listener);
        }
    }

    public void addISORequestListener(ISORequestListener l) {
        this.listeners.add(l);
    }

    public boolean removeISORequestListener(ISORequestListener l) {
        return this.listeners.remove(l);
    }

    @Override
    public synchronized void resetCounters() {
        this.rxForwarded = 0;
        this.rxUnhandled = 0;
        this.rxPending = 0;
        this.txExpired = 0;
        this.rxExpired = 0;
        this.tx = 0;
        this.rx = 0;
        this.lastTxn = 0L;
    }

    @Override
    public String getCountersAsString() {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "tx=", this.tx);
        this.append(sb, ", rx=", this.rx);
        this.append(sb, ", tx_expired=", this.txExpired);
        this.append(sb, ", tx_pending=", this.sp.size(this.out));
        this.append(sb, ", rx_expired=", this.rxExpired);
        this.append(sb, ", rx_pending=", this.rxPending);
        this.append(sb, ", rx_unhandled=", this.rxUnhandled);
        this.append(sb, ", rx_forwarded=", this.rxForwarded);
        sb.append(", connected=");
        sb.append(Boolean.toString(this.isConnected()));
        sb.append(", last=");
        sb.append(this.lastTxn);
        if (this.lastTxn > 0L) {
            sb.append(", idle=");
            sb.append(System.currentTimeMillis() - this.lastTxn);
            sb.append("ms");
        }
        return sb.toString();
    }

    @Override
    public int getTXCounter() {
        return this.tx;
    }

    @Override
    public int getRXCounter() {
        return this.rx;
    }

    @Override
    public long getLastTxnTimestampInMillis() {
        return this.lastTxn;
    }

    @Override
    public long getIdleTimeInMillis() {
        return this.lastTxn > 0L ? System.currentTimeMillis() - this.lastTxn : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUnhandled(ISOMsg m) {
        QMUX qMUX;
        ISOSource source = m.getSource() != null ? m.getSource() : this;
        Iterator iter = this.listeners.iterator();
        if (iter.hasNext()) {
            qMUX = this;
            synchronized (qMUX) {
                ++this.rxForwarded;
            }
        }
        while (iter.hasNext()) {
            if (!((ISORequestListener)iter.next()).process(source, m)) continue;
            return;
        }
        if (this.unhandled != null) {
            qMUX = this;
            synchronized (qMUX) {
                ++this.rxUnhandled;
            }
            this.sp.out(this.unhandled, m, 120000L);
        }
    }

    private LocalSpace grabSpace(Element e) throws ConfigurationException {
        String uri = e != null ? e.getText() : "";
        Space sp = SpaceFactory.getSpace(uri);
        if (sp instanceof LocalSpace) {
            return (LocalSpace)sp;
        }
        throw new ConfigurationException("Invalid space " + uri);
    }

    @Override
    public void send(ISOMsg m) throws IOException, ISOException {
        this.sp.out(this.out, m);
    }

    @Override
    public boolean isConnected() {
        if (this.ready != null && this.ready.length > 0) {
            for (String aReady : this.ready) {
                if (this.sp.rdp(aReady) == null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.println(indent + this.getCountersAsString());
    }

    private String[] toStringArray(String s, String delimiter, String def) {
        if (s == null) {
            s = def;
        }
        String[] arr = null;
        if (s != null && s.length() > 0) {
            StringTokenizer st = delimiter != null ? new StringTokenizer(s, delimiter) : new StringTokenizer(s);
            ArrayList<String> l = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if ("header".equalsIgnoreCase(t)) {
                    this.headerIsKey = true;
                    continue;
                }
                l.add(t);
            }
            arr = l.toArray(new String[l.size()]);
        }
        return arr;
    }

    private String[] toStringArray(String s) {
        return this.toStringArray(s, null, null);
    }

    private boolean shouldIgnore(ISOMsg m) {
        if (m != null && this.ignorerc != null && this.ignorerc.length() > 0 && m.hasField(39)) {
            return this.ignorerc.contains(m.getString(39));
        }
        return false;
    }

    private void append(StringBuffer sb, String name, int value) {
        sb.append(name);
        sb.append(value);
    }

    public static class AsyncRequest
    implements Runnable {
        ISOResponseListener rl;
        Object handBack;
        ScheduledFuture future;

        public AsyncRequest(ISOResponseListener rl, Object handBack) {
            this.rl = rl;
            this.handBack = handBack;
        }

        public void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        public void responseReceived(ISOMsg response) {
            if (this.future == null || this.future.cancel(false)) {
                this.rl.responseReceived(response, this.handBack);
            }
        }

        @Override
        public void run() {
            this.rl.expired(this.handBack);
        }
    }
}

