/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.Channel;
import org.jpos.iso.FactoryChannel;
import org.jpos.iso.FilteredChannel;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOClientSocketFactory;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.q2.iso.OneShotChannelAdaptorMBean;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.util.LogSource;
import org.jpos.util.NameRegistrar;

public class OneShotChannelAdaptor
extends QBeanSupport
implements OneShotChannelAdaptorMBean,
Channel {
    Space<String, Object> sp;
    String in;
    String out;
    long delay;
    int maxConnections;
    int maxConnectAttempts;

    private Space<String, Object> grabSpace(Element e) {
        return SpaceFactory.getSpace(e != null ? e.getText() : "");
    }

    public void initAdaptor() {
        Element persist = this.getPersist();
        this.sp = this.grabSpace(persist.getChild("space"));
        this.in = persist.getChildTextTrim("in");
        this.out = persist.getChildTextTrim("out");
        this.delay = 5000L;
        String s = persist.getChildTextTrim("max-connections");
        this.maxConnections = s != null ? Integer.parseInt(s) : 1;
        s = persist.getChildTextTrim("max-connect-attempts");
        this.maxConnectAttempts = s != null ? Integer.parseInt(s) : 15;
    }

    @Override
    public void startService() {
        try {
            this.initAdaptor();
            for (int i = 0; i < this.maxConnections; ++i) {
                Worker w = new Worker(i);
                w.initChannel();
                new Thread(w).start();
            }
            NameRegistrar.register(this.getName(), this);
        }
        catch (Exception e) {
            this.getLog().warn("error starting service", e);
        }
    }

    @Override
    public void stopService() {
        try {
            for (int i = 0; i < this.maxConnections; ++i) {
                this.sp.out(this.in, new Object());
            }
        }
        catch (Exception e) {
            this.getLog().warn("error stopping service", e);
        }
    }

    @Override
    public void destroyService() {
        NameRegistrar.unregister(this.getName());
        NameRegistrar.unregister("channel." + this.getName());
    }

    @Override
    public void send(ISOMsg m) {
        this.sp.out(this.in, m);
    }

    public void send(ISOMsg m, long timeout) {
        this.sp.out(this.in, m, timeout);
    }

    @Override
    public ISOMsg receive() {
        return (ISOMsg)this.sp.in(this.out);
    }

    @Override
    public ISOMsg receive(long timeout) {
        return (ISOMsg)this.sp.in(this.out, timeout);
    }

    @Override
    public synchronized void setInQueue(String in) {
        String old = this.in;
        this.in = in;
        if (old != null) {
            this.sp.out(old, new Object());
        }
        this.getPersist().getChild("in").setText(in);
        this.setModified(true);
    }

    @Override
    public String getInQueue() {
        return this.in;
    }

    @Override
    public synchronized void setOutQueue(String out) {
        this.out = out;
        this.getPersist().getChild("out").setText(out);
        this.setModified(true);
    }

    @Override
    public String getOutQueue() {
        return this.out;
    }

    @Override
    public synchronized void setHost(String host) {
        this.setProperty(this.getProperties("channel"), "host", host);
        this.setModified(true);
    }

    @Override
    public String getHost() {
        return this.getProperty(this.getProperties("channel"), "host");
    }

    @Override
    public synchronized void setPort(int port) {
        this.setProperty(this.getProperties("channel"), "port", Integer.toString(port));
        this.setModified(true);
    }

    @Override
    public int getPort() {
        int port = 0;
        try {
            port = Integer.parseInt(this.getProperty(this.getProperties("channel"), "port"));
        }
        catch (NumberFormatException e) {
            this.getLog().error(e);
        }
        return port;
    }

    @Override
    public synchronized void setSocketFactory(String sFac) {
        this.setProperty(this.getProperties("channel"), "socketFactory", sFac);
        this.setModified(true);
    }

    @Override
    public String getSocketFactory() {
        return this.getProperty(this.getProperties("channel"), "socketFactory");
    }

    public class Worker
    implements Runnable {
        ISOChannel channel;
        int id;

        public Worker(int i) {
            this.id = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("channel-worker-" + this.id);
            int[] handbackFields = OneShotChannelAdaptor.this.cfg.getInts("handback-field");
            while (OneShotChannelAdaptor.this.running()) {
                try {
                    Object o = OneShotChannelAdaptor.this.sp.in(OneShotChannelAdaptor.this.in, OneShotChannelAdaptor.this.delay);
                    if (!(o instanceof ISOMsg)) continue;
                    ISOMsg m = (ISOMsg)o;
                    ISOMsg handBack = null;
                    if (handbackFields.length > 0) {
                        handBack = (ISOMsg)m.clone(handbackFields);
                    }
                    for (int i = 0; !this.channel.isConnected() && i < OneShotChannelAdaptor.this.maxConnectAttempts; ++i) {
                        this.channel.reconnect();
                        if (this.channel.isConnected()) continue;
                        ISOUtil.sleep(1000L);
                    }
                    if (!this.channel.isConnected()) continue;
                    this.channel.send(m);
                    m = this.channel.receive();
                    this.channel.disconnect();
                    if (handBack != null) {
                        m.merge(handBack);
                    }
                    OneShotChannelAdaptor.this.sp.out(OneShotChannelAdaptor.this.out, m);
                }
                catch (Exception e) {
                    OneShotChannelAdaptor.this.getLog().warn("channel-worker-" + this.id, e.getMessage());
                    ISOUtil.sleep(1000L);
                }
                finally {
                    try {
                        this.channel.disconnect();
                    }
                    catch (Exception e) {
                        OneShotChannelAdaptor.this.getLog().warn("channel-worker-" + this.id, e.getMessage());
                    }
                }
            }
        }

        public void initChannel() throws ConfigurationException {
            Element persist = OneShotChannelAdaptor.this.getPersist();
            Element e = persist.getChild("channel");
            if (e == null) {
                throw new ConfigurationException("channel element missing");
            }
            this.channel = this.newChannel(e, OneShotChannelAdaptor.this.getFactory());
            String socketFactoryString = OneShotChannelAdaptor.this.getSocketFactory();
            if (socketFactoryString != null && this.channel instanceof FactoryChannel) {
                ISOClientSocketFactory sFac = (ISOClientSocketFactory)OneShotChannelAdaptor.this.getFactory().newInstance(socketFactoryString);
                if (sFac != null && sFac instanceof LogSource) {
                    ((LogSource)((Object)sFac)).setLogger(OneShotChannelAdaptor.this.log.getLogger(), OneShotChannelAdaptor.this.getName() + ".socket-factory");
                }
                OneShotChannelAdaptor.this.getFactory().setConfiguration(sFac, e);
                ((FactoryChannel)((Object)this.channel)).setSocketFactory(sFac);
            }
        }

        private ISOChannel newChannel(Element e, QFactory f) throws ConfigurationException {
            String channelName = e.getAttributeValue("class");
            if (channelName == null) {
                throw new ConfigurationException("class attribute missing from channel element.");
            }
            String packagerName = e.getAttributeValue("packager");
            ISOChannel channel = (ISOChannel)f.newInstance(channelName);
            if (packagerName != null) {
                ISOPackager packager = (ISOPackager)f.newInstance(packagerName);
                channel.setPackager(packager);
                f.setConfiguration(packager, e);
            }
            QFactory.invoke(channel, "setHeader", e.getAttributeValue("header"));
            f.setLogger(channel, e);
            f.setConfiguration(channel, e);
            if (channel instanceof FilteredChannel) {
                this.addFilters((FilteredChannel)channel, e, f);
            }
            if (OneShotChannelAdaptor.this.getName() != null) {
                channel.setName(OneShotChannelAdaptor.this.getName() + this.id);
            }
            return channel;
        }

        private void addFilters(FilteredChannel channel, Element e, QFactory fact) throws ConfigurationException {
            for (Object o : e.getChildren("filter")) {
                Element f = (Element)o;
                String clazz = f.getAttributeValue("class");
                ISOFilter filter = (ISOFilter)fact.newInstance(clazz);
                fact.setLogger(filter, f);
                fact.setConfiguration(filter, f);
                String direction = f.getAttributeValue("direction");
                if (direction == null) {
                    channel.addFilter(filter);
                    continue;
                }
                if ("incoming".equalsIgnoreCase(direction)) {
                    channel.addIncomingFilter(filter);
                    continue;
                }
                if ("outgoing".equalsIgnoreCase(direction)) {
                    channel.addOutgoingFilter(filter);
                    continue;
                }
                if (!"both".equalsIgnoreCase(direction)) continue;
                channel.addIncomingFilter(filter);
                channel.addOutgoingFilter(filter);
            }
        }
    }
}

