/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import java.io.IOException;
import java.util.Date;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.Channel;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.iso.ChannelAdaptor;
import org.jpos.q2.iso.MultiSessionChannelAdaptorMBean;
import org.jpos.space.SpaceUtil;
import org.jpos.util.LogSource;
import org.jpos.util.Loggeable;
import org.jpos.util.NameRegistrar;

public class MultiSessionChannelAdaptor
extends ChannelAdaptor
implements MultiSessionChannelAdaptorMBean,
Channel,
Loggeable {
    int sessions = 1;
    ISOChannel[] channels;
    int roundRobinCounter = 0;

    public MultiSessionChannelAdaptor() {
        this.resetCounters();
    }

    @Override
    public void initService() throws ConfigurationException {
        this.initSpaceAndQueues();
        NameRegistrar.register(this.getName(), this);
    }

    @Override
    public void startService() {
        try {
            this.channels = new ISOChannel[this.sessions];
            for (int i = 0; i < this.sessions; ++i) {
                ISOChannel c = this.initChannel();
                if (c instanceof LogSource) {
                    LogSource ls = (LogSource)((Object)c);
                    ls.setLogger(ls.getLogger(), ls.getRealm() + "-" + i);
                }
                this.channels[i] = c;
                if (this.writeOnly) continue;
                new Thread((Runnable)new Receiver(i), "channel-receiver-" + this.in + "-" + i).start();
            }
            new Thread((Runnable)new Sender(), "channel-sender-" + this.in).start();
        }
        catch (Exception e) {
            this.getLog().warn("error starting service", e);
        }
    }

    @Override
    public int getSessions() {
        return this.sessions;
    }

    @Override
    public void setSessions(int sessions) {
        this.sessions = sessions;
    }

    @Override
    protected void initSpaceAndQueues() throws ConfigurationException {
        super.initSpaceAndQueues();
        Element persist = this.getPersist();
        String s = persist.getChildTextTrim("sessions");
        this.setSessions(s != null && s.length() > 0 ? Integer.parseInt(s) : 1);
    }

    private void connect(int slot) {
        ISOChannel c = this.channels[slot];
        if (c != null && !c.isConnected()) {
            try {
                c.connect();
                this.sp.put(this.ready, new Date());
            }
            catch (IOException e) {
                this.getLog().warn("check-connection(" + slot + ") " + c.toString(), e.getMessage());
            }
        }
    }

    private void disconnect(ISOChannel channel) {
        try {
            if (this.getConnectedCount() <= 1) {
                SpaceUtil.wipe(this.sp, this.ready);
            }
            channel.disconnect();
        }
        catch (IOException e) {
            this.getLog().warn("disconnect", e);
        }
    }

    private void disconnectAll() {
        for (ISOChannel channel : this.channels) {
            this.disconnect(channel);
        }
    }

    private ISOChannel getNextChannel() {
        ISOChannel c = null;
        for (int size = this.channels.length; !(size <= 0 || (c = this.channels[this.roundRobinCounter++ % this.channels.length]) != null && c.isConnected()); --size) {
        }
        if (c == null) {
            SpaceUtil.wipe(this.sp, this.ready);
        }
        return c;
    }

    private int getConnectedCount() {
        int connected = 0;
        for (ISOChannel c : this.channels) {
            if (c == null || !c.isConnected()) continue;
            ++connected;
        }
        return connected;
    }

    public class Receiver
    implements Runnable {
        int slot;
        ISOChannel channel;

        public Receiver(int slot) {
            this.channel = MultiSessionChannelAdaptor.this.channels[slot];
            this.slot = slot;
        }

        @Override
        public void run() {
            ISOUtil.sleep(this.slot * 10);
            while (MultiSessionChannelAdaptor.this.running()) {
                try {
                    if (!this.channel.isConnected()) {
                        MultiSessionChannelAdaptor.this.connect(this.slot);
                        if (!this.channel.isConnected()) {
                            ISOUtil.sleep(MultiSessionChannelAdaptor.this.delay);
                            continue;
                        }
                    }
                    ISOMsg m = this.channel.receive();
                    ++MultiSessionChannelAdaptor.this.rx;
                    MultiSessionChannelAdaptor.this.lastTxn = System.currentTimeMillis();
                    if (MultiSessionChannelAdaptor.this.timeout > 0L) {
                        MultiSessionChannelAdaptor.this.sp.out(MultiSessionChannelAdaptor.this.out, m, MultiSessionChannelAdaptor.this.timeout);
                        continue;
                    }
                    MultiSessionChannelAdaptor.this.sp.out(MultiSessionChannelAdaptor.this.out, m);
                }
                catch (ISOException e) {
                    if (!MultiSessionChannelAdaptor.this.running()) continue;
                    MultiSessionChannelAdaptor.this.getLog().warn("channel-receiver-" + MultiSessionChannelAdaptor.this.out, e);
                    if (!MultiSessionChannelAdaptor.this.ignoreISOExceptions) {
                        MultiSessionChannelAdaptor.this.disconnect(this.channel);
                    }
                    ISOUtil.sleep(1000L);
                }
                catch (Exception e) {
                    if (!MultiSessionChannelAdaptor.this.running()) continue;
                    MultiSessionChannelAdaptor.this.getLog().warn("channel-receiver-" + MultiSessionChannelAdaptor.this.out, e);
                    MultiSessionChannelAdaptor.this.disconnect(this.channel);
                    ISOUtil.sleep(1000L);
                }
            }
        }
    }

    public class Sender
    implements Runnable {
        @Override
        public void run() {
            while (MultiSessionChannelAdaptor.this.running()) {
                ISOChannel channel = null;
                try {
                    if (!MultiSessionChannelAdaptor.this.running()) break;
                    if (MultiSessionChannelAdaptor.this.sp.rd(MultiSessionChannelAdaptor.this.ready, MultiSessionChannelAdaptor.this.delay) == null) continue;
                    Object o = MultiSessionChannelAdaptor.this.sp.in(MultiSessionChannelAdaptor.this.in, MultiSessionChannelAdaptor.this.delay);
                    channel = MultiSessionChannelAdaptor.this.getNextChannel();
                    if (!(o instanceof ISOMsg) || channel == null) continue;
                    channel.send((ISOMsg)o);
                    ++MultiSessionChannelAdaptor.this.tx;
                }
                catch (ISOFilter.VetoException e) {
                    MultiSessionChannelAdaptor.this.getLog().warn("channel-sender-" + MultiSessionChannelAdaptor.this.in, e.getMessage());
                }
                catch (ISOException e) {
                    MultiSessionChannelAdaptor.this.getLog().warn("channel-sender-" + MultiSessionChannelAdaptor.this.in, e.getMessage());
                    if (!MultiSessionChannelAdaptor.this.ignoreISOExceptions) {
                        MultiSessionChannelAdaptor.this.disconnect(channel);
                    }
                    ISOUtil.sleep(1000L);
                }
                catch (Exception e) {
                    MultiSessionChannelAdaptor.this.getLog().warn("channel-sender-" + MultiSessionChannelAdaptor.this.in, e.getMessage());
                    MultiSessionChannelAdaptor.this.disconnect(channel);
                    ISOUtil.sleep(1000L);
                }
            }
            MultiSessionChannelAdaptor.this.disconnectAll();
        }
    }
}

