/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import java.util.StringTokenizer;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOResponseListener;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.MUX;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.iso.QMUX;
import org.jpos.util.NameRegistrar;

public class MUXPool
extends QBeanSupport
implements MUX {
    int strategy = 0;
    String[] muxName;
    MUX[] mux;
    int msgno = 0;
    public static final int ROUND_ROBIN = 1;
    public static final int PRIMARY_SECONDARY = 0;

    @Override
    public void initService() throws ConfigurationException {
        Element e = this.getPersist();
        this.muxName = this.toStringArray(e.getChildTextTrim("muxes"));
        String s = e.getChildTextTrim("strategy");
        this.strategy = "round-robin".equals(s) ? 1 : 0;
        this.mux = new MUX[this.muxName.length];
        try {
            for (int i = 0; i < this.mux.length; ++i) {
                this.mux[i] = QMUX.getMUX(this.muxName[i]);
            }
        }
        catch (NameRegistrar.NotFoundException ex) {
            throw new ConfigurationException(ex);
        }
        NameRegistrar.register("mux." + this.getName(), this);
    }

    @Override
    public void stopService() {
        NameRegistrar.unregister("mux." + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISOMsg request(ISOMsg m, long timeout) throws ISOException {
        MUX mux;
        int mnumber = 0;
        long maxWait = System.currentTimeMillis() + timeout;
        MUXPool mUXPool = this;
        synchronized (mUXPool) {
            mnumber = this.msgno++;
        }
        MUX mUX = mux = this.strategy == 1 ? this.nextAvailableMUX(mnumber, maxWait) : this.firstAvailableMUX(maxWait);
        if (mux != null && (timeout = maxWait - System.currentTimeMillis()) >= 0L) {
            return mux.request(m, timeout);
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        for (MUX aMux : this.mux) {
            if (!aMux.isConnected()) continue;
            return true;
        }
        return false;
    }

    private MUX firstAvailableMUX(long maxWait) {
        do {
            for (MUX aMux : this.mux) {
                if (!aMux.isConnected()) continue;
                return aMux;
            }
            ISOUtil.sleep(1000L);
        } while (System.currentTimeMillis() < maxWait);
        return null;
    }

    private MUX nextAvailableMUX(int mnumber, long maxWait) {
        do {
            for (int i = 0; i < this.mux.length; ++i) {
                int j = (mnumber + i) % this.mux.length;
                if (!this.mux[j].isConnected()) continue;
                return this.mux[j];
            }
            ISOUtil.sleep(1000L);
        } while (System.currentTimeMillis() < maxWait);
        return null;
    }

    private String[] toStringArray(String s) {
        String[] ss = null;
        if (s != null && s.length() > 0) {
            StringTokenizer st = new StringTokenizer(s);
            ss = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                ss[i] = st.nextToken();
                ++i;
            }
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(ISOMsg m, long timeout, final ISOResponseListener r, final Object handBack) throws ISOException {
        MUX mux;
        int mnumber = 0;
        long maxWait = System.currentTimeMillis() + timeout;
        MUXPool mUXPool = this;
        synchronized (mUXPool) {
            mnumber = this.msgno++;
        }
        MUX mUX = mux = this.strategy == 1 ? this.nextAvailableMUX(mnumber, maxWait) : this.firstAvailableMUX(maxWait);
        if (mux != null) {
            timeout = maxWait - System.currentTimeMillis();
            if (timeout >= 0L) {
                mux.request(m, timeout, r, handBack);
            } else {
                new Thread(){

                    @Override
                    public void run() {
                        r.expired(handBack);
                    }
                }.start();
            }
        } else {
            throw new ISOException("No MUX available");
        }
    }
}

