/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.q2.iso.DirPollAdaptorMBean;
import org.jpos.util.DirPoll;
import org.jpos.util.LogSource;
import org.jpos.util.ThreadPool;

public class DirPollAdaptor
extends QBeanSupport
implements DirPollAdaptorMBean {
    String path;
    String priorities;
    String processorClass;
    int poolSize = 1;
    long pollInterval = 1000L;
    protected DirPoll dirPoll;

    @Override
    protected void initService() throws Exception {
        QFactory factory = this.getServer().getFactory();
        this.dirPoll = new DirPoll();
        this.dirPoll.setPath(this.getPath());
        this.dirPoll.setThreadPool(new ThreadPool(1, this.poolSize));
        this.dirPoll.setPollInterval(this.pollInterval);
        if (this.priorities != null) {
            this.dirPoll.setPriorities(this.priorities);
        }
        this.dirPoll.setLogger(this.getLog().getLogger(), this.getLog().getRealm());
        Configuration cfg = factory.getConfiguration(this.getPersist());
        this.dirPoll.setConfiguration(cfg);
        this.dirPoll.createDirs();
        Object dpp = factory.newInstance(this.getProcessor());
        if (dpp instanceof LogSource) {
            ((LogSource)dpp).setLogger(this.getLog().getLogger(), this.getLog().getRealm());
        }
        if (dpp instanceof Configurable) {
            ((Configurable)dpp).setConfiguration(cfg);
        }
        this.dirPoll.setProcessor(dpp);
    }

    @Override
    protected void startService() throws Exception {
        new Thread(this.dirPoll).start();
    }

    @Override
    protected void stopService() throws Exception {
        this.dirPoll.destroy();
    }

    @Override
    public synchronized void setPath(String path) {
        this.path = path;
        this.setModified(true);
    }

    @Override
    public synchronized void setPoolSize(int size) {
        this.poolSize = size;
        this.setModified(true);
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public String getPath() {
        return this.path == null ? "." : this.path;
    }

    @Override
    public synchronized void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
        this.setModified(true);
    }

    @Override
    public long getPollInterval() {
        return this.pollInterval;
    }

    @Override
    public synchronized void setPriorities(String priorities) {
        this.priorities = priorities;
        this.setModified(true);
    }

    @Override
    public String getPriorities() {
        return this.priorities;
    }

    @Override
    public synchronized void setProcessor(String processor) {
        this.processorClass = processor;
        this.setModified(true);
    }

    @Override
    public String getProcessor() {
        return this.processorClass;
    }
}

