/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import java.util.Date;
import java.util.GregorianCalendar;
import org.jdom.Element;
import org.jpos.core.Configurable;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;

public class DailyTaskAdaptor
extends QBeanSupport
implements Runnable {
    Runnable task;
    Thread thisThread = null;

    @Override
    protected void initService() throws Exception {
        QFactory factory = this.getServer().getFactory();
        Element e = this.getPersist();
        this.task = (Runnable)factory.newInstance(e.getChildTextTrim("class"));
        factory.setLogger(this.task, e);
    }

    @Override
    protected void startService() throws Exception {
        if (this.task instanceof Configurable) {
            Element e = this.getPersist();
            QFactory factory = this.getServer().getFactory();
            ((Configurable)((Object)this.task)).setConfiguration(factory.getConfiguration(e));
        }
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    @Override
    protected void stopService() throws Exception {
        if (this.thisThread != null) {
            this.thisThread.interrupt();
        }
    }

    @Override
    public void run() {
        while (this.running()) {
            this.waitUntilStartTime();
            if (!this.running()) continue;
            Thread taskThread = new Thread(this.task);
            taskThread.setDaemon(true);
            taskThread.start();
            ISOUtil.sleep(1000L);
        }
    }

    public Date getWhen() {
        String s = this.cfg.get("start") + ":00:00";
        int hh = Integer.parseInt(s.substring(0, 2));
        int mm = Integer.parseInt(s.substring(3, 5));
        int ss = Integer.parseInt(s.substring(6, 8));
        Date now = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(now);
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        Date when = cal.getTime();
        if (when.before(now)) {
            when = new Date(when.getTime() + 86400000L);
        }
        return when;
    }

    protected void waitUntilStartTime() {
        Date now;
        Date when = this.getWhen();
        while (this.running() && (now = new GregorianCalendar().getTime()).before(when)) {
            long sleepTime = when.getTime() - now.getTime();
            if (sleepTime <= 0L) {
                ISOUtil.sleep(1000L);
                continue;
            }
            this.getLog().info("sleeping", sleepTime / 1000L + " secs until " + when.toString());
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                when = this.getWhen();
            }
        }
    }
}

