/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.q2.QBeanSupport;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.transaction.Context;
import org.jpos.util.Loggeable;
import org.jpos.util.NameRegistrar;

public class ContextMaker
extends QBeanSupport
implements Runnable,
Loggeable {
    Space sp;
    String contextName = null;
    String in = null;
    String out = null;
    String source = null;
    Long timeout;
    private List<Element> contextValues = null;

    @Override
    public void initService() {
        NameRegistrar.register(this.getName(), this);
    }

    @Override
    public void startService() {
        NameRegistrar.register(this.getName(), this);
        new Thread(this).start();
    }

    @Override
    public void stopService() {
        NameRegistrar.unregister(this.getName());
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getName());
        while (this.running()) {
            Object o = this.sp.in(this.in, this.timeout);
            if (o == null) continue;
            Context ctx = new Context();
            ctx.put(this.contextName, o);
            if (this.contextValues != null) {
                for (Element e : this.contextValues) {
                    ctx.put(e.getName(), e.getValue());
                }
            }
            this.sp.out(this.out, ctx);
        }
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        super.setConfiguration(cfg);
        Element persist = this.getPersist();
        String ssp = persist.getChildText("space");
        this.sp = SpaceFactory.getSpace(ssp != null ? ssp : "");
        String sTimeout = persist.getChildText("timeout");
        this.timeout = sTimeout == null ? 10000L : Long.parseLong(sTimeout);
        this.contextName = persist.getChildText("context-name");
        if (this.contextName == null) {
            throw new ConfigurationException("Missing 'context-name' property - the context name of the object received on 'in'");
        }
        this.in = persist.getChildText("in");
        if (this.in == null) {
            throw new ConfigurationException("Missing 'in' property - the queue to process objects from.");
        }
        this.out = persist.getChildText("out");
        if (this.out == null) {
            throw new ConfigurationException("Missing 'out' property - the target queue of the created context");
        }
        Element values = persist.getChild("context-values");
        if (values != null) {
            this.contextValues = values.getChildren();
        }
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.println(indent + "<ContextMaker name='" + this.getName() + "'>");
        for (Element e : this.contextValues) {
            p.println(indent + "<" + indent + e.getName() + ">" + e.getValue() + "</" + indent + e.getName() + ">");
        }
        p.println(indent + "</ContextMaker>");
    }
}

