/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.iso;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.util.Date;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.Channel;
import org.jpos.iso.FactoryChannel;
import org.jpos.iso.FilteredChannel;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOClientSocketFactory;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.q2.iso.ChannelAdaptorMBean;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.util.LogSource;
import org.jpos.util.Loggeable;
import org.jpos.util.NameRegistrar;

public class ChannelAdaptor
extends QBeanSupport
implements ChannelAdaptorMBean,
Channel,
Loggeable {
    Space sp;
    private ISOChannel channel;
    String in;
    String out;
    String ready;
    String reconnect;
    long delay;
    boolean keepAlive = false;
    boolean ignoreISOExceptions = false;
    boolean writeOnly = false;
    int rx;
    int tx;
    int connects;
    long lastTxn = 0L;
    long timeout = 0L;
    boolean waitForWorkersOnStop;
    private Thread receiver;
    private Thread sender;
    private final Object disconnectLock = new Object();

    public ChannelAdaptor() {
        this.resetCounters();
    }

    @Override
    public void initService() throws ConfigurationException {
        this.initSpaceAndQueues();
        NameRegistrar.register(this.getName(), this);
    }

    @Override
    public void startService() {
        try {
            this.channel = this.initChannel();
            this.sender = new Thread(new Sender());
            this.sender.start();
            if (!this.writeOnly) {
                this.receiver = new Thread(new Receiver());
                this.receiver.start();
            }
        }
        catch (Exception e) {
            this.getLog().warn("error starting service", e);
        }
    }

    @Override
    public void stopService() {
        try {
            this.sp.out(this.in, new Object());
            if (this.channel != null) {
                this.disconnect();
            }
            if (this.waitForWorkersOnStop) {
                this.waitForSenderToExit();
                if (!this.writeOnly) {
                    this.sp.out(this.ready, new Object());
                    this.waitForReceiverToExit();
                }
            }
            this.sender = null;
            this.receiver = null;
        }
        catch (Exception e) {
            this.getLog().warn("error disconnecting from remote host", e);
        }
    }

    private void waitForSenderToExit() {
        this.join(this.sender);
    }

    private void waitForReceiverToExit() {
        this.join(this.receiver);
        while (this.sp.inp(this.ready) != null) {
        }
    }

    private void join(Thread thread) {
        try {
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void destroyService() {
        NameRegistrar.unregister(this.getName());
        NameRegistrar.unregister("channel." + this.getName());
    }

    @Override
    public synchronized void setReconnectDelay(long delay) {
        this.getPersist().getChild("reconnect-delay").setText(Long.toString(delay));
        this.delay = delay;
        this.setModified(true);
    }

    @Override
    public long getReconnectDelay() {
        return this.delay;
    }

    @Override
    public synchronized void setInQueue(String in) {
        String old = this.in;
        this.in = in;
        if (old != null) {
            this.sp.out(old, new Object());
        }
        this.getPersist().getChild("in").setText(in);
        this.setModified(true);
    }

    @Override
    public String getInQueue() {
        return this.in;
    }

    @Override
    public synchronized void setOutQueue(String out) {
        this.out = out;
        this.getPersist().getChild("out").setText(out);
        this.setModified(true);
    }

    @Override
    public void send(ISOMsg m) {
        this.sp.out(this.in, m);
    }

    public void send(ISOMsg m, long timeout) {
        this.sp.out(this.in, m, timeout);
    }

    @Override
    public ISOMsg receive() {
        return (ISOMsg)this.sp.in(this.out);
    }

    @Override
    public ISOMsg receive(long timeout) {
        return (ISOMsg)this.sp.in(this.out, timeout);
    }

    @Override
    public boolean isConnected() {
        return this.sp != null && this.sp.rdp(this.ready) != null;
    }

    @Override
    public String getOutQueue() {
        return this.out;
    }

    public ISOChannel newChannel(Element e, QFactory f) throws ConfigurationException {
        String channelName = e.getAttributeValue("class");
        String packagerName = e.getAttributeValue("packager");
        ISOChannel channel = (ISOChannel)f.newInstance(channelName);
        ISOPackager packager = null;
        if (packagerName != null) {
            packager = (ISOPackager)f.newInstance(packagerName);
            channel.setPackager(packager);
            f.setConfiguration(packager, e);
        }
        QFactory.invoke(channel, "setHeader", e.getAttributeValue("header"));
        f.setLogger(channel, e);
        f.setConfiguration(channel, e);
        if (channel instanceof FilteredChannel) {
            this.addFilters((FilteredChannel)channel, e, f);
        }
        if (this.getName() != null) {
            channel.setName(this.getName());
        }
        return channel;
    }

    protected void addFilters(FilteredChannel channel, Element e, QFactory fact) throws ConfigurationException {
        for (Element f : e.getChildren("filter")) {
            String clazz = f.getAttributeValue("class");
            ISOFilter filter = (ISOFilter)fact.newInstance(clazz);
            fact.setLogger(filter, f);
            fact.setConfiguration(filter, f);
            String direction = f.getAttributeValue("direction");
            if (direction == null) {
                channel.addFilter(filter);
                continue;
            }
            if ("incoming".equalsIgnoreCase(direction)) {
                channel.addIncomingFilter(filter);
                continue;
            }
            if ("outgoing".equalsIgnoreCase(direction)) {
                channel.addOutgoingFilter(filter);
                continue;
            }
            if (!"both".equalsIgnoreCase(direction)) continue;
            channel.addIncomingFilter(filter);
            channel.addOutgoingFilter(filter);
        }
    }

    protected ISOChannel initChannel() throws ConfigurationException {
        Element persist = this.getPersist();
        Element e = persist.getChild("channel");
        if (e == null) {
            throw new ConfigurationException("channel element missing");
        }
        ISOChannel c = this.newChannel(e, this.getFactory());
        String socketFactoryString = this.getSocketFactory();
        if (socketFactoryString != null && c instanceof FactoryChannel) {
            ISOClientSocketFactory sFac = (ISOClientSocketFactory)this.getFactory().newInstance(socketFactoryString);
            if (sFac != null && sFac instanceof LogSource) {
                ((LogSource)((Object)sFac)).setLogger(this.log.getLogger(), this.getName() + ".socket-factory");
            }
            this.getFactory().setConfiguration(sFac, e);
            ((FactoryChannel)((Object)c)).setSocketFactory(sFac);
        }
        return c;
    }

    protected void initSpaceAndQueues() throws ConfigurationException {
        Element persist = this.getPersist();
        this.sp = this.grabSpace(persist.getChild("space"));
        this.in = persist.getChildTextTrim("in");
        this.out = persist.getChildTextTrim("out");
        String s = persist.getChildTextTrim("reconnect-delay");
        this.delay = s != null ? Long.parseLong(s) : 10000L;
        this.keepAlive = "yes".equalsIgnoreCase(persist.getChildTextTrim("keep-alive"));
        this.ignoreISOExceptions = "yes".equalsIgnoreCase(persist.getChildTextTrim("ignore-iso-exceptions"));
        this.writeOnly = "yes".equalsIgnoreCase(this.getPersist().getChildTextTrim("write-only"));
        String t = persist.getChildTextTrim("timeout");
        this.timeout = t != null && t.length() > 0 ? Long.parseLong(t) : 0L;
        this.ready = this.getName() + ".ready";
        this.reconnect = this.getName() + ".reconnect";
        this.waitForWorkersOnStop = "yes".equalsIgnoreCase(persist.getChildTextTrim("wait-for-workers-on-stop"));
    }

    protected void checkConnection() {
        while (this.running() && this.sp.rdp(this.reconnect) != null) {
            ISOUtil.sleep(1000L);
        }
        while (this.running() && !this.channel.isConnected()) {
            while (this.sp.inp(this.ready) != null) {
            }
            try {
                this.channel.connect();
            }
            catch (IOException e) {
                this.getLog().warn("check-connection", e.getMessage());
            }
            if (!this.channel.isConnected()) {
                ISOUtil.sleep(this.delay);
                continue;
            }
            ++this.connects;
        }
        if (this.running() && this.sp.rdp(this.ready) == null) {
            this.sp.out(this.ready, new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        Object object = this.disconnectLock;
        synchronized (object) {
            try {
                while (this.sp.inp(this.ready) != null) {
                }
                this.channel.disconnect();
            }
            catch (IOException e) {
                this.getLog().warn("disconnect", e);
            }
        }
    }

    @Override
    public synchronized void setHost(String host) {
        this.setProperty(this.getProperties("channel"), "host", host);
        this.setModified(true);
    }

    @Override
    public String getHost() {
        return this.getProperty(this.getProperties("channel"), "host");
    }

    @Override
    public synchronized void setPort(int port) {
        this.setProperty(this.getProperties("channel"), "port", Integer.toString(port));
        this.setModified(true);
    }

    @Override
    public int getPort() {
        int port = 0;
        try {
            port = Integer.parseInt(this.getProperty(this.getProperties("channel"), "port"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    @Override
    public synchronized void setSocketFactory(String sFac) {
        this.setProperty(this.getProperties("channel"), "socketFactory", sFac);
        this.setModified(true);
    }

    @Override
    public void resetCounters() {
        this.connects = 0;
        this.tx = 0;
        this.rx = 0;
        this.lastTxn = 0L;
    }

    @Override
    public String getCountersAsString() {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "tx=", this.tx);
        this.append(sb, ", rx=", this.rx);
        this.append(sb, ", connects=", this.connects);
        sb.append(", last=");
        sb.append(this.lastTxn);
        if (this.lastTxn > 0L) {
            sb.append(", idle=");
            sb.append(System.currentTimeMillis() - this.lastTxn);
            sb.append("ms");
        }
        return sb.toString();
    }

    @Override
    public int getTXCounter() {
        return this.tx;
    }

    @Override
    public int getRXCounter() {
        return this.rx;
    }

    @Override
    public int getConnectsCounter() {
        return this.connects;
    }

    @Override
    public long getLastTxnTimestampInMillis() {
        return this.lastTxn;
    }

    @Override
    public long getIdleTimeInMillis() {
        return this.lastTxn > 0L ? System.currentTimeMillis() - this.lastTxn : -1L;
    }

    @Override
    public String getSocketFactory() {
        return this.getProperty(this.getProperties("channel"), "socketFactory");
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.println(indent + this.getCountersAsString());
    }

    protected Space grabSpace(Element e) {
        return SpaceFactory.getSpace(e != null ? e.getText() : "");
    }

    protected void append(StringBuffer sb, String name, int value) {
        sb.append(name);
        sb.append(value);
    }

    public class Receiver
    implements Runnable {
        @Override
        public void run() {
            Thread.currentThread().setName("channel-receiver-" + ChannelAdaptor.this.out);
            while (ChannelAdaptor.this.running()) {
                try {
                    Object r = ChannelAdaptor.this.sp.rd(ChannelAdaptor.this.ready, 5000L);
                    if (r == null) continue;
                    ISOMsg m = ChannelAdaptor.this.channel.receive();
                    ++ChannelAdaptor.this.rx;
                    ChannelAdaptor.this.lastTxn = System.currentTimeMillis();
                    if (ChannelAdaptor.this.timeout > 0L) {
                        ChannelAdaptor.this.sp.out(ChannelAdaptor.this.out, m, ChannelAdaptor.this.timeout);
                        continue;
                    }
                    ChannelAdaptor.this.sp.out(ChannelAdaptor.this.out, m);
                }
                catch (ISOException e) {
                    if (!ChannelAdaptor.this.running()) continue;
                    ChannelAdaptor.this.getLog().warn("channel-receiver-" + ChannelAdaptor.this.out, e);
                    if (!ChannelAdaptor.this.ignoreISOExceptions) {
                        ChannelAdaptor.this.sp.out(ChannelAdaptor.this.reconnect, new Object(), ChannelAdaptor.this.delay);
                        ChannelAdaptor.this.disconnect();
                        ChannelAdaptor.this.sp.out(ChannelAdaptor.this.in, new Object());
                    }
                    ISOUtil.sleep(1000L);
                }
                catch (SocketTimeoutException e) {
                    if (!ChannelAdaptor.this.running()) continue;
                    ChannelAdaptor.this.getLog().warn("channel-receiver-" + ChannelAdaptor.this.out, "Read timeout");
                    ChannelAdaptor.this.sp.out(ChannelAdaptor.this.reconnect, new Object(), ChannelAdaptor.this.delay);
                    ChannelAdaptor.this.disconnect();
                    ChannelAdaptor.this.sp.out(ChannelAdaptor.this.in, new Object());
                    ISOUtil.sleep(1000L);
                }
                catch (Exception e) {
                    if (!ChannelAdaptor.this.running()) continue;
                    ChannelAdaptor.this.getLog().warn("channel-receiver-" + ChannelAdaptor.this.out, e);
                    ChannelAdaptor.this.sp.out(ChannelAdaptor.this.reconnect, new Object(), ChannelAdaptor.this.delay);
                    ChannelAdaptor.this.disconnect();
                    ChannelAdaptor.this.sp.out(ChannelAdaptor.this.in, new Object());
                    ISOUtil.sleep(1000L);
                }
            }
        }
    }

    public class Sender
    implements Runnable {
        @Override
        public void run() {
            Thread.currentThread().setName("channel-sender-" + ChannelAdaptor.this.in);
            while (ChannelAdaptor.this.running()) {
                try {
                    ChannelAdaptor.this.checkConnection();
                    if (!ChannelAdaptor.this.running()) break;
                    Object o = ChannelAdaptor.this.sp.in(ChannelAdaptor.this.in, ChannelAdaptor.this.delay);
                    if (o instanceof ISOMsg) {
                        ChannelAdaptor.this.channel.send((ISOMsg)o);
                        ++ChannelAdaptor.this.tx;
                        continue;
                    }
                    if (!ChannelAdaptor.this.keepAlive || !ChannelAdaptor.this.channel.isConnected() || !(ChannelAdaptor.this.channel instanceof BaseChannel)) continue;
                    ((BaseChannel)ChannelAdaptor.this.channel).sendKeepAlive();
                }
                catch (ISOFilter.VetoException e) {
                    ChannelAdaptor.this.getLog().warn("channel-sender-" + ChannelAdaptor.this.in, e.getMessage());
                }
                catch (ISOException e) {
                    ChannelAdaptor.this.getLog().warn("channel-sender-" + ChannelAdaptor.this.in, e.getMessage());
                    if (!ChannelAdaptor.this.ignoreISOExceptions) {
                        ChannelAdaptor.this.disconnect();
                    }
                    ISOUtil.sleep(1000L);
                }
                catch (Exception e) {
                    ChannelAdaptor.this.getLog().warn("channel-sender-" + ChannelAdaptor.this.in, e.getMessage());
                    ChannelAdaptor.this.disconnect();
                    ISOUtil.sleep(1000L);
                }
            }
        }
    }
}

