/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.install;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;

public class ModuleUtils {
    public static List<String> getModuleEntries(String prefix) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<URL> urls = ModuleUtils.class.getClassLoader().getResources(prefix);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) {
                return Collections.emptyList();
            }
            try {
                List<String> lst = url.getProtocol().equals("jar") ? ModuleUtils.resolveModuleEntriesFromJar(url, prefix) : ModuleUtils.resolveModuleEntriesFromFiles(url, prefix);
                result.addAll(lst);
            }
            catch (URISyntaxException e) {
                throw new IOException("Bad URL", e);
            }
        }
        return result;
    }

    private static List<String> resolveModuleEntriesFromFiles(URL url, String _prefix) throws IOException, URISyntaxException {
        String prefix = _prefix.endsWith("/") ? _prefix : _prefix + "/";
        ArrayList<String> resourceList = new ArrayList<String>();
        URI uri = url.toURI();
        File f = new File(uri);
        ModuleUtils.addFiles(f, prefix, resourceList);
        return resourceList;
    }

    private static void addFiles(File f, String prefix, List<String> resourceList) {
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ModuleUtils.addFiles(file, prefix + file.getName() + "/", resourceList);
                continue;
            }
            resourceList.add(prefix + file.getName());
        }
    }

    private static List<String> resolveModuleEntriesFromJar(URL url, String _prefix) throws IOException {
        String prefix = _prefix.endsWith("/") ? _prefix : _prefix + "/";
        ArrayList<String> resourceList = new ArrayList<String>();
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        Enumeration<JarEntry> entries = conn.getJarFile().entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(prefix) || entry.isDirectory()) continue;
            resourceList.add(name);
        }
        return resourceList;
    }
}

