/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.jpos.q2.install.ModuleUtils;

public class Install {
    private static final String DEFAULT_PREFIX = "META-INF/q2/installs/";

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("p", "prefix", true, String.format("prefix, defaults to '%s'", DEFAULT_PREFIX));
        options.addOption("q", "quiet", false, "do not show information about files being extracted");
        options.addOption("f", "force", false, "override existing files in output directory");
        options.addOption("o", "outputDir", true, "output directory, defaults to " + new File(".").getAbsolutePath());
        options.addOption("h", "help", false, "Usage information");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("install", options);
            return;
        }
        String prefix = line.hasOption("p") ? line.getOptionValue("prefix") : DEFAULT_PREFIX;
        String outputBasePath = line.hasOption("o") ? line.getOptionValue("o") : ".";
        new Install().install(line.hasOption("f"), new File(outputBasePath), !line.hasOption("q"), prefix);
    }

    public void install(boolean allowOverride, File outputBasePath, boolean verbose, String prefix) throws IOException {
        if (!outputBasePath.exists()) {
            outputBasePath.mkdirs();
        }
        List<String> moduleConfigs = ModuleUtils.getModuleEntries(prefix);
        for (String resource : moduleConfigs) {
            String path;
            File outputFile;
            File dir;
            String dirPrefix;
            String s = resource.substring(prefix.length());
            int end = s.lastIndexOf("/");
            String string = dirPrefix = end < 0 ? null : s.substring(0, end);
            if (dirPrefix != null && !(dir = new File(outputBasePath, dirPrefix)).exists()) {
                if (verbose) {
                    System.out.println("Created " + dir.getAbsolutePath());
                }
                dir.mkdirs();
            }
            if ((outputFile = new File(outputBasePath, path = s.replaceAll("/", "\\" + File.separator))).exists() && !allowOverride) {
                if (!verbose) continue;
                System.out.printf("%s exists, use --force to override%n", outputFile);
                continue;
            }
            this.copyResourceToFile(resource, outputFile, verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToFile(String resource, File destination, boolean verbose) throws IOException {
        InputStream source = null;
        try {
            source = this.getClass().getClassLoader().getResourceAsStream(resource);
            FileOutputStream output = new FileOutputStream(destination);
            if (verbose) {
                System.out.println("extracting " + destination);
            }
            try {
                int n;
                byte[] buffer = new byte[4096];
                while (-1 != (n = source.read(buffer))) {
                    output.write(buffer, 0, n);
                }
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException ignored) {}
            }
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException ignored) {}
        }
    }
}

