/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.cli;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.jpos.q2.CLICommand;
import org.jpos.q2.CLIContext;
import org.jpos.transaction.TransactionManager;
import org.jpos.transaction.TransactionStatusEvent;
import org.jpos.transaction.TransactionStatusListener;
import org.jpos.util.NameRegistrar;

public class TMMON
implements CLICommand,
TransactionStatusListener {
    PrintStream p;
    CLIContext cli;
    boolean ansi;

    @Override
    public void exec(CLIContext cli, String[] args) throws Exception {
        Object obj;
        int i;
        this.p = cli.getOutputStream();
        this.cli = cli;
        this.ansi = cli.getConsoleReader().getTerminal().isANSISupported();
        if (args.length == 1) {
            this.usage(cli);
            return;
        }
        for (i = 1; i < args.length; ++i) {
            try {
                obj = NameRegistrar.get(args[i]);
                if (obj instanceof TransactionManager) {
                    ((TransactionManager)obj).addListener(this);
                    continue;
                }
                cli.println("Object '" + args[i] + "' is not an instance of TransactionManager (" + obj.toString() + ")");
                continue;
            }
            catch (NameRegistrar.NotFoundException e) {
                cli.println("TransactionManager '" + args[i] + "' not found -- ignored.");
            }
        }
        cli.getConsoleReader().readCharacter(new char[]{'q', 'Q'});
        for (i = 1; i < args.length; ++i) {
            try {
                obj = NameRegistrar.get(args[i]);
                if (!(obj instanceof TransactionManager)) continue;
                ((TransactionManager)obj).removeListener(this);
                continue;
            }
            catch (NameRegistrar.NotFoundException ignored) {
                // empty catch block
            }
        }
    }

    public void usage(CLIContext cli) {
        cli.println("Usage: tmmon [tm-name] [tm-name] ...");
        this.showTMs(cli);
    }

    private void showTMs(CLIContext cli) {
        NameRegistrar nr = NameRegistrar.getInstance();
        boolean maxw = false;
        Iterator iter = NameRegistrar.getMap().entrySet().iterator();
        StringBuilder sb = new StringBuilder("available transaction managers:");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            if (!(entry.getValue() instanceof TransactionManager)) continue;
            sb.append(' ');
            sb.append(key);
        }
        cli.println(sb.toString());
    }

    @Override
    public void update(TransactionStatusEvent e) {
        this.cli.println(e.toString());
    }
}

