/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.cli;

import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import jline.ANSIBuffer;
import org.jpos.q2.CLICommand;
import org.jpos.q2.CLIContext;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;

public class TAIL
implements CLICommand,
LogListener {
    PrintStream p;
    CLIContext cli;
    boolean ansi;

    @Override
    public void exec(CLIContext cli, String[] args) throws Exception {
        Logger logger;
        int i;
        this.p = cli.getOutputStream();
        this.cli = cli;
        this.ansi = cli.getConsoleReader().getTerminal().isANSISupported();
        if (args.length == 1) {
            this.usage(cli);
            return;
        }
        for (i = 1; i < args.length; ++i) {
            try {
                logger = (Logger)NameRegistrar.get("logger." + args[i]);
                logger.addListener(this);
                continue;
            }
            catch (NameRegistrar.NotFoundException e) {
                cli.println("Logger " + args[i] + " not found -- ignored.");
            }
        }
        cli.getConsoleReader().readCharacter(new char[]{'q', 'Q'});
        for (i = 1; i < args.length; ++i) {
            try {
                logger = (Logger)NameRegistrar.get("logger." + args[i]);
                logger.removeListener(this);
                continue;
            }
            catch (NameRegistrar.NotFoundException e) {
                // empty catch block
            }
        }
    }

    public void usage(CLIContext cli) {
        cli.println("Usage: tail [log-name] [log-name] ...");
        this.showLoggers(cli);
    }

    @Override
    public synchronized LogEvent log(LogEvent ev) {
        if (this.p != null) {
            Date d = new Date(System.currentTimeMillis());
            ANSIBuffer ab = new ANSIBuffer();
            ab.setAnsiEnabled(this.ansi);
            this.cli.println(ab.bold(ev.getSource().getLogger().getName() + ": " + ev.getRealm() + " " + d.toString() + "." + d.getTime() % 1000L).toString(this.ansi));
            ev.dump(this.p, " ");
            this.p.flush();
        }
        return ev;
    }

    private void showLoggers(CLIContext cli) {
        NameRegistrar nr = NameRegistrar.getInstance();
        boolean maxw = false;
        Iterator iter = nr.getMap().entrySet().iterator();
        StringBuilder sb = new StringBuilder("available loggers:");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("logger.") || !(entry.getValue() instanceof Logger)) continue;
            sb.append(' ');
            sb.append(key.substring(7));
        }
        cli.println(sb.toString());
    }
}

