/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2.cli;

import java.util.Iterator;
import java.util.Map;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.CLICommand;
import org.jpos.q2.CLIContext;
import org.jpos.util.Loggeable;
import org.jpos.util.NameRegistrar;

public class SHOWNR
implements CLICommand {
    @Override
    public void exec(CLIContext cli, String[] args) throws Exception {
        boolean all = args.length > 1 && "-a".equals(args[1]);
        int i = 1;
        if (all) {
            ++i;
        }
        if (args.length > i) {
            this.showOne(cli, args[i], all);
        } else {
            this.showAll(cli, all);
        }
    }

    private void showOne(CLIContext cli, String name, boolean detail) {
        try {
            Object obj = NameRegistrar.get(name);
            cli.println(name + " : " + obj.toString());
            if (detail && obj instanceof Loggeable) {
                ((Loggeable)obj).dump(cli.getOutputStream(), "   ");
                cli.getOutputStream().flush();
            }
        }
        catch (NameRegistrar.NotFoundException e) {
            cli.println("Object not found in NameRegistrar");
        }
    }

    private void showAll(CLIContext cli, boolean detail) {
        NameRegistrar nr = NameRegistrar.getInstance();
        int maxw = 0;
        for (Map.Entry entry : nr.getMap().entrySet()) {
            maxw = Math.max(maxw, entry.getKey().toString().length());
        }
        Iterator iter = nr.getMap().entrySet().iterator();
        ++maxw;
        while (iter.hasNext()) {
            Map.Entry entry;
            entry = iter.next();
            cli.println(ISOUtil.strpad(entry.getKey().toString(), maxw) + entry.getValue().toString());
            if (!detail || !(entry.getValue() instanceof Loggeable)) continue;
            ((Loggeable)entry.getValue()).dump(cli.getOutputStream(), "   ");
            cli.getOutputStream().flush();
        }
    }
}

