/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.jdom.Element;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.core.SimpleConfiguration;
import org.jpos.q2.ConfigurationFactory;

public class SimpleConfigurationFactory
implements ConfigurationFactory {
    @Override
    public Configuration getConfiguration(Element e) throws ConfigurationException {
        Properties props = new Properties();
        for (Element property : e.getChildren("property")) {
            String name = property.getAttributeValue("name");
            String value = property.getAttributeValue("value");
            String file = property.getAttributeValue("file");
            if (file != null) {
                try {
                    props.load(new FileInputStream(new File(file)));
                    continue;
                }
                catch (Exception ex) {
                    throw new ConfigurationException(file, ex);
                }
            }
            if (name == null || value == null) continue;
            Object obj = props.get(name);
            if (obj instanceof String[]) {
                String[] mobj = (String[])obj;
                String[] m = new String[mobj.length + 1];
                System.arraycopy(mobj, 0, m, 0, mobj.length);
                m[mobj.length] = value;
                props.put(name, m);
                continue;
            }
            if (obj instanceof String) {
                String[] m = new String[]{(String)obj, value};
                props.put(name, m);
                continue;
            }
            props.put(name, value);
        }
        return new SimpleConfiguration(props);
    }
}

