/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jdom.Element;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.core.XmlConfigurable;
import org.jpos.q2.ConfigurationFactory;
import org.jpos.q2.Q2;
import org.jpos.q2.QBean;
import org.jpos.q2.QClassLoader;
import org.jpos.q2.SimpleConfigurationFactory;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;

public class QFactory {
    ObjectName loaderName;
    Q2 q2;
    ResourceBundle classMapping;
    ConfigurationFactory defaultConfigurationFactory = new SimpleConfigurationFactory();

    public QFactory(ObjectName loaderName, Q2 q2) {
        this.loaderName = loaderName;
        this.q2 = q2;
        try {
            this.classMapping = ResourceBundle.getBundle(this.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public Object instantiate(Q2 server, Element e) throws ReflectionException, MBeanException, InstanceNotFoundException {
        String clazz = e.getAttributeValue("class");
        if (clazz == null) {
            try {
                clazz = this.classMapping.getString(e.getName());
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        MBeanServer mserver = server.getMBeanServer();
        this.getExtraPath(server.getLoader(), e);
        return mserver.instantiate(clazz, this.loaderName);
    }

    public ObjectInstance createQBean(Q2 server, Element e, Object obj) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedObjectNameException, MalformedURLException, InstanceAlreadyExistsException, InstanceNotFoundException, MBeanException, NotCompliantMBeanException, InvalidAttributeValueException, ReflectionException, ConfigurationException {
        String name = e.getAttributeValue("name");
        if (name == null) {
            name = e.getName();
        }
        ObjectName objectName = new ObjectName("Q2:type=qbean,service=" + name);
        MBeanServer mserver = server.getMBeanServer();
        if (mserver.isRegistered(objectName)) {
            throw new InstanceAlreadyExistsException(name + " has already been deployed in another file.");
        }
        ObjectInstance instance = mserver.registerMBean(obj, objectName);
        try {
            String realm;
            this.setAttribute(mserver, objectName, "Name", name);
            String logger = e.getAttributeValue("logger");
            if (logger != null) {
                this.setAttribute(mserver, objectName, "Logger", logger);
            }
            if ((realm = e.getAttributeValue("realm")) != null) {
                this.setAttribute(mserver, objectName, "Realm", realm);
            }
            this.setAttribute(mserver, objectName, "Server", server);
            this.setAttribute(mserver, objectName, "Persist", e);
            this.configureQBean(mserver, objectName, e);
            this.setConfiguration(obj, e);
            if (obj instanceof QBean) {
                mserver.invoke(objectName, "init", null, null);
            }
        }
        catch (ConfigurationException ce) {
            mserver.unregisterMBean(objectName);
            ce.fillInStackTrace();
            throw ce;
        }
        return instance;
    }

    public Q2 getQ2() {
        return this.q2;
    }

    public void getExtraPath(QClassLoader loader, Element e) {
        Element classpathElement = e.getChild("classpath");
        if (classpathElement != null) {
            try {
                loader = loader.scan(true);
            }
            catch (Throwable t) {
                this.getQ2().getLog().error(t);
            }
            for (Element u : classpathElement.getChildren("url")) {
                try {
                    loader.addURL(u.getTextTrim());
                }
                catch (MalformedURLException ex) {
                    this.q2.getLog().warn(u.getTextTrim(), ex);
                }
            }
        }
    }

    public void setAttribute(MBeanServer server, ObjectName objectName, String attribute, Object value) throws InstanceNotFoundException, MBeanException, InvalidAttributeValueException, ReflectionException {
        try {
            server.setAttribute(objectName, new Attribute(attribute, value));
        }
        catch (AttributeNotFoundException ex) {
        }
        catch (InvalidAttributeValueException ex) {
            // empty catch block
        }
    }

    public void startQBean(Q2 server, ObjectName objectName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedObjectNameException, MalformedURLException, InstanceAlreadyExistsException, MBeanRegistrationException, InstanceNotFoundException, MBeanException, NotCompliantMBeanException, InvalidAttributeValueException, ReflectionException {
        MBeanServer mserver = server.getMBeanServer();
        mserver.invoke(objectName, "start", null, null);
    }

    public void destroyQBean(Q2 server, ObjectName objectName, Object obj) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedObjectNameException, MalformedURLException, InstanceAlreadyExistsException, MBeanRegistrationException, InstanceNotFoundException, MBeanException, NotCompliantMBeanException, InvalidAttributeValueException, ReflectionException {
        MBeanServer mserver = server.getMBeanServer();
        if (obj instanceof QBean) {
            mserver.invoke(objectName, "stop", null, null);
            mserver.invoke(objectName, "destroy", null, null);
        }
        if (objectName != null) {
            mserver.unregisterMBean(objectName);
        }
    }

    public void configureQBean(MBeanServer server, ObjectName objectName, Element e) throws ConfigurationException {
        try {
            AttributeList attributeList = this.getAttributeList(e);
            Iterator attributes = attributeList.iterator();
            while (attributes.hasNext()) {
                server.setAttribute(objectName, (Attribute)attributes.next());
            }
        }
        catch (Exception e1) {
            throw new ConfigurationException(e1);
        }
    }

    public AttributeList getAttributeList(Element e) throws ConfigurationException {
        AttributeList attributeList = new AttributeList();
        List childs = e.getChildren("attr");
        for (Element childElement : childs) {
            String name = childElement.getAttributeValue("name");
            name = this.getAttributeName(name);
            Attribute attr = new Attribute(name, this.getObject(childElement));
            attributeList.add(attr);
        }
        return attributeList;
    }

    protected Object getObject(Element childElement) throws ConfigurationException {
        String type = childElement.getAttributeValue("type", "java.lang.String");
        if ("int".equals(type)) {
            type = "java.lang.Integer";
        } else if ("long".equals(type)) {
            type = "java.lang.Long";
        } else if ("boolean".equals(type)) {
            type = "java.lang.Boolean";
        }
        String value = childElement.getText();
        try {
            Class<?> attributeType = Class.forName(type);
            if (Collection.class.isAssignableFrom(attributeType)) {
                return this.getCollection(attributeType, childElement);
            }
            Class[] parameterTypes = new Class[]{"".getClass()};
            Object[] parameterValues = new Object[]{value};
            return attributeType.getConstructor(parameterTypes).newInstance(parameterValues);
        }
        catch (Exception e1) {
            throw new ConfigurationException(e1);
        }
    }

    protected Collection getCollection(Class type, Element e) throws ConfigurationException {
        try {
            Collection col = (Collection)type.newInstance();
            Iterator childs = e.getChildren("item").iterator();
            while (childs.hasNext()) {
                col.add(this.getObject((Element)childs.next()));
            }
            return col;
        }
        catch (Exception e1) {
            throw new ConfigurationException(e1);
        }
    }

    public String getAttributeName(String name) {
        StringBuilder tmp = new StringBuilder(name);
        tmp.setCharAt(0, name.toUpperCase().charAt(0));
        return tmp.toString();
    }

    public Object newInstance(String clazz) throws ConfigurationException {
        try {
            MBeanServer mserver = this.q2.getMBeanServer();
            return mserver.instantiate(clazz, this.loaderName);
        }
        catch (Exception e) {
            throw new ConfigurationException(clazz, e);
        }
    }

    public Configuration getConfiguration(Element e) throws ConfigurationException {
        String configurationFactoryClazz = e.getAttributeValue("configuration-factory");
        ConfigurationFactory cf = configurationFactoryClazz != null ? (ConfigurationFactory)this.newInstance(configurationFactoryClazz) : this.defaultConfigurationFactory;
        return cf.getConfiguration(e);
    }

    public void setLogger(Object obj, Element e) {
        String loggerName;
        if (obj instanceof LogSource && (loggerName = e.getAttributeValue("logger")) != null) {
            String realm = e.getAttributeValue("realm");
            if (realm == null) {
                realm = e.getName();
            }
            Logger logger = Logger.getLogger(loggerName);
            ((LogSource)obj).setLogger(logger, realm);
        }
    }

    public void setConfiguration(Object obj, Element e) throws ConfigurationException {
        try {
            if (obj instanceof Configurable) {
                ((Configurable)obj).setConfiguration(this.getConfiguration(e));
            }
            if (obj instanceof XmlConfigurable) {
                ((XmlConfigurable)obj).setConfiguration(e);
            }
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public static void invoke(Object obj, String m, Object p) throws ConfigurationException {
        QFactory.invoke(obj, m, p, p != null ? p.getClass() : null);
    }

    public static void invoke(Object obj, String m, Object p, Class pc) throws ConfigurationException {
        try {
            if (p != null) {
                Class[] paramTemplate = new Class[]{pc};
                Method method = obj.getClass().getMethod(m, paramTemplate);
                Object[] param = new Object[]{p};
                method.invoke(obj, param);
            } else {
                Method method = obj.getClass().getMethod(m, new Class[0]);
                method.invoke(obj, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (NullPointerException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(obj.getClass().getName() + "." + m + "(" + p.toString() + ")", e.getTargetException());
        }
    }
}

