/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jpos.q2.QClassLoaderMBean;

public class QClassLoader
extends URLClassLoader
implements QClassLoaderMBean,
FileFilter {
    File libDir;
    ObjectName loaderName;
    MBeanServer server;
    long lastModified;

    public QClassLoader(MBeanServer server, File libDir, ObjectName loaderName, ClassLoader mainClassLoader) {
        super(new URL[0], mainClassLoader);
        this.loaderName = loaderName;
        this.libDir = libDir;
        this.server = server;
    }

    @Override
    public void addURL(String url) throws MalformedURLException {
        this.addURL(new URL(url));
    }

    @Override
    public boolean accept(File f) {
        return f.getName().endsWith(".jar");
    }

    public boolean isModified() {
        return this.libDir.canRead() && this.lastModified != this.libDir.lastModified();
    }

    public QClassLoader scan(boolean forceNewClassLoader) throws InstanceAlreadyExistsException, InstanceNotFoundException, NotCompliantMBeanException, MalformedURLException, MBeanRegistrationException {
        File[] file;
        QClassLoader loader;
        if (!this.isModified() && !forceNewClassLoader || !this.libDir.canRead()) {
            return this;
        }
        if (this.server.isRegistered(this.loaderName)) {
            this.server.unregisterMBean(this.loaderName);
            loader = new QClassLoader(this.server, this.libDir, this.loaderName, this.getParent());
        } else {
            loader = this;
        }
        for (File aFile : file = this.libDir.listFiles(this)) {
            try {
                loader.addURL(aFile.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        loader.lastModified = this.libDir.lastModified();
        this.server.registerMBean(loader, this.loaderName);
        return loader;
    }

    public void forceNewClassLoaderOnNextScan() {
        this.lastModified = 0L;
    }
}

