/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.jdom.Content;
import org.jdom.Element;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.q2.Q2;
import org.jpos.q2.QBean;
import org.jpos.q2.QBeanSupportMBean;
import org.jpos.q2.QClassLoader;
import org.jpos.q2.QFactory;
import org.jpos.q2.QPersist;
import org.jpos.util.ConcurrentUtil;
import org.jpos.util.Log;

public class QBeanSupport
implements QBean,
QPersist,
QBeanSupportMBean,
Configurable {
    Element persist;
    int state;
    Q2 server;
    boolean modified;
    String name;
    protected Log log;
    protected Configuration cfg;
    protected ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    public QBeanSupport() {
        this.setLogger("Q2");
        this.state = -1;
    }

    @Override
    public void setServer(Q2 server) {
        this.server = server;
    }

    @Override
    public Q2 getServer() {
        return this.server;
    }

    public QFactory getFactory() {
        return this.getServer().getFactory();
    }

    @Override
    public void setName(String name) {
        if (this.name == null) {
            this.name = name;
        }
        if (this.log != null) {
            this.log.setRealm(name);
        }
        this.setModified(true);
    }

    @Override
    public void setLogger(String loggerName) {
        this.log = Log.getLog(loggerName, this.getClass().getName());
        this.setModified(true);
    }

    @Override
    public void setRealm(String realm) {
        if (this.log != null) {
            this.log.setRealm(realm);
        }
    }

    @Override
    public String getRealm() {
        return this.log != null ? this.log.getRealm() : null;
    }

    @Override
    public String getLogger() {
        return this.log != null ? this.log.getLogger().getName() : null;
    }

    public Log getLog() {
        return this.log;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init() {
        if (this.state == -1) {
            this.setModified(false);
            try {
                this.initService();
                this.state = 0;
            }
            catch (Throwable t) {
                this.log.warn("init", t);
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.state != 5 && this.state != 0 && this.state != 4) {
            return;
        }
        this.state = 2;
        try {
            this.startService();
        }
        catch (Throwable t) {
            this.state = 4;
            this.log.warn("start", t);
            return;
        }
        this.state = 3;
    }

    @Override
    public synchronized void stop() {
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        try {
            this.stopService();
        }
        catch (Throwable t) {
            this.state = 4;
            this.log.warn("stop", t);
            return;
        }
        this.state = 0;
    }

    @Override
    public void destroy() {
        if (this.state == 5) {
            return;
        }
        if (this.state != 0) {
            this.stop();
        }
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            this.scheduledThreadPoolExecutor = null;
        }
        try {
            this.destroyService();
        }
        catch (Throwable t) {
            this.log.warn("destroy", t);
        }
        this.state = 5;
    }

    @Override
    public void shutdownQ2() {
        this.getServer().shutdown();
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public URL[] getLoaderURLS() {
        return this.server.getLoader().getURLs();
    }

    @Override
    public QClassLoader getLoader() {
        return this.server.getLoader();
    }

    @Override
    public String getStateAsString() {
        return this.state >= 0 ? stateString[this.state] : "Unknown";
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public void setPersist(Element persist) {
        this.persist = persist;
    }

    @Override
    public synchronized Element getPersist() {
        this.setModified(false);
        return this.persist;
    }

    public synchronized void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public synchronized boolean isModified() {
        return this.modified;
    }

    public boolean running() {
        return this.state == 2 || this.state == 3;
    }

    protected void initService() throws Exception {
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
    }

    protected synchronized ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ConcurrentUtil.newScheduledThreadPoolExecutor();
        }
        return this.scheduledThreadPoolExecutor;
    }

    protected Element createElement(String name, Class mbeanClass) {
        String loggerName;
        Element classPath;
        Element e = new Element(name);
        Element element = classPath = this.persist != null ? this.persist.getChild("classpath") : null;
        if (classPath != null) {
            e.addContent((Content)classPath);
        }
        e.setAttribute("class", this.getClass().getName());
        if (!e.getName().equals(this.getName())) {
            e.setAttribute("name", this.getName());
        }
        if ((loggerName = this.getLogger()) != null) {
            e.setAttribute("logger", loggerName);
        }
        try {
            PropertyDescriptor[] desc;
            BeanInfo info = Introspector.getBeanInfo(mbeanClass);
            for (PropertyDescriptor aDesc : desc = info.getPropertyDescriptors()) {
                if (aDesc.getWriteMethod() == null) continue;
                Method read = aDesc.getReadMethod();
                Object obj = read.invoke((Object)this, new Object[0]);
                String type = read.getReturnType().getName();
                if ("java.lang.String".equals(type)) {
                    type = null;
                }
                this.addAttr(e, aDesc.getName(), obj, type);
            }
        }
        catch (Exception ex) {
            this.log.warn("get-persist", ex);
        }
        return e;
    }

    protected void addAttr(Element e, String name, Object obj, String type) {
        String value = obj == null ? "null" : obj.toString();
        Element attr = new Element("attr");
        attr.setAttribute("name", name);
        if (type != null) {
            attr.setAttribute("type", type);
        }
        attr.setText(value);
        e.addContent((Content)attr);
    }

    protected Iterator getAttrs() {
        return this.getPersist().getChildren("attr").iterator();
    }

    protected Iterator getAttrs(String parent) {
        return this.getPersist().getChild(parent).getChildren("attr").iterator();
    }

    protected void setAttr(Iterator attrs, String name, Object obj) {
        String value;
        String string = value = obj == null ? "null" : obj.toString();
        while (attrs.hasNext()) {
            Element e = (Element)attrs.next();
            if (!name.equals(e.getAttributeValue("name"))) continue;
            e.setText(value);
            break;
        }
    }

    protected Iterator getProperties(String parent) {
        return this.getPersist().getChild(parent).getChildren("property").iterator();
    }

    protected void setProperty(Iterator props, String name, String value) {
        while (props.hasNext()) {
            Element e = (Element)props.next();
            if (!name.equals(e.getAttributeValue("name"))) continue;
            e.setAttribute("value", value);
            break;
        }
    }

    protected String getProperty(Iterator props, String name) {
        while (props.hasNext()) {
            Element e = (Element)props.next();
            if (!name.equals(e.getAttributeValue("name"))) continue;
            return e.getAttributeValue("value");
        }
        return null;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }
}

