/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.CLI;
import org.jpos.q2.ConfigDecorationProvider;
import org.jpos.q2.QBean;
import org.jpos.q2.QClassLoader;
import org.jpos.q2.QFactory;
import org.jpos.q2.QPersist;
import org.jpos.util.Log;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.jpos.util.SimpleLogListener;

public class Q2
implements FileFilter,
Runnable {
    public static final String DEFAULT_DEPLOY_DIR = "deploy";
    public static final String JMX_NAME = "Q2";
    public static final String LOGGER_NAME = "Q2";
    public static final String REALM = "Q2.system";
    public static final String LOGGER_CONFIG = "00_logger.xml";
    public static final String QBEAN_NAME = "Q2:type=qbean,service=";
    public static final String Q2_CLASS_LOADER = "Q2:type=system,service=loader";
    public static final String DUPLICATE_EXTENSION = "DUP";
    public static final String ERROR_EXTENSION = "BAD";
    public static final String ENV_EXTENSION = "ENV";
    public static final String LICENSEE = "/LICENSEE.asc";
    public static final String PROTECTED_QBEAN = "protected-qbean";
    public static final int SCAN_INTERVAL = 2500;
    public static final long SHUTDOWN_TIMEOUT = 60000L;
    private MBeanServer server;
    private File deployDir;
    private File libDir;
    private Map dirMap;
    private QFactory factory;
    private QClassLoader loader;
    private ClassLoader mainClassLoader;
    private Log log;
    private volatile boolean started;
    private volatile boolean shutdown;
    private volatile boolean shuttingDown;
    private Thread q2Thread;
    private String[] args;
    private boolean hasSystemLogger;
    private boolean exit;
    private long startTime;
    private CLI cli;
    private boolean recursive;
    private ConfigDecorationProvider decorator = null;
    private UUID instanceId;

    public Q2(String[] args) {
        this.args = args;
        this.startTime = System.currentTimeMillis();
        this.instanceId = UUID.randomUUID();
        this.parseCmdLine(args);
        this.libDir = new File(this.deployDir, "lib");
        this.dirMap = new TreeMap();
        this.deployDir.mkdirs();
        this.mainClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public Q2() {
        this(new String[0]);
    }

    public Q2(String deployDir) {
        this(new String[]{"-d", deployDir});
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.shutdown(true);
    }

    @Override
    public void run() {
        this.started = true;
        Thread.currentThread().setName("Q2-" + this.getInstanceId().toString());
        try {
            ArrayList<MBeanServer> mbeanServerList = MBeanServerFactory.findMBeanServer(null);
            this.server = mbeanServerList.isEmpty() ? MBeanServerFactory.createMBeanServer("Q2") : mbeanServerList.get(0);
            final ObjectName loaderName = new ObjectName(Q2_CLASS_LOADER);
            try {
                this.loader = (QClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new QClassLoader(Q2.this.server, Q2.this.libDir, loaderName, Q2.this.mainClassLoader);
                    }
                });
                this.server.registerMBean(this.loader, loaderName);
                this.loader = this.loader.scan(false);
            }
            catch (Throwable t) {
                if (this.log != null) {
                    this.log.error("initial-scan", t);
                }
                t.printStackTrace();
            }
            this.factory = new QFactory(loaderName, this);
            this.initSystemLogger();
            this.addShutdownHook();
            this.q2Thread = Thread.currentThread();
            this.q2Thread.setContextClassLoader(this.loader);
            if (this.cli != null) {
                this.cli.start();
            }
            this.initConfigDecorator();
            int i = 1;
            while (!this.shutdown) {
                try {
                    boolean forceNewClassLoader = this.scan();
                    QClassLoader oldClassLoader = this.loader;
                    this.loader = this.loader.scan(forceNewClassLoader);
                    if (this.loader != oldClassLoader) {
                        oldClassLoader = null;
                        System.gc();
                        this.log.info("new classloader [" + Integer.toString(this.loader.hashCode(), 16) + "] has been created");
                    }
                    this.deploy();
                    this.checkModified();
                    this.relax(2500L);
                    if (i % 1440 == 0) {
                        this.logVersion();
                    }
                }
                catch (Throwable t) {
                    this.log.error("start", t);
                    this.relax();
                }
                ++i;
            }
            this.undeploy();
            try {
                this.server.unregisterMBean(loaderName);
            }
            catch (InstanceNotFoundException e) {
                this.log.error(e);
            }
            if (this.decorator != null) {
                this.decorator.uninitialize();
            }
            if (this.exit && !this.shuttingDown) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error(e);
            } else {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public boolean running() {
        return this.started && !this.shutdown;
    }

    public void shutdown(boolean join) {
        this.shutdown = true;
        if (this.q2Thread != null) {
            this.log.info("shutting down");
            this.q2Thread.interrupt();
            if (join) {
                try {
                    this.q2Thread.join();
                    this.log.info("shutdown done");
                }
                catch (InterruptedException e) {
                    this.log.warn(e);
                }
            }
        }
        this.q2Thread = null;
    }

    public QClassLoader getLoader() {
        return this.loader;
    }

    public QFactory getFactory() {
        return this.factory;
    }

    public String[] getCommandLineArgs() {
        return this.args;
    }

    @Override
    public boolean accept(File f) {
        return f.canRead() && (f.getName().endsWith(".xml") || this.recursive && f.isDirectory() && !"lib".equalsIgnoreCase(f.getName()));
    }

    public File getDeployDir() {
        return this.deployDir;
    }

    private boolean scan() {
        boolean rc = false;
        File[] file = this.deployDir.listFiles(this);
        if (file == null) {
            throw new Error("Deploy directory \"" + this.deployDir.getAbsolutePath() + "\" is not available");
        }
        for (File f : file) {
            if (!this.register(f)) continue;
            rc = true;
        }
        return rc;
    }

    private void deploy() {
        ArrayList<ObjectInstance> startList = new ArrayList<ObjectInstance>();
        Iterator iter = this.dirMap.entrySet().iterator();
        try {
            while (iter.hasNext() && !this.shutdown) {
                Map.Entry entry = iter.next();
                File f = (File)entry.getKey();
                QEntry qentry = (QEntry)entry.getValue();
                long deployed = qentry.getDeployed();
                if (deployed == 0L) {
                    if (this.deploy(f)) {
                        if (qentry.isQBean()) {
                            startList.add(qentry.getInstance());
                        }
                        qentry.setDeployed(f.lastModified());
                        continue;
                    }
                    iter.remove();
                    continue;
                }
                if (deployed == f.lastModified()) continue;
                this.undeploy(f);
                iter.remove();
                this.loader.forceNewClassLoaderOnNextScan();
            }
            iter = startList.iterator();
            while (iter.hasNext()) {
                this.start((ObjectInstance)((Object)iter.next()));
            }
        }
        catch (Exception e) {
            this.log.error(DEFAULT_DEPLOY_DIR, e);
        }
    }

    private void undeploy() {
        Object[] set = this.dirMap.entrySet().toArray();
        int l = set.length;
        while (l-- > 0) {
            Map.Entry entry = (Map.Entry)set[l];
            File f = (File)entry.getKey();
            this.undeploy(f);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("Q2-ShutdownHook"){

            @Override
            public void run() {
                Q2.this.shuttingDown = true;
                Q2.this.shutdown = true;
                if (Q2.this.q2Thread != null) {
                    Q2.this.log.info("shutting down (hook)");
                    try {
                        Q2.this.q2Thread.join(60000L);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void checkModified() {
        for (Map.Entry entry : this.dirMap.entrySet()) {
            ObjectName name;
            File f = (File)entry.getKey();
            QEntry qentry = (QEntry)entry.getValue();
            if (!qentry.isQBean() || !qentry.isQPersist() || this.getState(name = qentry.getObjectName()) != 3 || !this.isModified(name)) continue;
            qentry.setDeployed(this.persist(f, name));
        }
    }

    private int getState(ObjectName name) {
        int status = -1;
        if (name != null) {
            try {
                status = (Integer)this.server.getAttribute(name, "State");
            }
            catch (Exception e) {
                this.log.warn("getState", e);
            }
        }
        return status;
    }

    private boolean isModified(ObjectName name) {
        boolean modified = false;
        if (name != null) {
            try {
                modified = (Boolean)this.server.getAttribute(name, "Modified");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long persist(File f, ObjectName name) {
        long deployed;
        block5: {
            deployed = f.lastModified();
            try {
                Element e = (Element)this.server.getAttribute(name, "Persist");
                if (e == null) break block5;
                XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
                Document doc = new Document();
                e.detach();
                doc.setRootElement(e);
                File tmp = new File(f.getAbsolutePath() + ".tmp");
                BufferedWriter writer = new BufferedWriter(new FileWriter(tmp));
                try {
                    out.output(doc, (Writer)writer);
                }
                finally {
                    ((Writer)writer).close();
                }
                f.delete();
                tmp.renameTo(f);
                deployed = f.lastModified();
            }
            catch (Exception ex) {
                this.log.warn("persist", ex);
            }
        }
        return deployed;
    }

    private void undeploy(File f) {
        QEntry qentry = (QEntry)this.dirMap.get(f);
        try {
            if (this.log != null) {
                this.log.trace("undeploying:" + f.getCanonicalPath());
            }
            Object obj = qentry.getObject();
            ObjectName name = qentry.getObjectName();
            this.factory.destroyQBean(this, name, obj);
            if (this.log != null) {
                this.log.info("undeployed:" + f.getCanonicalPath());
            }
        }
        catch (Exception e) {
            this.getLog().warn("undeploy", e);
        }
    }

    private boolean register(File f) {
        boolean rc = false;
        if (f.isDirectory()) {
            File[] file;
            for (File aFile : file = f.listFiles(this)) {
                if (!this.register(aFile)) continue;
                rc = true;
            }
        } else if (this.dirMap.get(f) == null) {
            this.dirMap.put(f, new QEntry());
            rc = true;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deploy(File f) {
        LogEvent evt = this.log != null ? this.log.createInfo() : null;
        try {
            UUID uuid;
            QEntry qentry = (QEntry)this.dirMap.get(f);
            SAXBuilder builder = this.createSAXBuilder();
            Document doc = this.decorator != null && !f.getName().equals(LOGGER_CONFIG) ? this.decrypt(builder.build((Reader)new StringReader(this.decorator.decorateFile(f)))) : this.decrypt(builder.build(f));
            Element rootElement = doc.getRootElement();
            String iuuid = rootElement.getAttributeValue("instance");
            if (iuuid != null && !(uuid = UUID.fromString(iuuid)).equals(this.getInstanceId())) {
                this.deleteFile(f, iuuid);
                boolean bl = false;
                return bl;
            }
            String enabledAttribute = rootElement.getAttributeValue("enabled", "true");
            if ("true".equalsIgnoreCase(enabledAttribute) || "yes".equalsIgnoreCase(enabledAttribute)) {
                if (evt != null) {
                    evt.addMessage("deploy: " + f.getCanonicalPath());
                }
                Object obj = this.factory.instantiate(this, rootElement);
                qentry.setObject(obj);
                ObjectInstance instance = this.factory.createQBean(this, doc.getRootElement(), obj);
                qentry.setInstance(instance);
            } else if (evt != null) {
                evt.addMessage("deploy ignored (enabled='" + enabledAttribute + "'): " + f.getCanonicalPath());
            }
        }
        catch (InstanceAlreadyExistsException e) {
            this.tidyFileAway(f, DUPLICATE_EXTENSION);
            if (evt != null) {
                evt.addMessage(e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (evt != null) {
                evt.addMessage(e);
            }
            this.tidyFileAway(f, ERROR_EXTENSION);
            boolean bl = false;
            return bl;
        }
        catch (Error e) {
            if (evt != null) {
                evt.addMessage(e);
            }
            this.tidyFileAway(f, ENV_EXTENSION);
            boolean bl = false;
            return bl;
        }
        finally {
            if (evt != null) {
                Logger.log(evt);
            }
        }
        return true;
    }

    private void start(ObjectInstance instance) {
        try {
            this.factory.startQBean(this, instance.getObjectName());
        }
        catch (Exception e) {
            this.getLog().warn("start", e);
        }
    }

    public void relax(long sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void relax() {
        this.relax(1000L);
    }

    private void initSystemLogger() {
        File loggerConfig = new File(this.deployDir, LOGGER_CONFIG);
        if (loggerConfig.canRead()) {
            this.hasSystemLogger = true;
            try {
                this.register(loggerConfig);
                this.deploy();
            }
            catch (Exception e) {
                this.getLog().warn("init-system-logger", e);
            }
        }
        this.getLog().info("Q2 started, deployDir=" + this.deployDir.getAbsolutePath());
    }

    public Log getLog() {
        if (this.log == null) {
            Logger logger = Logger.getLogger("Q2");
            if (!this.hasSystemLogger && !logger.hasListeners()) {
                logger.addListener(new SimpleLogListener(System.out));
            }
            this.log = new Log(logger, REALM);
        }
        return this.log;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void displayVersion() {
        System.out.println(Q2.getVersionString());
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public static String getVersionString() {
        return String.format("jPOS %s %s/%s (%s)%s", Q2.getVersion(), Q2.getBranch(), Q2.getRevision(), Q2.getBuildTimestamp(), Q2.getLicensee());
    }

    public static String getLicensee() {
        InputStream is = Q2.class.getResourceAsStream(LICENSEE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (is != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            PrintStream p = new PrintStream(baos);
            p.println();
            p.println();
            try {
                while (br.ready()) {
                    p.println(br.readLine());
                }
            }
            catch (Exception e) {
                e.printStackTrace(p);
            }
        }
        return baos.toString();
    }

    private void parseCmdLine(String[] args) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("v", "version", false, "Q2's version");
        options.addOption("d", "deploydir", true, "Deployment directory");
        options.addOption("r", "recursive", false, "Deploy subdirectories recursively");
        options.addOption("h", "help", false, "Usage information");
        options.addOption("C", "config", true, "Configuration bundle");
        options.addOption("e", "encrypt", true, "Encrypt configuration bundle");
        options.addOption("i", "cli", false, "Command Line Interface");
        options.addOption("c", "command", true, "Command to execute");
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("v")) {
                this.displayVersion();
                System.exit(0);
            }
            if (line.hasOption("h")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("Q2", options);
                System.exit(0);
            }
            if (line.hasOption("c")) {
                this.cli = new CLI(this, line.getOptionValue("c"), line.hasOption("i"));
            } else if (line.hasOption("i")) {
                this.cli = new CLI(this, null, true);
            }
            String dir = DEFAULT_DEPLOY_DIR;
            if (line.hasOption("d")) {
                dir = line.getOptionValue("d");
            }
            this.recursive = line.hasOption("r");
            this.deployDir = new File(dir);
            if (line.hasOption("C")) {
                this.deployBundle(new File(line.getOptionValue("C")), false);
            }
            if (line.hasOption("e")) {
                this.deployBundle(new File(line.getOptionValue("e")), true);
            }
        }
        catch (MissingArgumentException e) {
            System.out.println("ERROR: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void deployBundle(File bundle, boolean encrypt) throws JDOMException, IOException, ISOException, GeneralSecurityException {
        SAXBuilder builder = this.createSAXBuilder();
        Document doc = builder.build(bundle);
        Iterator iter = doc.getRootElement().getChildren().iterator();
        int i = 1;
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            this.deployElement(e, String.format("%02d_%s.xml", i, e.getName()), encrypt, !encrypt);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployElement(Element e, String fileName, boolean encrypt, boolean isTransient) throws ISOException, IOException, GeneralSecurityException {
        e = (Element)e.clone();
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        Document doc = new Document();
        doc.setRootElement(e);
        File qbean = new File(this.deployDir, fileName);
        if (isTransient) {
            e.setAttribute("instance", this.getInstanceId().toString());
            qbean.deleteOnExit();
        }
        if (encrypt) {
            doc = this.encrypt(doc);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(qbean));
        try {
            out.output(doc, (Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private byte[] dodes(byte[] data, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(mode, new SecretKeySpec(this.getKey(), "DES"));
        return cipher.doFinal(data);
    }

    protected byte[] getKey() {
        return "CAFEBABE".getBytes();
    }

    protected Document encrypt(Document doc) throws GeneralSecurityException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(os);
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        out.output(doc, (Writer)writer);
        writer.close();
        byte[] crypt = this.dodes(os.toByteArray(), 1);
        Document secureDoc = new Document();
        Element root = new Element(PROTECTED_QBEAN);
        secureDoc.setRootElement(root);
        Element secureData = new Element("data");
        root.addContent((Content)secureData);
        secureData.setText(ISOUtil.hexString(crypt));
        return secureDoc;
    }

    protected Document decrypt(Document doc) throws GeneralSecurityException, IOException, JDOMException {
        Element data;
        Element root = doc.getRootElement();
        if (PROTECTED_QBEAN.equals(root.getName()) && (data = root.getChild("data")) != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.dodes(ISOUtil.hex2byte(data.getTextTrim()), 2));
            SAXBuilder builder = this.createSAXBuilder();
            doc = builder.build((InputStream)is);
        }
        return doc;
    }

    private void tidyFileAway(File f, String extension) {
        File rename = new File(f.getAbsolutePath() + "." + extension);
        while (rename.exists()) {
            rename = new File(rename.getAbsolutePath() + "." + extension);
        }
        this.getLog().warn("Tidying " + f.getAbsolutePath() + " out of the way, by adding ." + extension, "It will be called: " + rename.getAbsolutePath() + " see log above for detail of problem.");
        f.renameTo(rename);
    }

    private void deleteFile(File f, String iuuid) {
        f.delete();
        this.getLog().info(String.format("Deleted transient descriptor %s (%s)", f.getAbsolutePath(), iuuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigDecorator() {
        InputStream in = Q2.class.getClassLoader().getResourceAsStream("META-INF/org/jpos/config/Q2-decorator.properties");
        try {
            if (in != null) {
                PropertyResourceBundle bundle = new PropertyResourceBundle(in);
                String ccdClass = bundle.getString("config-decorator-class");
                if (this.log != null) {
                    this.log.info("Initializing config decoration provider: " + ccdClass);
                }
                this.decorator = (ConfigDecorationProvider)Q2.class.getClassLoader().loadClass(ccdClass).newInstance();
                this.decorator.initialize(this.getDeployDir());
            }
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error(e);
            } else {
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void logVersion() {
        LogEvent evt = this.getLog().createLogEvent("version");
        evt.addMessage(Q2.getVersionString());
        Logger.log(evt);
    }

    private void setExit(boolean exit) {
        this.exit = exit;
    }

    private SAXBuilder createSAXBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://xml.org/sax/features/namespaces", true);
        builder.setFeature("http://apache.org/xml/features/xinclude", true);
        return builder;
    }

    public static void main(String[] args) throws Exception {
        Q2 q2 = new Q2(args);
        q2.setExit(true);
        q2.start();
    }

    public static String getVersion() {
        return ResourceBundle.getBundle("org/jpos/q2/buildinfo").getString("version");
    }

    public static String getRevision() {
        return ResourceBundle.getBundle("org/jpos/q2/revision").getString("revision");
    }

    public static String getBranch() {
        return ResourceBundle.getBundle("org/jpos/q2/revision").getString("branch");
    }

    public static String getBuildTimestamp() {
        return ResourceBundle.getBundle("org/jpos/q2/buildinfo").getString("buildTimestamp");
    }

    public static String getRelease() {
        return Q2.getVersion() + " " + Q2.getRevision();
    }

    public static class QEntry {
        long deployed;
        ObjectInstance instance;
        Object obj;

        public QEntry() {
        }

        public QEntry(long deployed, ObjectInstance instance) {
            this.deployed = deployed;
            this.instance = instance;
        }

        public long getDeployed() {
            return this.deployed;
        }

        public void setDeployed(long deployed) {
            this.deployed = deployed;
        }

        public void setInstance(ObjectInstance instance) {
            this.instance = instance;
        }

        public ObjectInstance getInstance() {
            return this.instance;
        }

        public ObjectName getObjectName() {
            return this.instance != null ? this.instance.getObjectName() : null;
        }

        public void setObject(Object obj) {
            this.obj = obj;
        }

        public Object getObject() {
            return this.obj;
        }

        public boolean isQBean() {
            return this.obj instanceof QBean;
        }

        public boolean isQPersist() {
            return this.obj instanceof QPersist;
        }
    }
}

