/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import jline.SimpleCompletor;

public class CLIPrefixedClassNameCompletor
extends SimpleCompletor {
    public CLIPrefixedClassNameCompletor(Collection<String> prefixes) throws IOException {
        super(CLIPrefixedClassNameCompletor.getClassNames(prefixes), (SimpleCompletor.SimpleCompletorFilter)new CmdFilter(prefixes));
        this.setDelimiter(".");
    }

    private static String[] getClassNames(Collection<String> prefixes) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        for (String prefix : prefixes) {
            classes.addAll(CLIPrefixedClassNameCompletor.getClassEntries(prefix));
        }
        TreeSet<String> classNames = new TreeSet<String>();
        for (String name : classes) {
            if (!name.endsWith(".class")) continue;
            classNames.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static List<String> getClassEntries(String prefix) throws IOException {
        String p = prefix.replaceAll("\\.", "\\/");
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<URL> urls = CLIPrefixedClassNameCompletor.class.getClassLoader().getResources(p);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) {
                return Collections.emptyList();
            }
            try {
                List<String> lst = url.getProtocol().equals("jar") ? CLIPrefixedClassNameCompletor.resolveModuleEntriesFromJar(url, p) : CLIPrefixedClassNameCompletor.resolveModuleEntriesFromFiles(url, p);
                result.addAll(lst);
            }
            catch (URISyntaxException e) {
                throw new IOException("Bad URL", e);
            }
        }
        return result;
    }

    private static List<String> resolveModuleEntriesFromFiles(URL url, String _prefix) throws IOException, URISyntaxException {
        String prefix = _prefix.endsWith("/") ? _prefix : _prefix + "/";
        ArrayList<String> resourceList = new ArrayList<String>();
        URI uri = url.toURI();
        File f = new File(uri);
        CLIPrefixedClassNameCompletor.addFiles(f, prefix, resourceList);
        return resourceList;
    }

    private static void addFiles(File f, String prefix, List<String> resourceList) {
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                CLIPrefixedClassNameCompletor.addFiles(file, prefix + file.getName() + "/", resourceList);
                continue;
            }
            resourceList.add(prefix + file.getName());
        }
    }

    private static List<String> resolveModuleEntriesFromJar(URL url, String _prefix) throws IOException {
        String prefix = _prefix.endsWith("/") ? _prefix : _prefix + "/";
        ArrayList<String> resourceList = new ArrayList<String>();
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        Enumeration<JarEntry> entries = conn.getJarFile().entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(prefix) || entry.isDirectory()) continue;
            resourceList.add(name);
        }
        return resourceList;
    }

    public static class CmdFilter
    implements SimpleCompletor.SimpleCompletorFilter {
        Collection<String> prefixes;

        public CmdFilter(Collection<String> prefixes) {
            this.prefixes = prefixes;
        }

        public String filter(String element) {
            for (String prefix : this.prefixes) {
                String p = prefix;
                if (!element.startsWith(p)) continue;
                return element.substring(p.length()).toLowerCase();
            }
            return null;
        }
    }
}

