/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.ConsoleReader;
import org.jpos.iso.ISOUtil;
import org.jpos.q2.CLI;
import org.jpos.q2.CLICommand;
import org.jpos.q2.CLIContext;
import org.jpos.q2.Q2;

public class CLICommandInterface {
    CLIContext ctx;
    List<String> prefixes = new ArrayList<String>();

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public CLICommandInterface(CLIContext ctx) {
        this.ctx = ctx;
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public void execCommand(String line) throws IOException {
        String command;
        String[] args = this.parseCommand(line);
        if (args.length == 0) {
            return;
        }
        String verbatimCmd = args[0];
        String className = command = args[0].toUpperCase();
        for (String prefix : this.prefixes) {
            if (!command.contains(".")) {
                className = prefix + command;
            }
            try {
                Object cmd = this.getCommand(className);
                if (cmd == null) continue;
                try {
                    args[0] = ISOUtil.unPadLeft(line, ' ');
                    if (cmd instanceof CLI.Command) {
                        ((CLI.Command)cmd).exec(new LegacyCommandAdapter(this.ctx), args);
                    } else if (cmd instanceof CLICommand) {
                        ((CLICommand)cmd).exec(this.ctx, args);
                    }
                    return;
                }
                catch (Exception ex) {
                    this.ctx.printThrowable(ex);
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (Exception ex) {
                this.ctx.printThrowable(ex);
                break;
            }
        }
        this.ctx.println("Invalid command '" + verbatimCmd + "'");
    }

    private Object getCommand(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.loadClass(className).newInstance();
    }

    String[] parseCommand(String line) throws IOException {
        if (line == null) {
            return new String[0];
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(line);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        String[] args = new String[matchList.size()];
        matchList.toArray(args);
        return args;
    }

    public static class LegacyCommandAdapter
    extends CLI {
        CLIContext ctx;

        public LegacyCommandAdapter(CLIContext ctx) throws IOException {
            super(null, null, false);
            this.ctx = ctx;
        }

        @Override
        public void print(String s) {
            this.ctx.print(s);
        }

        @Override
        public void println(String s) {
            this.ctx.println(s);
        }

        @Override
        public boolean confirm(String prompt) throws IOException {
            return this.ctx.confirm(prompt);
        }

        @Override
        public Q2 getQ2() {
            return this.ctx.getQ2();
        }

        @Override
        public ConsoleReader getConsoleReader() {
            return this.ctx.getConsoleReader();
        }

        @Override
        public PrintStream getOutputStream() {
            return this.ctx.getOutputStream();
        }
    }
}

