/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.q2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.LinkedList;
import java.util.StringTokenizer;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import org.jpos.q2.CLICommandInterface;
import org.jpos.q2.CLIContext;
import org.jpos.q2.CLIPrefixedClassNameCompletor;
import org.jpos.q2.Q2;

public class CLI
implements Runnable {
    Thread t;
    Completor completor;
    String line = null;
    boolean keepRunning = false;
    protected CLIContext ctx;
    CLICommandInterface cmdInterface;

    public CLI(Q2 q2, String line, boolean keepRunning) throws IOException {
        this(q2, System.in, System.out, line, keepRunning);
    }

    public CLI(Q2 q2, InputStream in, OutputStream out, String line, boolean keepRunning) throws IOException {
        ConsoleReader reader = new ConsoleReader(in, (Writer)new OutputStreamWriter(out));
        reader.setBellEnabled(true);
        this.ctx = new CLIContext();
        this.ctx.setQ2(q2);
        this.ctx.setConsoleReader(reader);
        this.ctx.setOutputStream(new PrintStream(out));
        this.line = line;
        this.keepRunning = keepRunning;
        this.initCompletor();
    }

    protected boolean isRunning() {
        return this.ctx.getQ2().running();
    }

    protected void markStopped() {
    }

    protected void markStarted() {
    }

    protected String[] getCompletionPrefixes() {
        return new String[]{"org.jpos.q2.cli."};
    }

    protected String getPrompt() {
        return "q2> ";
    }

    protected void handleExit() {
    }

    private void initCompletor() throws IOException {
        this.cmdInterface = new CLICommandInterface(this.ctx);
        for (String s : this.getCompletionPrefixes()) {
            this.cmdInterface.addPrefix(s);
        }
        LinkedList<CLIPrefixedClassNameCompletor> l = new LinkedList<CLIPrefixedClassNameCompletor>();
        l.add(new CLIPrefixedClassNameCompletor(this.cmdInterface.getPrefixes()));
        this.completor = new ArgumentCompletor(l);
    }

    public void start() throws Exception {
        this.markStarted();
        this.t = new Thread(this);
        this.t.setName("Q2-CLI");
        this.t.start();
    }

    public void stop() {
        this.markStopped();
        try {
            this.t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning()) {
            if (this.line == null) {
                ConsoleReader reader = this.ctx.getConsoleReader();
                reader.addCompletor(this.completor);
                try {
                    this.line = reader.readLine(this.getPrompt());
                }
                catch (IOException e) {
                    this.ctx.printThrowable(e);
                }
                finally {
                    reader.removeCompletor(this.completor);
                }
            }
            if (this.line != null) {
                StringTokenizer st = new StringTokenizer(this.line, ";");
                while (st.hasMoreTokens()) {
                    String n = st.nextToken();
                    try {
                        this.cmdInterface.execCommand(n);
                    }
                    catch (IOException e) {
                        this.ctx.printThrowable(e);
                    }
                }
                this.line = null;
            }
            if (this.keepRunning) continue;
        }
        this.handleExit();
    }

    public void print(String s) {
    }

    public void println(String s) {
    }

    public boolean confirm(String prompt) throws IOException {
        return false;
    }

    public Q2 getQ2() {
        return null;
    }

    public ConsoleReader getConsoleReader() {
        return null;
    }

    public PrintStream getOutputStream() {
        return null;
    }

    public static interface Command {
        public void exec(CLI var1, String[] var2) throws Exception;
    }
}

