/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.validator;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOBaseValidator;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOVError;
import org.jpos.iso.ISOVMsg;
import org.jpos.iso.validator.ISOVException;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class TEST0100
extends ISOBaseValidator {
    private HashSet msgTypes = new HashSet();

    public TEST0100() {
    }

    public TEST0100(boolean breakOnError) {
        super(breakOnError);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        super.setConfiguration(cfg);
        StringTokenizer st = new StringTokenizer(cfg.get("msg-type", ""), " ");
        while (st.hasMoreTokens()) {
            this.msgTypes.add(st.nextToken());
        }
    }

    @Override
    public ISOComponent validate(ISOComponent m) throws ISOException {
        if (this.msgTypes.contains(((ISOMsg)m).getMTI())) {
            LogEvent evt = new LogEvent(this, "validate");
            try {
                super.validate(m);
                ISOMsg msg = (ISOMsg)m;
                int[] validFields = new int[]{4, 5, 7, 48};
                if (!msg.hasFields(validFields)) {
                    ISOVError e = new ISOVError("Fields " + this.makeStrFromArray(validFields) + " must appear in msg.", "001");
                    if (msg instanceof ISOVMsg) {
                        ((ISOVMsg)msg).addISOVError(e);
                    } else {
                        msg = new ISOVMsg(msg, e);
                    }
                    if (this.breakOnError) {
                        throw new ISOVException("Error on msg. ", msg);
                    }
                }
                ISOMsg iSOMsg = msg;
                return iSOMsg;
            }
            catch (ISOVException ex) {
                throw ex;
            }
            finally {
                Logger.log(evt);
            }
        }
        return m;
    }

    private String makeStrFromArray(int[] validFields) {
        if (validFields == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int validField : validFields) {
            result.append(validField);
            result.append(", ");
        }
        result.delete(result.length() - 2, result.length() - 1);
        return result.toString();
    }
}

