/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.validator;

import org.jpos.iso.ISOBaseValidator;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOVError;
import org.jpos.iso.ISOVMsg;
import org.jpos.iso.validator.ISOVException;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class MSGTEST02
extends ISOBaseValidator {
    public MSGTEST02() {
    }

    public MSGTEST02(boolean breakOnError) {
        super(breakOnError);
    }

    private String makeStrFromArray(int[] validFields) {
        if (validFields == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int validField : validFields) {
            result.append(validField);
            result.append(", ");
        }
        result.delete(result.length() - 2, result.length() - 1);
        return result.toString();
    }

    @Override
    public ISOComponent validate(ISOComponent m) throws ISOException {
        LogEvent evt = new LogEvent(this, "validate");
        try {
            ISOVError e;
            super.validate(m);
            ISOMsg msg = (ISOMsg)m;
            int[] validFields = new int[]{0, 1};
            if (!msg.hasFields(validFields)) {
                e = new ISOVError("Fields " + this.makeStrFromArray(validFields) + " must appear in msg.", "002");
                if (msg instanceof ISOVMsg) {
                    ((ISOVMsg)msg).addISOVError(e);
                } else {
                    msg = new ISOVMsg(msg, e);
                }
                if (this.breakOnError) {
                    throw new ISOVException("Error on msg. ", msg);
                }
            }
            if (msg.getString(0).endsWith("1") && !msg.getString(1).endsWith("0")) {
                e = new ISOVError("If field 0 ends with 1 then field 1 must end with 0.", "003");
                if (msg instanceof ISOVMsg) {
                    ((ISOVMsg)msg).addISOVError(e);
                } else {
                    msg = new ISOVMsg(msg, e);
                }
                if (this.breakOnError) {
                    throw new ISOVException("Error on msg. ", msg);
                }
            }
            ISOMsg iSOMsg = msg;
            return iSOMsg;
        }
        catch (ISOVException ex) {
            throw ex;
        }
        finally {
            Logger.log(evt);
        }
    }
}

