/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.validator;

import org.jpos.iso.ISOBaseValidator;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOVError;
import org.jpos.iso.ISOVMsg;
import org.jpos.iso.validator.ISOVException;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class MSGTEST
extends ISOBaseValidator {
    public MSGTEST() {
    }

    public MSGTEST(boolean breakOnError) {
        super(breakOnError);
    }

    private String makeStrFromArray(int[] validFields) {
        if (validFields == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int validField : validFields) {
            result.append(validField);
            result.append(", ");
        }
        result.delete(result.length() - 2, result.length() - 1);
        return result.toString();
    }

    @Override
    public ISOComponent validate(ISOComponent m) throws ISOException {
        LogEvent evt = new LogEvent(this, "validate");
        try {
            super.validate(m);
            ISOMsg msg = (ISOMsg)m;
            int[] validFields = new int[]{3, 7, 11};
            if (!msg.hasFields(validFields)) {
                ISOVError e = new ISOVError("Fields " + this.makeStrFromArray(validFields) + " must appear in msg.", "001");
                if (msg instanceof ISOVMsg) {
                    ((ISOVMsg)msg).addISOVError(e);
                } else {
                    msg = new ISOVMsg(msg, e);
                }
                if (this.breakOnError) {
                    throw new ISOVException("Error on msg. ", msg);
                }
            }
            ISOMsg iSOMsg = msg;
            return iSOMsg;
        }
        catch (ISOVException ex) {
            throw ex;
        }
        finally {
            Logger.log(evt);
        }
    }
}

