/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Stack;
import org.jpos.iso.ISOAmount;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.header.BaseHeader;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XML2003Packager
extends DefaultHandler
implements ISOPackager,
LogSource {
    protected Logger logger = null;
    protected String realm = null;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private PrintStream p;
    private XMLReader reader = null;
    private Stack stk;
    public static final String ISOMSG_TAG = "isomsg";
    public static final String ISOFIELD_TAG = "field";
    public static final String ID_ATTR = "id";
    public static final String VALUE_ATTR = "value";
    public static final String TYPE_ATTR = "type";
    public static final String TYPE_BINARY = "binary";
    public static final String TYPE_BITMAP = "bitmap";
    public static final String TYPE_AMOUNT = "amount";
    public static final String CURRENCY_ATTR = "currency";
    public static final String HEADER_TAG = "header";
    public static final int[] BINARY_FIELDS = new int[]{72};

    public XML2003Packager() throws ISOException {
        try {
            this.p = new PrintStream((OutputStream)this.out, false, "utf-8");
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        this.stk = new Stack();
        try {
            this.reader = this.createXMLReader();
        }
        catch (Exception e) {
            throw new ISOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        LogEvent evt = new LogEvent(this, "pack");
        try {
            byte[] b;
            if (!(c instanceof ISOMsg)) {
                throw new ISOException("cannot pack " + c.getClass());
            }
            ISOMsg m = (ISOMsg)c;
            Object object = this;
            synchronized (object) {
                m.setDirection(0);
                m.dump(this.p, "");
                b = this.out.toByteArray();
                this.out.reset();
            }
            if (this.logger != null) {
                evt.addMessage(m);
            }
            object = b;
            return object;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public synchronized int unpack(ISOComponent c, byte[] b) throws ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        try {
            if (!(c instanceof ISOMsg)) {
                throw new ISOException("Can't call packager on non Composite");
            }
            while (!this.stk.empty()) {
                this.stk.pop();
            }
            InputSource src = new InputSource(new ByteArrayInputStream(b));
            this.reader.parse(src);
            if (this.stk.empty()) {
                throw new ISOException("error parsing");
            }
            ISOMsg m = (ISOMsg)c;
            ISOMsg m1 = (ISOMsg)this.stk.pop();
            m.merge(m1);
            m.setHeader(m1.getHeader());
            this.fixup(m, BINARY_FIELDS);
            if (this.logger != null) {
                evt.addMessage(m);
            }
            int n = b.length;
            return n;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (IOException e) {
            evt.addMessage(e);
            throw new ISOException(e.toString());
        }
        catch (SAXException e) {
            evt.addMessage(e);
            throw new ISOException(e.toString());
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public synchronized void unpack(ISOComponent c, InputStream in) throws ISOException, IOException {
        LogEvent evt = new LogEvent(this, "unpack");
        try {
            if (!(c instanceof ISOMsg)) {
                throw new ISOException("Can't call packager on non Composite");
            }
            while (!this.stk.empty()) {
                this.stk.pop();
            }
            this.reader.parse(new InputSource(in));
            if (this.stk.empty()) {
                throw new ISOException("error parsing");
            }
            ISOMsg m = (ISOMsg)c;
            m.merge((ISOMsg)this.stk.pop());
            this.fixup(m, BINARY_FIELDS);
            if (this.logger != null) {
                evt.addMessage(m);
            }
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (SAXException e) {
            evt.addMessage(e);
            throw new ISOException(e.toString());
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public void startElement(String ns, String name, String qName, Attributes atts) throws SAXException {
        int fieldNumber = -1;
        try {
            String id = atts.getValue(ID_ATTR);
            if (id != null) {
                try {
                    fieldNumber = Integer.parseInt(id);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (name.equals(ISOMSG_TAG)) {
                if (fieldNumber >= 0) {
                    if (this.stk.empty()) {
                        throw new SAXException("inner without outter");
                    }
                    ISOMsg inner = new ISOMsg(fieldNumber);
                    ((ISOMsg)this.stk.peek()).set(inner);
                    this.stk.push(inner);
                } else {
                    this.stk.push(new ISOMsg(0));
                }
            } else if (name.equals(ISOFIELD_TAG)) {
                ISOMsg m = (ISOMsg)this.stk.peek();
                String value = atts.getValue(VALUE_ATTR);
                String type = atts.getValue(TYPE_ATTR);
                if (id == null || value == null) {
                    throw new SAXException("invalid field");
                }
                if (TYPE_BINARY.equals(type)) {
                    m.set(new ISOBinaryField(fieldNumber, ISOUtil.hex2byte(value.getBytes(), 0, value.length() / 2)));
                } else if (TYPE_AMOUNT.equals(type)) {
                    ISOAmount amount = new ISOAmount(fieldNumber, Integer.parseInt(atts.getValue(CURRENCY_ATTR)), new BigDecimal(value));
                    m.set(amount);
                } else {
                    m.set(new ISOField(fieldNumber, value));
                }
            } else if (HEADER_TAG.equals(name)) {
                this.stk.push(new BaseHeader());
            }
        }
        catch (ISOException e) {
            throw new SAXException("ISOException unpacking " + fieldNumber);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.stk.peek() instanceof BaseHeader) {
            ((BaseHeader)this.stk.peek()).unpack(ISOUtil.hex2byte(new String(ch, start, length)));
        }
    }

    @Override
    public void endElement(String ns, String name, String qname) throws SAXException {
        if (name.equals(ISOMSG_TAG)) {
            ISOMsg m = (ISOMsg)this.stk.pop();
            if (this.stk.empty()) {
                this.stk.push(m);
            }
        } else if (HEADER_TAG.equals(name)) {
            BaseHeader h = (BaseHeader)this.stk.pop();
            ISOMsg m = (ISOMsg)this.stk.peek();
            m.setHeader(h);
        }
    }

    @Override
    public String getFieldDescription(ISOComponent m, int fldNumber) {
        return "Data element " + fldNumber;
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public ISOMsg createISOMsg() {
        return new ISOMsg();
    }

    @Override
    public String getDescription() {
        return this.getClass().getName();
    }

    private void fixup(ISOMsg m, int[] bfields) throws ISOException {
        for (int f : bfields) {
            ISOComponent c;
            if (!m.hasField(f) || !((c = m.getComponent(f)) instanceof ISOField)) continue;
            m.set(f, ((ISOField)c).getBytes());
        }
    }

    private XMLReader createXMLReader() throws SAXException {
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            reader = XMLReaderFactory.createXMLReader(System.getProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl"));
        }
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        return reader;
    }
}

