/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.VISA1ResponseFilter;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.jpos.util.SimpleLogSource;

public class VISA1Packager
extends SimpleLogSource
implements ISOPackager,
VISA1ResponseFilter {
    public static final byte[] FS = new byte[]{28};
    int[] sequence;
    int respField;
    String badResultCode;
    String okPattern;
    VISA1ResponseFilter filter;

    public VISA1Packager(int[] sequence, int respField, String badResultCode, String okPattern) {
        this.sequence = sequence;
        this.respField = respField;
        this.badResultCode = badResultCode;
        this.okPattern = okPattern;
        this.setVISA1ResponseFilter(this);
    }

    public void setVISA1ResponseFilter(VISA1ResponseFilter filter) {
        this.filter = filter;
    }

    protected int handleSpecialField35(ISOMsg m, List l) throws ISOException {
        int len = 0;
        byte[] entryMode = new byte[1];
        if (m.hasField(35)) {
            entryMode[0] = 1;
            byte[] value = m.getString(35).getBytes();
            l.add(entryMode);
            l.add(value);
            l.add(FS);
            len += value.length + 2;
        } else if (m.hasField(2) && m.hasField(14)) {
            entryMode[0] = 0;
            String simulatedTrack2 = m.getString(2) + "=" + m.getString(14);
            l.add(entryMode);
            l.add(simulatedTrack2.getBytes());
            l.add(FS);
            len += simulatedTrack2.length() + 2;
        }
        return len;
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        LogEvent evt = new LogEvent(this, "pack");
        try {
            if (!(c instanceof ISOMsg)) {
                throw new ISOException("Can't call VISA1 packager on non ISOMsg");
            }
            ISOMsg m = (ISOMsg)c;
            int len = 0;
            ArrayList<byte[]> l = new ArrayList<byte[]>();
            for (int i = 0; i < this.sequence.length; ++i) {
                byte[] value;
                int fld = this.sequence[i];
                if (fld == 35) {
                    len += this.handleSpecialField35(m, l);
                    continue;
                }
                if (!m.hasField(fld)) continue;
                if (fld == 4) {
                    long amt = Long.valueOf(m.getString(4));
                    value = ISOUtil.formatAmount(amt, 12).trim().getBytes();
                } else {
                    value = m.getString(fld).getBytes();
                }
                l.add(value);
                len += value.length;
                if (i >= this.sequence.length - 1) continue;
                l.add(FS);
                ++len;
            }
            int k = 0;
            byte[] d = new byte[len];
            for (byte[] b : l) {
                System.arraycopy(b, 0, d, k, b.length);
                k += b.length;
            }
            if (this.logger != null) {
                evt.addMessage(ISOUtil.dumpString(d));
            }
            byte[] byArray = d;
            return byArray;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public String guessAutNumber(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            buf.append(s.charAt(i));
        }
        if (buf.length() == 0) {
            return null;
        }
        while (buf.length() > 6) {
            buf.deleteCharAt(0);
        }
        while (buf.length() < 6) {
            buf.insert(0, "0");
        }
        return buf.toString();
    }

    @Override
    public int unpack(ISOComponent m, byte[] b) throws ISOException {
        String autNumber;
        String response = new String(b);
        m.set(new ISOField(this.respField, response));
        m.set(new ISOField(39, this.badResultCode));
        if (response.startsWith(this.okPattern) && (autNumber = this.filter.guessAutNumber(response)) != null) {
            m.set(new ISOField(39, "00"));
            m.set(new ISOField(38, autNumber));
        }
        return b.length;
    }

    @Override
    public void unpack(ISOComponent m, InputStream in) throws ISOException {
        throw new ISOException("not implemented");
    }

    @Override
    public String getFieldDescription(ISOComponent m, int fldNumber) {
        return "VISA 1 fld " + fldNumber;
    }

    @Override
    public String getDescription() {
        return this.getClass().getName();
    }

    @Override
    public ISOMsg createISOMsg() {
        return new ISOMsg();
    }
}

