/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOPackager;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;

public abstract class PackagerWrapper
implements ISOPackager,
LogSource,
Configurable {
    protected Logger logger = null;
    protected String realm = null;
    protected ISOPackager standardPackager = null;
    protected Configuration cfg;

    @Override
    public abstract byte[] pack(ISOComponent var1) throws ISOException;

    @Override
    public abstract int unpack(ISOComponent var1, byte[] var2) throws ISOException;

    @Override
    public String getFieldDescription(ISOComponent m, int fldNumber) {
        return this.standardPackager != null ? this.standardPackager.getFieldDescription(m, fldNumber) : "";
    }

    public void setPackager(ISOPackager packger) {
        this.standardPackager = packger;
    }

    public ISOPackager getPackager() {
        return this.standardPackager;
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
        this.standardPackager.setLogger(logger, realm);
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        String packagerName = cfg.get("inner-packager");
        try {
            Class<?> p = Class.forName(packagerName);
            this.setPackager((ISOPackager)p.newInstance());
            if (this.standardPackager instanceof Configurable) {
                ((Configurable)((Object)this.standardPackager)).setConfiguration(cfg);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Invalid inner-packager", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Invalid inner-packager", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Invalid inner-packager", e);
        }
    }
}

