/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.util.Map;
import org.jpos.iso.ISOBasePackager;
import org.jpos.iso.ISOBaseValidator;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldValidator;
import org.jpos.iso.ISOValidator;
import org.jpos.iso.validator.ISOVException;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class ISOBaseValidatingPackager
extends ISOBasePackager
implements ISOValidator {
    protected ISOBaseValidator[] msgVld;
    protected ISOValidator[] fldVld;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISOComponent validate(ISOComponent m) throws ISOException {
        LogEvent evt = new LogEvent(this, "validate");
        try {
            Map fields = m.getChildren();
            for (ISOValidator iSOValidator : this.fldVld) {
                ISOComponent c;
                if (iSOValidator == null || (c = (ISOComponent)fields.get(((ISOFieldValidator)iSOValidator).getFieldId())) == null) continue;
                try {
                    m.set(iSOValidator.validate(c));
                }
                catch (ISOVException e) {
                    if (!e.treated()) {
                        m.set(e.getErrComponent());
                        e.setTreated(true);
                    }
                    evt.addMessage("Component Validation Error.");
                    throw e;
                }
            }
            try {
                if (this.msgVld != null) {
                    for (ISOValidator iSOValidator : this.msgVld) {
                        if (iSOValidator == null) continue;
                        m = ((ISOBaseValidator)iSOValidator).validate(m);
                    }
                }
            }
            catch (ISOVException ex) {
                evt.addMessage("Component Validation Error.");
                throw ex;
            }
            ISOComponent iSOComponent = m;
            return iSOComponent;
        }
        finally {
            Logger.log(evt);
        }
    }

    public void setFieldValidator(ISOValidator[] fvlds) {
        this.fldVld = fvlds;
    }

    public void setMsgValidator(ISOBaseValidator[] msgVlds) {
        this.msgVld = msgVlds;
    }
}

