/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import org.jpos.core.ConfigurationException;
import org.jpos.core.SimpleConfiguration;
import org.jpos.iso.ISOBasePackager;
import org.jpos.iso.ISOBaseValidator;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOFieldValidator;
import org.jpos.iso.ISOMsgFieldPackager;
import org.jpos.iso.ISOMsgFieldValidator;
import org.jpos.iso.ISOValidator;
import org.jpos.iso.packager.GenericPackager;
import org.jpos.iso.packager.ISOBaseValidatingPackager;
import org.jpos.iso.validator.ISOVException;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class GenericValidatingPackager
extends GenericPackager
implements ISOValidator {
    protected int maxValidField = 128;
    protected boolean emitBitmap = true;
    protected int bitmapField = 1;
    protected ISOValidator[] fvlds = new ISOValidator[0];
    protected ISOBaseValidator[] mvlds = new ISOBaseValidator[0];
    static final int inc = 500;

    public GenericValidatingPackager() throws ISOException {
    }

    public GenericValidatingPackager(String fileName) throws ISOException {
        super(fileName);
    }

    public GenericValidatingPackager(InputStream stream) throws ISOException {
        super(stream);
    }

    private ISOFieldPackager[] makeFieldArray(Map<Integer, ISOFieldPackager> m) {
        int maxField = 0;
        for (Map.Entry<Integer, ISOFieldPackager> ent : m.entrySet()) {
            if (ent.getKey() <= maxField) continue;
            maxField = ent.getKey();
        }
        ISOFieldPackager[] fld = new ISOFieldPackager[maxField + 1];
        for (Map.Entry<Integer, ISOFieldPackager> ent : m.entrySet()) {
            fld[ent.getKey().intValue()] = ent.getValue();
        }
        return fld;
    }

    @Override
    public void readFile(String filename) throws ISOException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader(System.getProperty("sax.parser", "org.apache.crimson.parser.XMLReaderImpl"));
            reader.setFeature("http://xml.org/sax/features/validation", true);
            GenericValidatorContentHandler handler = new GenericValidatorContentHandler();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setEntityResolver(new GenericPackager.GenericEntityResolver());
            reader.parse(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ISOException(e);
        }
    }

    @Override
    protected void setGenericPackagerParams(Attributes atts) {
        String maxField = atts.getValue("maxValidField");
        String emitBmap = atts.getValue("emitBitmap");
        String bmapfield = atts.getValue("bitmapField");
        if (maxField != null) {
            this.maxValidField = Integer.parseInt(maxField);
        }
        if (emitBmap != null) {
            this.emitBitmap = Boolean.valueOf(emitBmap);
        }
        if (bmapfield != null) {
            this.bitmapField = Integer.parseInt(bmapfield);
        }
    }

    public void setMsgValidator(ISOBaseValidator[] msgVlds) {
        this.mvlds = msgVlds;
    }

    public void setFieldValidator(ISOFieldValidator[] fvlds) {
        this.fvlds = fvlds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISOComponent validate(ISOComponent m) throws ISOException {
        LogEvent evt = new LogEvent(this, "validate");
        try {
            Map fields = m.getChildren();
            for (ISOValidator iSOValidator : this.fvlds) {
                ISOComponent c = (ISOComponent)fields.get(((ISOFieldValidator)iSOValidator).getFieldId());
                if (c == null) continue;
                try {
                    m.set(iSOValidator.validate(c));
                }
                catch (ISOVException e) {
                    if (!e.treated()) {
                        m.set(e.getErrComponent());
                        e.setTreated(true);
                    }
                    evt.addMessage("Component Validation Error.");
                    throw e;
                }
            }
            try {
                for (ISOValidator iSOValidator : this.mvlds) {
                    m = ((ISOBaseValidator)iSOValidator).validate(m);
                }
            }
            catch (ISOVException ex) {
                evt.addMessage("Component Validation Error.");
                throw ex;
            }
            ISOComponent iSOComponent = m;
            return iSOComponent;
        }
        finally {
            Logger.log(evt);
        }
    }

    public class GenericValidatorContentHandler
    extends DefaultHandler {
        static final int VALIDATOR_INDEX = -3;
        private Stack<Object> fieldStack;
        private Stack<Object> validatorStack;
        private String fldID;

        @Override
        public void startDocument() {
            this.fieldStack = new Stack();
            this.validatorStack = new Stack();
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.fieldStack.isEmpty()) {
                throw new SAXException("Format error in XML Field Description File");
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                String breakOnError;
                Class<?> c;
                String type;
                if (localName.equals("isopackager")) {
                    this.fieldStack.push(new TreeMap());
                    TreeMap m = new TreeMap();
                    m.put(-3, new ArrayList());
                    this.validatorStack.push(m);
                    GenericValidatingPackager.this.setGenericPackagerParams(atts);
                }
                if (localName.equals("isofield")) {
                    this.fldID = atts.getValue("id");
                    type = atts.getValue("class");
                    String name = atts.getValue("name");
                    String size = atts.getValue("length");
                    String pad = atts.getValue("pad");
                    c = Class.forName(type);
                    ISOFieldPackager f = (ISOFieldPackager)c.newInstance();
                    f.setDescription(name);
                    f.setLength(Integer.parseInt(size));
                    f.setPad(Boolean.parseBoolean(pad));
                    Map m = (Map)this.fieldStack.peek();
                    m.put(new Integer(this.fldID), f);
                }
                if (localName.equals("isofieldvalidator")) {
                    type = atts.getValue("class");
                    breakOnError = atts.getValue("break-on-error");
                    String minLen = atts.getValue("minlen");
                    String maxLen = atts.getValue("maxlen");
                    c = Class.forName(type);
                    ISOFieldValidator v = (ISOFieldValidator)c.newInstance();
                    if (breakOnError != null) {
                        v.setBreakOnError(Boolean.valueOf(breakOnError));
                    }
                    if (minLen != null) {
                        v.setMinLength(Integer.parseInt(minLen));
                    }
                    if (maxLen != null) {
                        v.setMaxLength(Integer.parseInt(maxLen));
                    }
                    v.setFieldId(Integer.parseInt(this.fldID));
                    this.validatorStack.push(v);
                    this.validatorStack.push(new Properties());
                }
                if (localName.equals("property")) {
                    ((Properties)this.validatorStack.peek()).setProperty(atts.getValue("name"), atts.getValue("value"));
                }
                if (localName.equals("isovalidator")) {
                    type = atts.getValue("class");
                    breakOnError = atts.getValue("break-on-error");
                    Class<?> c2 = Class.forName(type);
                    ISOBaseValidator v = (ISOBaseValidator)c2.newInstance();
                    if (breakOnError != null) {
                        v.setBreakOnError(Boolean.valueOf(breakOnError));
                    }
                    this.validatorStack.push(v);
                    this.validatorStack.push(new Properties());
                }
                if (localName.equals("isofieldpackager")) {
                    String id = atts.getValue("id");
                    String type2 = atts.getValue("class");
                    String name = atts.getValue("name");
                    String size = atts.getValue("length");
                    String pad = atts.getValue("pad");
                    String packager = atts.getValue("packager");
                    this.fieldStack.push(new Integer(id));
                    ISOFieldPackager f = (ISOFieldPackager)Class.forName(type2).newInstance();
                    f.setDescription(name);
                    f.setLength(Integer.parseInt(size));
                    f.setPad(Boolean.parseBoolean(pad));
                    this.fieldStack.push(f);
                    ISOBasePackager p = (ISOBasePackager)Class.forName(packager).newInstance();
                    if (p instanceof GenericValidatingPackager) {
                        GenericValidatingPackager gp = (GenericValidatingPackager)p;
                        gp.setGenericPackagerParams(atts);
                    }
                    this.fieldStack.push(p);
                    String validator = atts.getValue("validator");
                    ISOBaseValidatingPackager v = (ISOBaseValidatingPackager)Class.forName(validator).newInstance();
                    this.validatorStack.push(v);
                    TreeMap m = new TreeMap();
                    m.put(-3, new ArrayList());
                    this.validatorStack.push(m);
                    this.fieldStack.push(new TreeMap());
                }
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        }

        private ISOFieldPackager[] makeFieldPackArray(Map<Integer, ISOFieldPackager> m) {
            int maxField = 0;
            for (Map.Entry<Integer, ISOFieldPackager> ent : m.entrySet()) {
                if (ent.getKey() <= maxField) continue;
                maxField = ent.getKey();
            }
            ISOFieldPackager[] fld = new ISOFieldPackager[maxField + 1];
            for (Map.Entry<Integer, ISOFieldPackager> ent : m.entrySet()) {
                fld[ent.getKey().intValue()] = ent.getValue();
            }
            return fld;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            SimpleConfiguration cfg;
            Properties p;
            Map m;
            if (localName.equals("isopackager")) {
                m = (Map)this.fieldStack.pop();
                GenericValidatingPackager.this.setFieldPackager(this.makeFieldPackArray(m));
                m = (Map)this.validatorStack.pop();
                GenericValidatingPackager.this.setFieldValidator(this.makeFieldValidatorArray(m));
                GenericValidatingPackager.this.setMsgValidator(this.makeMsgValidatorArray(m));
            }
            if (localName.equals("isofieldvalidator")) {
                p = (Properties)this.validatorStack.pop();
                cfg = null;
                if (!p.entrySet().isEmpty()) {
                    cfg = new SimpleConfiguration(p);
                }
                ISOFieldValidator f = (ISOFieldValidator)this.validatorStack.pop();
                if (cfg != null) {
                    try {
                        f.setConfiguration(cfg);
                    }
                    catch (ConfigurationException ex) {
                        ex.printStackTrace();
                    }
                }
                ((Map)this.validatorStack.peek()).put(new Integer(this.fldID), f);
            }
            if (localName.equals("isovalidator")) {
                p = (Properties)this.validatorStack.pop();
                cfg = null;
                if (!p.entrySet().isEmpty()) {
                    cfg = new SimpleConfiguration(p);
                }
                ISOBaseValidator v = (ISOBaseValidator)this.validatorStack.pop();
                if (cfg != null) {
                    try {
                        v.setConfiguration(cfg);
                    }
                    catch (ConfigurationException ex) {
                        ex.printStackTrace();
                    }
                }
                ((List)((Map)this.validatorStack.peek()).get(-3)).add(v);
            }
            if (localName.equals("isofieldpackager")) {
                m = (Map)this.fieldStack.pop();
                ISOBasePackager msgPackager = (ISOBasePackager)this.fieldStack.pop();
                msgPackager.setFieldPackager(GenericValidatingPackager.this.makeFieldArray(m));
                msgPackager.setLogger(GenericValidatingPackager.this.getLogger(), "Generic Packager");
                ISOFieldPackager fieldPackager = (ISOFieldPackager)this.fieldStack.pop();
                Integer fno = (Integer)this.fieldStack.pop();
                ISOMsgFieldPackager mfp = new ISOMsgFieldPackager(fieldPackager, msgPackager);
                m = (Map)this.fieldStack.peek();
                m.put(fno, mfp);
                Map val = (Map)this.validatorStack.pop();
                ISOBaseValidatingPackager v = (ISOBaseValidatingPackager)this.validatorStack.pop();
                v.setFieldValidator(this.makeFieldValidatorArray(val));
                v.setMsgValidator(this.makeMsgValidatorArray(val));
                ISOMsgFieldValidator mfv = new ISOMsgFieldValidator(fieldPackager.getDescription(), v);
                mfv.setFieldId(fno);
                v.setLogger(GenericValidatingPackager.this.getLogger(), "Generic validating Packager");
                m = (Map)this.validatorStack.peek();
                m.put(fno, mfv);
            }
        }

        ISOFieldValidator[] makeFieldValidatorArray(Map<Integer, ISOFieldValidator> m) {
            ArrayList<ISOFieldValidator> l = new ArrayList<ISOFieldValidator>();
            for (Map.Entry<Integer, ISOFieldValidator> ent : m.entrySet()) {
                if (ent.getKey() == -3) continue;
                l.add(ent.getValue());
            }
            return l.toArray(new ISOFieldValidator[l.size()]);
        }

        ISOBaseValidator[] makeMsgValidatorArray(Map m) {
            List l = (List)m.get(-3);
            return l.toArray(new ISOBaseValidator[l.size()]);
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }
}

