/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.jpos.iso.ISOBitMapPackager;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOMsgFieldPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.TaggedFieldPackagerBase;
import org.jpos.iso.packager.GenericPackager;
import org.jpos.iso.packager.TagMapper;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.xml.sax.Attributes;

public class GenericTaggedFieldsPackager
extends GenericPackager {
    private TagMapper tagMapper = null;
    private Integer fieldId = 0;

    @Override
    public int unpack(ISOComponent m, byte[] b) throws ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        try {
            if (m.getComposite() != m) {
                throw new ISOException("Can't call packager on non Composite");
            }
            if (b.length == 0) {
                int n = 0;
                return n;
            }
            if (this.logger != null) {
                evt.addMessage(ISOUtil.hexString(b));
            }
            int consumed = 0;
            int maxField = this.fld.length;
            for (int i = this.getFirstField(); i < maxField && consumed < b.length; ++i) {
                if (this.fld[i] == null) continue;
                ISOComponent c = this.fld[i].createComponent(i);
                int unpacked = this.fld[i].unpack(c, b, consumed);
                consumed += unpacked;
                if (unpacked <= 0) continue;
                m.set(c);
            }
            if (b.length != consumed) {
                evt.addMessage("WARNING: unpack len=" + b.length + " consumed=" + consumed);
            }
            int n = consumed;
            return n;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public void unpack(ISOComponent m, InputStream in) throws IOException, ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        try {
            if (m.getComposite() != m) {
                throw new ISOException("Can't call packager on non Composite");
            }
            if (m instanceof ISOMsg && ((ISOMsg)m).getHeader() == null && this.headerLength > 0) {
                byte[] h = new byte[this.headerLength];
                in.read(h, 0, this.headerLength);
                ((ISOMsg)m).setHeader(h);
            }
            if (!(this.fld[0] instanceof ISOMsgFieldPackager) && !(this.fld[0] instanceof ISOBitMapPackager)) {
                ISOComponent mti = this.fld[0].createComponent(0);
                this.fld[0].unpack(mti, in);
                m.set(mti);
            }
            int maxField = this.fld.length;
            for (int i = this.getFirstField(); i < maxField; ++i) {
                if (this.fld[i] == null) continue;
                ISOComponent c = this.fld[i].createComponent(i);
                this.fld[i].unpack(c, in);
                if (this.logger != null) {
                    evt.addMessage("<unpack fld=\"" + i + "\" packager=\"" + this.fld[i].getClass().getName() + "\">");
                    if (c.getValue() instanceof ISOMsg) {
                        evt.addMessage(c.getValue());
                    } else {
                        evt.addMessage("  <value>" + c.getValue().toString() + "</value>");
                    }
                    evt.addMessage("</unpack>");
                }
                m.set(c);
            }
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public byte[] pack(ISOComponent m) throws ISOException {
        LogEvent evt = new LogEvent(this, "pack");
        try {
            ArrayList<byte[]> l = new ArrayList<byte[]>();
            Map fields = m.getChildren();
            int len = 0;
            for (int i = this.getFirstField(); i <= m.getMaxField(); ++i) {
                ISOComponent c = (ISOComponent)fields.get(i);
                if (c == null) continue;
                try {
                    byte[] b = this.fld[i].pack(c);
                    len += b.length;
                    l.add(b);
                    continue;
                }
                catch (Exception e) {
                    evt.addMessage("error packing subfield " + i);
                    evt.addMessage(c);
                    evt.addMessage(e);
                    throw e;
                }
            }
            int k = 0;
            byte[] d = new byte[len];
            for (byte[] b : l) {
                System.arraycopy(b, 0, d, k, b.length);
                k += b.length;
            }
            if (this.logger != null) {
                evt.addMessage(ISOUtil.hexString(d));
            }
            byte[] byArray = d;
            return byArray;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public void setFieldPackager(ISOFieldPackager[] fld) {
        super.setFieldPackager(fld);
        for (ISOFieldPackager aFld : fld) {
            if (!(aFld instanceof TaggedFieldPackagerBase)) continue;
            ((TaggedFieldPackagerBase)aFld).setParentFieldNumber(this.fieldId);
            ((TaggedFieldPackagerBase)aFld).setTagMapper(this.tagMapper);
            ((TaggedFieldPackagerBase)aFld).setPackingLenient(this.isPackingLenient());
            ((TaggedFieldPackagerBase)aFld).setUnpackingLenient(this.isUnpackingLenient());
        }
    }

    @Override
    protected void setGenericPackagerParams(Attributes atts) {
        super.setGenericPackagerParams(atts);
        try {
            Class<TagMapper> clazz = Class.forName(atts.getValue("tagMapper")).asSubclass(TagMapper.class);
            this.tagMapper = clazz.newInstance();
            this.fieldId = Integer.parseInt(atts.getValue("id"));
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isPackingLenient() {
        return false;
    }

    protected boolean isUnpackingLenient() {
        return false;
    }
}

