/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.IF_TBASE;
import org.jpos.iso.ISOBasePackager;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOMsgFieldPackager;
import org.jpos.iso.ISOPackager;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class GenericPackager
extends ISOBasePackager
implements Configurable {
    private int maxValidField = 128;
    private boolean emitBitmap = true;
    private int bitmapField = 1;
    private String firstField = null;
    private String filename;

    public GenericPackager() throws ISOException {
    }

    public GenericPackager(String filename) throws ISOException {
        this.filename = filename;
        this.readFile(filename);
    }

    public GenericPackager(InputStream input) throws ISOException {
        this.readFile(input);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.filename = cfg.get("packager-config", null);
        if (this.filename == null) {
            throw new ConfigurationException("packager-config property cannot be null");
        }
        try {
            String loggerName = cfg.get("packager-logger");
            if (loggerName != null) {
                this.setLogger(Logger.getLogger(loggerName), cfg.get("packager-realm"));
            }
            this.readFile(this.filename);
        }
        catch (ISOException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
    }

    @Override
    protected int getMaxValidField() {
        return this.maxValidField;
    }

    @Override
    protected boolean emitBitMap() {
        return this.emitBitmap;
    }

    @Override
    protected ISOFieldPackager getBitMapfieldPackager() {
        return this.fld[this.bitmapField];
    }

    public void readFile(String filename) throws ISOException {
        try {
            if (filename.startsWith("jar:") && filename.length() > 4) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                this.readFile(cl.getResourceAsStream(filename.substring(4)));
            } else {
                this.createXMLReader().parse(filename);
            }
        }
        catch (Exception e) {
            throw new ISOException("Error reading " + filename, e);
        }
    }

    public void readFile(InputStream input) throws ISOException {
        try {
            this.createXMLReader().parse(new InputSource(input));
        }
        catch (Exception e) {
            throw new ISOException(e);
        }
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        super.setLogger(logger, realm);
        if (this.fld != null) {
            for (int i = 0; i < this.fld.length; ++i) {
                ISOPackager o;
                if (!(this.fld[i] instanceof ISOMsgFieldPackager) || !((o = ((ISOMsgFieldPackager)this.fld[i]).getISOMsgPackager()) instanceof LogSource)) continue;
                ((LogSource)o).setLogger(logger, realm + "-fld-" + i);
            }
        }
    }

    private XMLReader createXMLReader() throws SAXException {
        XMLReader reader;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            reader = XMLReaderFactory.createXMLReader(System.getProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl"));
        }
        reader.setFeature("http://xml.org/sax/features/validation", true);
        GenericContentHandler handler = new GenericContentHandler();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(new GenericEntityResolver());
        return reader;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getDescription());
        if (this.filename != null) {
            sb.append('[');
            sb.append(this.filename);
            sb.append(']');
        }
        return sb.toString();
    }

    protected void setGenericPackagerParams(Attributes atts) {
        String maxField = atts.getValue("maxValidField");
        String emitBmap = atts.getValue("emitBitmap");
        String bmapfield = atts.getValue("bitmapField");
        this.firstField = atts.getValue("firstField");
        String headerLenStr = atts.getValue("headerLength");
        if (maxField != null) {
            this.maxValidField = Integer.parseInt(maxField);
        }
        if (emitBmap != null) {
            this.emitBitmap = Boolean.valueOf(emitBmap);
        }
        if (bmapfield != null) {
            this.bitmapField = Integer.parseInt(bmapfield);
        }
        if (this.firstField != null) {
            Integer.parseInt(this.firstField);
        }
        if (headerLenStr != null) {
            this.setHeaderLength(Integer.parseInt(headerLenStr));
        }
    }

    @Override
    protected int getFirstField() {
        if (this.firstField != null) {
            return Integer.parseInt(this.firstField);
        }
        return super.getFirstField();
    }

    public class GenericContentHandler
    extends DefaultHandler {
        private Stack<Object> fieldStack;

        @Override
        public void startDocument() {
            this.fieldStack = new Stack();
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.fieldStack.isEmpty()) {
                throw new SAXException("Format error in XML Field Description File");
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                ISOFieldPackager f;
                String id = atts.getValue("id");
                String type = atts.getValue("class");
                String name = atts.getValue("name");
                String size = atts.getValue("length");
                String pad = atts.getValue("pad");
                String token = atts.getValue("token");
                if (localName.equals("isopackager")) {
                    this.fieldStack.push(new TreeMap());
                    GenericPackager.this.setGenericPackagerParams(atts);
                }
                if (localName.equals("isofieldpackager")) {
                    String packager = atts.getValue("packager");
                    this.fieldStack.push(new Integer(id));
                    f = (ISOFieldPackager)Class.forName(type).newInstance();
                    f.setDescription(name);
                    f.setLength(Integer.parseInt(size));
                    f.setPad(Boolean.parseBoolean(pad));
                    if (f instanceof IF_TBASE) {
                        ((IF_TBASE)f).setToken(token);
                    }
                    this.fieldStack.push(f);
                    ISOBasePackager p = (ISOBasePackager)Class.forName(packager).newInstance();
                    if (p instanceof GenericPackager) {
                        GenericPackager gp = (GenericPackager)p;
                        gp.setGenericPackagerParams(atts);
                    }
                    this.fieldStack.push(p);
                    this.fieldStack.push(new TreeMap());
                }
                if (localName.equals("isofield")) {
                    Class<?> c = Class.forName(type);
                    f = (ISOFieldPackager)c.newInstance();
                    f.setDescription(name);
                    f.setLength(Integer.parseInt(size));
                    f.setPad(Boolean.parseBoolean(pad));
                    if (f instanceof IF_TBASE) {
                        ((IF_TBASE)f).setToken(token);
                    }
                    Map m = (Map)this.fieldStack.peek();
                    m.put(new Integer(id), f);
                }
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        }

        private ISOFieldPackager[] makeFieldArray(Map<Integer, ISOFieldPackager> m) {
            int maxField = 0;
            for (Map.Entry<Integer, ISOFieldPackager> ent : m.entrySet()) {
                if (ent.getKey() <= maxField) continue;
                maxField = ent.getKey();
            }
            ISOFieldPackager[] fld = new ISOFieldPackager[maxField + 1];
            for (Map.Entry<Integer, ISOFieldPackager> ent : m.entrySet()) {
                fld[ent.getKey().intValue()] = ent.getValue();
            }
            return fld;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            Map m;
            if (localName.equals("isopackager")) {
                m = (Map)this.fieldStack.pop();
                GenericPackager.this.setFieldPackager(this.makeFieldArray(m));
            }
            if (localName.equals("isofieldpackager")) {
                m = (Map)this.fieldStack.pop();
                ISOBasePackager msgPackager = (ISOBasePackager)this.fieldStack.pop();
                msgPackager.setFieldPackager(this.makeFieldArray(m));
                ISOFieldPackager fieldPackager = (ISOFieldPackager)this.fieldStack.pop();
                Integer fno = (Integer)this.fieldStack.pop();
                msgPackager.setLogger(GenericPackager.this.getLogger(), GenericPackager.this.getRealm() + "-fld-" + fno);
                ISOMsgFieldPackager mfp = new ISOMsgFieldPackager(fieldPackager, msgPackager);
                m = (Map)this.fieldStack.peek();
                m.put(fno, mfp);
            }
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }

    public static class GenericEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String file;
            if (systemId == null) {
                return null;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = cl = cl == null ? ClassLoader.getSystemClassLoader() : cl;
            if (systemId.equals("http://jpos.org/dtd/generic-packager-1.0.dtd")) {
                URL resource = cl.getResource("org/jpos/iso/packager/genericpackager.dtd");
                return new InputSource(resource.toExternalForm());
            }
            if (systemId.equals("http://jpos.org/dtd/generic-validating-packager-1.0.dtd")) {
                URL resource = cl.getResource("org/jpos/iso/packager/generic-validating-packager.dtd");
                return new InputSource(resource.toExternalForm());
            }
            URL url = new URL(systemId);
            if (url.getProtocol().equals("file") && (file = url.getFile()).endsWith(".dtd")) {
                File f = new File(file);
                InputStream res = null;
                if (f.exists()) {
                    res = new FileInputStream(f);
                }
                if (res == null) {
                    String dtdResource = "org/jpos/iso/packager/" + f.getName();
                    res = cl.getResourceAsStream(dtdResource);
                }
                if (res != null) {
                    return new InputSource(res);
                }
            }
            return null;
        }
    }
}

