/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.util.ArrayList;
import java.util.Map;
import org.jpos.iso.AsciiPrefixer;
import org.jpos.iso.ISOBasePackager;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.Prefixer;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class EuroSubFieldPackager
extends ISOBasePackager {
    protected static Prefixer tagPrefixer = AsciiPrefixer.LL;

    @Override
    protected boolean emitBitMap() {
        return false;
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        LogEvent evt = new LogEvent(this, "pack");
        try {
            int len = 0;
            Map tab = c.getChildren();
            ArrayList<byte[]> l = new ArrayList<byte[]>();
            for (Map.Entry ent : tab.entrySet()) {
                Integer i = (Integer)ent.getKey();
                if (i < 0) continue;
                if (this.fld[i] == null) {
                    throw new ISOException("Unsupported sub-field " + i + " packing field " + c.getKey());
                }
                if (!(ent.getValue() instanceof ISOComponent)) continue;
                try {
                    ISOComponent f = (ISOComponent)ent.getValue();
                    byte[] b = this.fld[i].pack(f);
                    len += b.length;
                    l.add(b);
                }
                catch (Exception e) {
                    evt.addMessage("error packing subfield " + i);
                    evt.addMessage(c);
                    evt.addMessage(e);
                    throw e;
                }
            }
            int k = 0;
            byte[] d = new byte[len];
            for (byte[] b : l) {
                System.arraycopy(b, 0, d, k, b.length);
                k += b.length;
            }
            if (this.logger != null) {
                evt.addMessage(ISOUtil.hexString(d));
            }
            return d;
        }
        catch (Exception ex) {
            throw new ISOException(ex);
        }
    }

    @Override
    public int unpack(ISOComponent m, byte[] b) throws ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        int consumed = 0;
        while (consumed < b.length) {
            int i;
            int n = i = consumed == 0 && this.fld[0] != null ? 0 : tagPrefixer.decodeLength(b, consumed);
            if (i >= this.fld.length || this.fld[i] == null) {
                throw new ISOException("Unsupported sub-field " + i + " unpacking field " + m.getKey());
            }
            ISOComponent c = this.fld[i].createComponent(i);
            consumed += this.fld[i].unpack(c, b, consumed);
            if (this.logger != null) {
                evt.addMessage("<unpack fld=\"" + i + "\" packager=\"" + this.fld[i].getClass().getName() + "\">");
                evt.addMessage("  <value>" + c.getValue().toString() + "</value>");
                evt.addMessage("</unpack>");
            }
            m.set(c);
        }
        Logger.log(evt);
        return consumed;
    }
}

