/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.util.Map;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.packager.ISOBaseValidatingPackager;
import org.jpos.iso.validator.ISOVException;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class CTCSubElementPackager
extends ISOBaseValidatingPackager {
    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        try {
            Map tab = c.getChildren();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.fld.length; ++i) {
                ISOMsg f = (ISOMsg)tab.get(i);
                if (f == null) continue;
                sb.append(ISOUtil.zeropad(f.getKey().toString(), 2) + new String(this.fld[i].pack(f)));
            }
            return sb.toString().getBytes();
        }
        catch (Exception ex) {
            throw new ISOException(this.getRealm() + ":" + ex.getMessage(), ex);
        }
    }

    @Override
    public int unpack(ISOComponent m, byte[] b) throws ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        int consumed = 0;
        int i = 0;
        while (consumed < b.length) {
            ISOComponent c = this.fld[i].createComponent(i);
            consumed += this.fld[i].unpack(c, b, consumed);
            if (this.logger != null) {
                evt.addMessage("<unpack fld=\"" + i + "\" packager=\"" + this.fld[i].getClass().getName() + "\">");
                if (c.getValue() instanceof ISOMsg) {
                    evt.addMessage(c.getValue());
                } else {
                    evt.addMessage("  <value>" + c.getValue().toString() + "</value>");
                }
                evt.addMessage("</unpack>");
            }
            m.set(c);
            ++i;
        }
        Logger.log(evt);
        return consumed;
    }

    @Override
    protected boolean emitBitMap() {
        return false;
    }

    @Override
    public ISOComponent validate(ISOComponent c) throws ISOException {
        LogEvent evt = new LogEvent(this, "validate");
        try {
            Map tab = c.getChildren();
            for (int i = 0; i < this.fldVld.length; ++i) {
                ISOMsg f = (ISOMsg)tab.get(i);
                if (f == null) continue;
                c.set(this.fldVld[i].validate(f));
            }
            ISOComponent iSOComponent = c;
            return iSOComponent;
        }
        catch (ISOVException ex) {
            if (!ex.treated()) {
                c.set(ex.getErrComponent());
                ex.setTreated(true);
            }
            evt.addMessage(ex);
            throw ex;
        }
        finally {
            Logger.log(evt);
        }
    }
}

