/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.packager;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.jpos.iso.ISOBasePackager;
import org.jpos.iso.ISOBitMap;
import org.jpos.iso.ISOBitMapPackager;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class Base1SubFieldPackager
extends ISOBasePackager {
    @Override
    protected boolean emitBitMap() {
        return this.fld[0] instanceof ISOBitMapPackager;
    }

    @Override
    protected int getFirstField() {
        return this.fld[0] instanceof ISOBitMapPackager ? 1 : 0;
    }

    @Override
    protected ISOFieldPackager getBitMapfieldPackager() {
        return this.fld[0];
    }

    @Override
    public int unpack(ISOComponent m, byte[] b) throws ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        try {
            if (m.getComposite() != m) {
                throw new ISOException("Can't call packager on non Composite");
            }
            if (this.logger != null) {
                evt.addMessage(ISOUtil.hexString(b));
            }
            int consumed = 0;
            ISOBitMap bitmap = new ISOBitMap(-1);
            BitSet bmap = null;
            int maxField = this.fld.length;
            if (this.emitBitMap()) {
                consumed += this.getBitMapfieldPackager().unpack(bitmap, b, consumed);
                bmap = (BitSet)bitmap.getValue();
                m.set(bitmap);
                maxField = bmap.size();
            }
            for (int i = this.getFirstField(); i < maxField && consumed < b.length; ++i) {
                if (bmap != null && !bmap.get(i)) continue;
                ISOComponent c = this.fld[i].createComponent(i);
                consumed += this.fld[i].unpack(c, b, consumed);
                m.set(c);
            }
            if (b.length != consumed) {
                evt.addMessage("WARNING: unpack len=" + b.length + " consumed=" + consumed);
            }
            int n = consumed;
            return n;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public byte[] pack(ISOComponent m) throws ISOException {
        LogEvent evt = new LogEvent(this, "pack");
        try {
            ISOComponent c;
            ArrayList<byte[]> l = new ArrayList<byte[]>();
            Map fields = m.getChildren();
            int len = 0;
            if (this.emitBitMap()) {
                c = (ISOComponent)fields.get(-1);
                byte[] b = this.getBitMapfieldPackager().pack(c);
                len += b.length;
                l.add(b);
            }
            for (int i = this.getFirstField(); i <= m.getMaxField(); ++i) {
                c = (ISOComponent)fields.get(i);
                if (c == null) continue;
                try {
                    byte[] b = this.fld[i].pack(c);
                    len += b.length;
                    l.add(b);
                    continue;
                }
                catch (Exception e) {
                    evt.addMessage("error packing field " + i);
                    evt.addMessage(c);
                    evt.addMessage(e);
                }
            }
            int k = 0;
            byte[] d = new byte[len];
            for (byte[] b : l) {
                System.arraycopy(b, 0, d, k, b.length);
                k += b.length;
            }
            if (this.logger != null) {
                evt.addMessage(ISOUtil.hexString(d));
            }
            byte[] byArray = d;
            return byArray;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        finally {
            Logger.log(evt);
        }
    }
}

