/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.header;

import java.io.PrintStream;
import org.jpos.iso.ISOHeader;
import org.jpos.iso.ISOUtil;
import org.jpos.util.Loggeable;

public class BaseHeader
implements ISOHeader,
Loggeable {
    private static final long serialVersionUID = 8674535007934468935L;
    protected byte[] header;
    transient boolean asciiEncoding = false;

    public BaseHeader() {
        this.header = null;
    }

    public BaseHeader(byte[] header) {
        this.unpack(header);
    }

    @Override
    public Object clone() {
        try {
            BaseHeader h = (BaseHeader)super.clone();
            if (this.header != null) {
                h.header = (byte[])this.header.clone();
            }
            return h;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public byte[] pack() {
        return this.header;
    }

    @Override
    public int unpack(byte[] header) {
        this.header = header;
        return header != null ? header.length : 0;
    }

    @Override
    public int getLength() {
        return this.header != null ? this.header.length : 0;
    }

    @Override
    public void setDestination(String dst) {
    }

    @Override
    public void setSource(String src) {
    }

    @Override
    public String getDestination() {
        return null;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public void swapDirection() {
    }

    @Override
    public void dump(PrintStream p, String indent) {
        if (this.header != null) {
            p.println(indent + "<header>" + ISOUtil.hexString(this.header) + "</header>");
        }
    }

    public void setAsciiEncoding(boolean asciiEncoding) {
        this.asciiEncoding = asciiEncoding;
    }

    public boolean isAsciiEncoding() {
        return this.asciiEncoding;
    }
}

