/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.header;

import org.jpos.iso.ISOUtil;
import org.jpos.iso.header.BaseHeader;

public class BASE1Header
extends BaseHeader {
    private static final long serialVersionUID = 6466427524726021374L;
    public static final int LENGTH = 22;

    public BASE1Header() {
        this("000000", "000000");
    }

    public BASE1Header(String source, String destination) {
        this.header = new byte[22];
        this.header[0] = 22;
        this.setHFormat(1);
        this.setFormat(2);
        this.setSource(source);
        this.setDestination(destination);
    }

    public BASE1Header(String source, String destination, int format) {
        this.header = new byte[22];
        this.header[0] = 22;
        this.setHFormat(1);
        this.setFormat(format);
        this.setSource(source);
        this.setDestination(destination);
    }

    public BASE1Header(byte[] header) {
        super(header);
    }

    @Override
    public int unpack(byte[] header) {
        this.header = header;
        return header.length;
    }

    public int getHLen() {
        return this.header[0] & 0xFF;
    }

    public void setHFormat(int hformat) {
        this.header[1] = (byte)hformat;
    }

    public int getFormat() {
        return this.header[2] & 0xFF;
    }

    public void setRtCtl(int i) {
        this.header[11] = (byte)i;
    }

    public void setFlags(int i) {
        this.header[12] = (byte)(i >> 8 & 0xFF);
        this.header[13] = (byte)(i & 0xFF);
    }

    public void setStatus(int i) {
        this.header[14] = (byte)(i >> 16 & 0xFF);
        this.header[15] = (byte)(i >> 8 & 0xFF);
        this.header[16] = (byte)(i & 0xFF);
    }

    public void setBatchNumber(int i) {
        this.header[17] = (byte)(i & 0xFF);
    }

    public void setFormat(int format) {
        this.header[2] = (byte)format;
    }

    public void setLen(int len) {
        this.header[3] = (byte)((len += this.header.length) >> 8 & 0xFF);
        this.header[4] = (byte)(len & 0xFF);
    }

    @Override
    public void setDestination(String dest) {
        byte[] d = ISOUtil.str2bcd(dest, true);
        System.arraycopy(d, 0, this.header, 5, 3);
    }

    @Override
    public void setSource(String src) {
        byte[] d = ISOUtil.str2bcd(src, true);
        System.arraycopy(d, 0, this.header, 8, 3);
    }

    @Override
    public String getSource() {
        return ISOUtil.bcd2str(this.header, 8, 6, false);
    }

    @Override
    public String getDestination() {
        return ISOUtil.bcd2str(this.header, 5, 6, false);
    }

    @Override
    public void swapDirection() {
        if (this.header != null && this.header.length >= 22) {
            byte[] source = new byte[3];
            System.arraycopy(this.header, 8, source, 0, 3);
            System.arraycopy(this.header, 5, this.header, 8, 3);
            System.arraycopy(source, 0, this.header, 5, 3);
        }
    }

    public boolean isRejected() {
        return this.getLength() >= 26 && (this.header[22] & 0x80) == 128;
    }

    public String getRejectCode() {
        return this.isRejected() ? ISOUtil.bcd2str(this.header, 24, 4, false) : "";
    }
}

