/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISORequestListener;
import org.jpos.iso.gui.ISOMsgPanel;

public class ISORequestListenerPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -1786048717180010741L;
    DefaultListModel log;
    String symbolicName;
    public static final int LOG_CAPACITY = 250;

    public ISORequestListenerPanel(ISORequestListener requestListener, String symbolicName) {
        this.symbolicName = symbolicName;
        this.setLayout(new FlowLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.log = new DefaultListModel();
        this.add(this.createPanel());
        if (requestListener instanceof Observable) {
            ((Observable)((Object)requestListener)).addObserver(this);
        }
    }

    public final String getSymbolicName() {
        return this.symbolicName;
    }

    public final ListModel getLog() {
        return this.log;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg != null && arg instanceof ISOMsg) {
            ISOMsg m = (ISOMsg)arg;
            this.log.addElement(m);
            if (this.log.getSize() > 250) {
                this.log.remove(0);
            }
        }
    }

    private JPanel createPanel() {
        JPanel A = new JPanel(){
            private static final long serialVersionUID = -6042644671679973897L;

            @Override
            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        A.setLayout(new BorderLayout());
        JLabel l = new JLabel(this.symbolicName);
        A.add((Component)l, "North");
        final JList<String> logList = new JList<String>(this.log);
        logList.setPrototypeCellValue("9999 99999999 999999");
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ISOMsg m = (ISOMsg)logList.getSelectedValue();
                if (m != null) {
                    JFrame f = new JFrame(m.toString());
                    ISOMsgPanel p = new ISOMsgPanel(m);
                    f.getContentPane().add(p);
                    f.pack();
                    f.show();
                }
            }
        };
        logList.addMouseListener(mouseListener);
        JScrollPane scrollPane = new JScrollPane(logList);
        scrollPane.setPreferredSize(new Dimension(170, 200));
        A.add((Component)scrollPane, "South");
        return A;
    }
}

