/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;

public class ISOMsgPanel
extends JPanel {
    private static final long serialVersionUID = 7779880613544725704L;
    ISOMsg m;
    Vector validFields;

    public ISOMsgPanel(ISOMsg m, boolean withDump) {
        this.m = m;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setValidFields();
        this.add((Component)this.createISOMsgTable(), "Center");
        if (withDump) {
            this.add((Component)this.createISOMsgDumpPanel(), "South");
        }
    }

    public ISOMsgPanel(ISOMsg m) {
        this(m, false);
    }

    private void setValidFields() {
        this.validFields = new Vector();
        for (int i = 0; i <= this.m.getMaxField(); ++i) {
            if (!this.m.hasField(i)) continue;
            this.validFields.addElement(i);
        }
    }

    private JComponent createISOMsgTable() {
        AbstractTableModel dataModel = new AbstractTableModel(){
            private static final long serialVersionUID = 8917029825751856951L;

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                return ISOMsgPanel.this.validFields.size();
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return "#";
                    }
                    case 1: {
                        return "Content";
                    }
                    case 2: {
                        return "Description";
                    }
                }
                return "";
            }

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return ISOMsgPanel.this.validFields.elementAt(row);
                    }
                    case 1: {
                        try {
                            int index = (Integer)ISOMsgPanel.this.validFields.elementAt(row);
                            Object obj = ISOMsgPanel.this.m.getValue(index);
                            if (obj instanceof String) {
                                return obj.toString();
                            }
                            if (obj instanceof byte[]) {
                                return ISOUtil.hexString((byte[])obj);
                            }
                            if (obj instanceof ISOMsg) {
                                return "<ISOMsg>";
                            }
                        }
                        catch (ISOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 2: {
                        int i = (Integer)ISOMsgPanel.this.validFields.elementAt(row);
                        ISOPackager p = ISOMsgPanel.this.m.getPackager();
                        return p.getFieldDescription(ISOMsgPanel.this.m, i);
                    }
                }
                return "<???>";
            }
        };
        JTable table = new JTable(dataModel);
        table.getColumnModel().getColumn(0).setPreferredWidth(10);
        table.setPreferredScrollableViewportSize(new Dimension(500, table.getRowCount() * table.getRowHeight()));
        table.setSelectionMode(0);
        ListSelectionModel rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    try {
                        int index = (Integer)ISOMsgPanel.this.validFields.elementAt(selectedRow);
                        Object obj = ISOMsgPanel.this.m.getValue(index);
                        if (obj instanceof ISOMsg) {
                            ISOMsg sm = (ISOMsg)obj;
                            JFrame f = new JFrame("ISOMsg field " + index);
                            ISOMsgPanel p = new ISOMsgPanel(sm, false);
                            f.getContentPane().add(p);
                            f.pack();
                            f.show();
                        }
                    }
                    catch (ISOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        return new JScrollPane(table);
    }

    JComponent createISOMsgDumpPanel() {
        JPanel p = new JPanel();
        JTextArea t = new JTextArea(3, 20);
        p.setLayout(new BorderLayout());
        p.setBackground(Color.white);
        p.setBorder(BorderFactory.createLoweredBevelBorder());
        p.add((Component)new JLabel("Dump", 2), "North");
        t.setFont(new Font("Helvetica", 0, 8));
        t.setLineWrap(true);
        try {
            StringBuilder buf = new StringBuilder();
            if (this.m.getHeader() != null) {
                buf.append("--[Header]--\n");
                buf.append(ISOUtil.hexString(this.m.getHeader()));
                buf.append("\n--[Msg]--\n");
            }
            byte[] b = this.m.pack();
            buf.append(ISOUtil.hexString(b));
            t.setText(buf.toString());
        }
        catch (ISOException e) {
            t.setText(e.toString());
            t.setForeground(Color.red);
        }
        p.add((Component)t, "Center");
        return p;
    }
}

