/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.gui.ISOChannelPanel;
import org.jpos.iso.gui.ISOMsgPanel;

public class ISOMeter
extends JComponent
implements Runnable {
    private static final long serialVersionUID = -1770533267122111538L;
    Color color = new Color(255, 255, 255);
    Image im;
    Graphics img;
    Font fontBig;
    Font fontSmall;
    String positiveText;
    String negativeText;
    Timer ti;
    String positiveCounter;
    String negativeCounter;
    int lastPositive;
    int lastNegative;
    boolean connected;
    ISOChannelPanel parent;
    static final int width = 200;
    static final int height = 60;
    static final int mass = 30;
    static final int MAX_VALUE = 1000;
    int[] yPoints;
    int[] xPoints;
    int continueScroll;
    boolean scroll = true;
    int refreshPanel = 50;
    private Image imb;
    private Thread repaintThread;

    public ISOMeter(ISOChannelPanel parent) {
        this.parent = parent;
        this.fontBig = new Font("Helvetica", 2, 22);
        this.fontSmall = new Font("Helvetica", 0, 10);
        this.yPoints = new int[200];
        this.xPoints = new int[200];
        for (int i = 0; i < 200; ++i) {
            this.xPoints[i] = i;
            this.yPoints[i] = 30;
        }
        this.positiveText = null;
        this.negativeText = null;
        this.negativeCounter = "";
        this.positiveCounter = "";
        this.connected = false;
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ISOMeter.this.showLogList();
            }
        };
        this.addMouseListener(mouseListener);
    }

    public synchronized void start() {
        if (this.repaintThread == null) {
            this.repaintThread = new Thread((Runnable)this, "ISOMeter");
            this.repaintThread.setPriority(4);
            this.repaintThread.start();
        }
    }

    public void showLogList() {
        JFrame f = new JFrame(this.parent.getSymbolicName());
        f.getContentPane().add(this.createLogList());
        f.setDefaultCloseOperation(2);
        f.validate();
        f.pack();
        f.setSize(200, 250);
        f.show();
    }

    public JComponent createLogList() {
        final JList<String> logList = new JList<String>(this.parent.getLog());
        JPanel A = new JPanel();
        A.setLayout(new BorderLayout());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ISOMsg m = (ISOMsg)logList.getSelectedValue();
                if (m != null) {
                    JFrame f = new JFrame(ISOMeter.this.parent.getSymbolicName() + ":" + m.toString());
                    ISOMsgPanel p = new ISOMsgPanel(m);
                    f.getContentPane().add(p);
                    f.setDefaultCloseOperation(2);
                    f.pack();
                    f.show();
                }
            }
        };
        logList.addMouseListener(mouseListener);
        logList.setPrototypeCellValue("9999 99999999 999999");
        JScrollPane scrollPane = new JScrollPane(logList);
        A.add((Component)scrollPane, "Center");
        return A;
    }

    public void setValue(int val) {
        int y;
        this.yPoints[199] = y = 30 - val % 1000 * 60 / 2000;
        this.continueScroll = 200;
        this.scroll();
    }

    public void setScroll(boolean scroll) {
        this.scroll = scroll;
    }

    public void setRefresh(int refreshPanel) {
        if (refreshPanel > 0) {
            this.refreshPanel = refreshPanel;
        }
    }

    public void setConnected(boolean connected) {
        if (this.connected != connected) {
            if (!this.scroll) {
                this.continueScroll = connected ? 200 : 1;
            }
            this.repaint();
        }
        this.connected = connected;
    }

    public void setPositiveCounter(String s) {
        this.positiveCounter = s;
    }

    public void setNegativeCounter(String s) {
        this.negativeCounter = s;
    }

    public void setValue(int val, String textString) {
        this.setValue(val);
        if (val < 0) {
            this.negativeText = textString;
            this.lastNegative = 0;
        } else {
            this.positiveText = textString;
            this.lastPositive = 0;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.repaintThread == null) {
            this.start();
        }
        this.plot();
        g.drawImage(this.im, 0, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 60);
    }

    private void scroll() {
        System.arraycopy(this.yPoints, 1, this.yPoints, 0, 199);
        if (this.continueScroll > 0) {
            --this.continueScroll;
        }
    }

    public void plot() {
        if (this.im == null) {
            this.im = this.createImage(200, 60);
            this.img = this.im.getGraphics();
            this.img.setColor(Color.black);
            this.img.fillRoundRect(0, 0, 200, 60, 10, 10);
            this.img.clipRect(0, 0, 200, 60);
            this.plotGrid();
            this.imb = this.createImage(200, 60);
            Graphics imbCopy = this.imb.getGraphics();
            imbCopy.drawImage(this.im, 0, 0, this);
        }
        this.img.drawImage(this.imb, 0, 0, this);
        if (this.continueScroll > 0) {
            this.scroll();
        }
        this.plotText(this.positiveText, this.lastPositive++, 3, 27);
        this.plotText(this.negativeText, this.lastNegative++, 3, 57);
        this.plotCounters(this.positiveCounter, this.negativeCounter);
        this.img.setColor(this.connected ? Color.green : Color.red);
        this.img.drawPolyline(this.xPoints, this.yPoints, 200);
    }

    private void plotGrid() {
        int i;
        this.img.setColor(Color.blue);
        for (i = 0; i < 200; ++i) {
            if (i % 20 != 0) continue;
            this.img.drawLine(i, 0, i, 60);
        }
        for (i = -1000; i < 1000; i += 200) {
            int y = 30 + i * 60 / 2000;
            this.img.drawLine(0, y, 200, y);
        }
    }

    private void plotText(String t, int l, int x, int y) {
        if (t != null && l < 20) {
            this.img.setColor(Color.lightGray);
            this.img.setFont(this.fontBig);
            this.img.drawString(t, x, y);
        }
    }

    private void plotCounters(String p, String n) {
        this.img.setColor(Color.lightGray);
        this.img.setFont(this.fontSmall);
        this.img.drawString(p, 145, 13);
        this.img.drawString(n, 145, 57);
    }

    @Override
    public void run() {
        while (this.isShowing()) {
            if (this.continueScroll > 0) {
                this.repaint();
            }
            try {
                Thread.sleep(this.refreshPanel);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.repaintThread = null;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

