/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOServer;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.gui.ISOMeter;

public class ISOChannelPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -8069489863639386589L;
    ISOMeter meter;
    DefaultListModel log;
    String symbolicName;
    private int[] protectFields = null;
    private int[] wipeFields = null;
    public static final int LOG_CAPACITY = 250;

    public ISOChannelPanel(ISOChannel channel, String symbolicName) {
        this.symbolicName = symbolicName;
        this.setLayout(new FlowLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.log = new DefaultListModel();
        this.add(this.createCountersPanel());
        this.meter.setConnected(channel.isConnected());
        if (channel instanceof Observable) {
            ((Observable)((Object)channel)).addObserver(this);
        }
    }

    public ISOChannelPanel(String symbolicName) {
        this.symbolicName = symbolicName;
        this.setLayout(new FlowLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.log = new DefaultListModel();
        this.add(this.createCountersPanel());
        this.meter.setConnected(false);
    }

    public final String getSymbolicName() {
        return this.symbolicName;
    }

    public final ListModel getLog() {
        return this.log;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg != null && arg instanceof ISOMsg) {
            ISOMsg m = (ISOMsg)arg;
            try {
                String mti = (String)m.getValue(0);
                int imti = Integer.parseInt(mti);
                if (m.isIncoming()) {
                    this.meter.setValue(-imti, mti);
                } else {
                    this.meter.setValue(imti, mti);
                }
                this.log.addElement(this.getProtectedClone(m));
                if (this.log.getSize() > 250) {
                    this.log.remove(0);
                }
            }
            catch (ISOException e) {
                this.meter.setValue(30, "ERROR");
            }
            this.meter.setValue(30);
        }
        if (o instanceof BaseChannel) {
            BaseChannel c = (BaseChannel)o;
            this.meter.setConnected(c.isConnected());
            int[] cnt = c.getCounters();
            try {
                this.meter.setPositiveCounter(ISOUtil.zeropad(Integer.toString(cnt[1]), 9));
                this.meter.setNegativeCounter(ISOUtil.zeropad(Integer.toString(cnt[2] % 1000000000), 9));
            }
            catch (ISOException e) {}
        } else if (o instanceof ISOServer) {
            final ISOServer server = (ISOServer)o;
            Runnable updateIt = new Runnable(){

                @Override
                public void run() {
                    ISOUtil.sleep(250L);
                    int active = server.getActiveConnections();
                    ISOChannelPanel.this.meter.setConnected(active > 0);
                    try {
                        ISOChannelPanel.this.meter.setPositiveCounter(ISOUtil.zeropad(Integer.toString(active), 6));
                    }
                    catch (ISOException iSOException) {
                        // empty catch block
                    }
                    ISOChannelPanel.this.meter.repaint();
                }
            };
            SwingUtilities.invokeLater(updateIt);
        } else {
            this.meter.setConnected(true);
        }
    }

    public ISOMeter getISOMeter() {
        return this.meter;
    }

    public void setProtectFields(int[] fields) {
        this.protectFields = fields;
    }

    public void setWipeFields(int[] fields) {
        this.wipeFields = fields;
    }

    private JPanel createCountersPanel() {
        JPanel A = new JPanel(){
            private static final long serialVersionUID = 1175437215105556679L;

            @Override
            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        A.setLayout(new BorderLayout());
        this.meter = new ISOMeter(this);
        JLabel l = new JLabel(this.symbolicName);
        A.add((Component)l, "North");
        A.add((Component)this.meter, "Center");
        return A;
    }

    private ISOMsg getProtectedClone(ISOMsg m) throws ISOException {
        ISOMsg pm = (ISOMsg)m.clone();
        if (this.protectFields != null) {
            this.checkProtected(pm);
        }
        if (this.wipeFields != null) {
            this.checkHidden(pm);
        }
        return pm;
    }

    private void checkProtected(ISOMsg m) throws ISOException {
        for (int f : this.protectFields) {
            if (!m.hasField(f)) continue;
            m.set(f, ISOUtil.protect(m.getString(f)));
        }
    }

    private void checkHidden(ISOMsg m) throws ISOException {
        for (int f : this.wipeFields) {
            if (!m.hasField(f)) continue;
            m.set(f, "[WIPED]");
        }
    }
}

