/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.packager.XMLPackager;
import org.jpos.util.LogEvent;

public class XSLTFilter
implements ISOFilter,
Configurable {
    boolean reread = true;
    String xsltfile;
    TransformerFactory tfactory;
    Transformer transformer = null;
    XMLPackager packager = new XMLPackager();

    public XSLTFilter() throws ISOException {
        this.tfactory = TransformerFactory.newInstance();
    }

    public XSLTFilter(String xsltfile, boolean reread) throws ISOException {
        this();
        try {
            this.xsltfile = xsltfile;
            this.reread = reread;
            this.transformer = this.tfactory.newTransformer(new StreamSource(xsltfile));
        }
        catch (TransformerConfigurationException e) {
            throw new ISOException(e);
        }
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        try {
            this.transformer = this.tfactory.newTransformer(new StreamSource(cfg.get("xsltfile")));
            String s = cfg.get("reread");
            this.reread = s == null || s.equals("no");
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public ISOMsg filter(ISOChannel channel, ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        try {
            m.setPackager(this.packager);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (this.reread || this.transformer == null) {
                this.transformer = this.tfactory.newTransformer(new StreamSource(this.xsltfile));
            }
            this.transformer.transform(new StreamSource(new ByteArrayInputStream(m.pack())), new StreamResult(os));
            m.unpack(os.toByteArray());
        }
        catch (Exception e) {
            throw new ISOFilter.VetoException(e);
        }
        return m;
    }
}

