/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.filter;

import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOUtil;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.util.LogEvent;

public class StatefulFilter
implements ISOFilter,
Configurable {
    private Space space = SpaceFactory.getSpace();
    private String keyPrefix = "" + this.hashCode();
    private boolean vetoUnmatched;
    private int[] key = new int[]{11, 41};
    private int matchDirection = 1;
    private int[] ignoredFields = new int[0];
    private int[] savedFields = new int[0];
    private static final long TIMEOUT = 60000L;
    private long timeout = 60000L;
    private boolean overwriteOriginalFields;

    protected Space getSpace() {
        return this.space;
    }

    protected void setSpace(Space space) {
        this.space = space;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.setVetoUnmatched(cfg.getBoolean("veto-unmatched"));
        this.setSpace(cfg.get("space", ""));
        this.setKeyPrefix(cfg.get("key-prefix", "" + this.hashCode()));
        this.setTimeout(cfg.getLong("timeout", 60000L));
        this.setOverwriteOriginalFields(cfg.getBoolean("overwrite-original-fields", true));
        int dir = cfg.get("direction", "incoming").equals("incoming") ? 1 : 2;
        this.setMatchDirection(dir);
        this.setKey(ISOUtil.toIntArray(cfg.get("key", "11 41")));
        this.setSavedFields(ISOUtil.toIntArray(cfg.get("saved-fields", "")));
        this.setIgnoredFields(ISOUtil.toIntArray(cfg.get("ignored-fields", "")));
    }

    public void setSpace(String uri) {
        this.setSpace(SpaceFactory.getSpace(uri));
    }

    @Override
    public ISOMsg filter(ISOChannel iSOChannel, ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        int[] key = this.getKey();
        StringBuilder b = new StringBuilder(this.getKeyPrefix());
        for (int aKey : key) {
            b.append("|");
            b.append(m.getString(aKey));
        }
        String skey = b.toString();
        if (m.getDirection() == this.getMatchDirection()) {
            int[] savedFields = this.getSavedFields();
            ISOMsg saved = (ISOMsg)(savedFields != null && savedFields.length != 0 ? m.clone(savedFields) : m.clone());
            int[] ignoredFields = this.getIgnoredFields();
            if (ignoredFields != null) {
                saved.unset(ignoredFields);
            }
            this.getSpace().out(skey, saved, this.getTimeout());
            return m;
        }
        ISOMsg saved = (ISOMsg)this.getSpace().inp(skey);
        if (saved == null && this.isVetoUnmatched()) {
            throw new ISOFilter.VetoException("unmatched iso message");
        }
        if (saved != null) {
            if (!this.isOverwriteOriginalFields()) {
                m.merge(saved);
            } else {
                saved.merge(m);
                m = saved;
            }
        }
        return m;
    }

    public boolean isVetoUnmatched() {
        return this.vetoUnmatched;
    }

    public void setVetoUnmatched(boolean vetoUnmatched) {
        this.vetoUnmatched = vetoUnmatched;
    }

    public int getMatchDirection() {
        return this.matchDirection;
    }

    public void setMatchDirection(int matchDirection) {
        this.matchDirection = matchDirection;
    }

    public int getIgnoredField(int index) {
        return this.ignoredFields[index];
    }

    public int[] getIgnoredFields() {
        return this.ignoredFields;
    }

    public void setIgnoredField(int index, int ignoredFields) {
        this.ignoredFields[index] = ignoredFields;
    }

    public void setIgnoredFields(int[] ignoredFields) {
        this.ignoredFields = ignoredFields;
    }

    public int getSavedField(int index) {
        return this.savedFields[index];
    }

    public int[] getSavedFields() {
        return this.savedFields;
    }

    public void setSavedField(int index, int savedFields) {
        this.savedFields[index] = savedFields;
    }

    public void setSavedFields(int[] savedFields) {
        this.savedFields = savedFields;
    }

    public int getKey(int index) {
        return this.key[index];
    }

    public int[] getKey() {
        return this.key;
    }

    public void setKey(int index, int key) {
        this.key[index] = key;
    }

    public void setKey(int[] key) {
        this.key = key;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isOverwriteOriginalFields() {
        return this.overwriteOriginalFields;
    }

    public void setOverwriteOriginalFields(boolean overwriteOriginalFields) {
        this.overwriteOriginalFields = overwriteOriginalFields;
    }
}

