/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.filter;

import java.util.Date;
import java.util.TimeZone;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.core.Sequencer;
import org.jpos.core.VolatileSequencer;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISODate;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.NameRegistrar;

public class MacroFilter
implements ISOFilter,
Configurable {
    Sequencer seq;
    Configuration cfg;
    int[] unsetFields = new int[0];
    int[] validFields = new int[0];

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        try {
            String seqName = cfg.get("sequencer", null);
            this.unsetFields = ISOUtil.toIntArray(cfg.get("unset", ""));
            this.validFields = ISOUtil.toIntArray(cfg.get("valid", ""));
            if (seqName != null) {
                this.seq = (Sequencer)NameRegistrar.get("sequencer." + cfg.get("sequencer"));
            } else if (this.seq == null) {
                this.seq = new VolatileSequencer();
            }
        }
        catch (NameRegistrar.NotFoundException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public ISOMsg filter(ISOChannel channel, ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        try {
            this.applyProps(m);
            if (this.validFields.length > 0) {
                m = (ISOMsg)m.clone(this.validFields);
            }
            if (this.unsetFields.length > 0) {
                m.unset(this.unsetFields);
            }
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw new ISOFilter.VetoException(e);
        }
        return m;
    }

    private void applyProps(ISOMsg m) throws ISOException {
        int maxField = m.getMaxField();
        for (int i = 0; i <= maxField; ++i) {
            String p;
            String value;
            Object o = null;
            if (m.hasField(i)) {
                o = m.getValue(i);
            }
            if (!(o instanceof String) || (value = (String)o).length() == 0) continue;
            if (value.equalsIgnoreCase("$date")) {
                m.set(new ISOField(i, ISODate.getDateTime(new Date())));
                continue;
            }
            if (value.toLowerCase().startsWith("$date") && value.contains("GMT")) {
                String zoneID = value.substring(value.indexOf("GMT"));
                m.set(new ISOField(i, ISODate.getDateTime(new Date(), TimeZone.getTimeZone(zoneID))));
                continue;
            }
            if (value.charAt(0) == '#') {
                m.set(new ISOField(i, ISOUtil.zeropad(Integer.toString(this.seq.get(value.substring(1))), 6)));
                continue;
            }
            if (value.charAt(0) != '$' || (p = this.cfg.get(value.substring(1), null)) == null) continue;
            m.set(new ISOField(i, p));
        }
    }
}

